/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.v1.messaging.message;

import java.util.HashMap;
import java.util.Map;
import org.neo4j.bolt.v1.messaging.BoltRequestMessageHandler;
import org.neo4j.bolt.v1.messaging.message.RequestMessage;

public class RunMessage
implements RequestMessage {
    private static Map<String, Object> EMPTY_PARAMETERS = new HashMap<String, Object>();
    private final String statement;
    private final Map<String, Object> params;

    public static RunMessage run(String statement, Map<String, Object> parameters) {
        return new RunMessage(statement, parameters);
    }

    public static RunMessage run(String statement) {
        return RunMessage.run(statement, EMPTY_PARAMETERS);
    }

    private RunMessage(String statement, Map<String, Object> params) {
        this.statement = statement;
        this.params = params;
    }

    public Map<String, Object> params() {
        return this.params;
    }

    public String statement() {
        return this.statement;
    }

    @Override
    public <E extends Exception> void dispatch(BoltRequestMessageHandler<E> consumer) throws E {
        consumer.onRun(this.statement, this.params);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RunMessage that = (RunMessage)o;
        return this.params.equals(that.params) && this.statement.equals(that.statement);
    }

    public int hashCode() {
        int result = this.statement.hashCode();
        result = 31 * result + this.params.hashCode();
        return result;
    }

    public String toString() {
        return "RunMessage{statement='" + this.statement + '\'' + ", params=" + this.params + '}';
    }
}

