/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.v1.messaging.infrastructure;

import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Test;
import org.neo4j.bolt.v1.messaging.example.Nodes;
import org.neo4j.bolt.v1.messaging.example.Paths;
import org.neo4j.bolt.v1.messaging.example.Relationships;
import org.neo4j.bolt.v1.messaging.example.Support;
import org.neo4j.graphdb.Path;
import org.neo4j.graphdb.Relationship;

public class ValuePathTest {
    @Test
    public void canConstructPathWithLengthZero() {
        Path path = Paths.PATH_WITH_LENGTH_ZERO;
        MatcherAssert.assertThat((Object)path.length(), (Matcher)CoreMatchers.equalTo((Object)0));
        MatcherAssert.assertThat((Object)path.startNode(), (Matcher)CoreMatchers.equalTo((Object)Nodes.ALICE));
        MatcherAssert.assertThat((Object)path.endNode(), (Matcher)CoreMatchers.equalTo((Object)Nodes.ALICE));
        MatcherAssert.assertThat(Support.nodes(path), (Matcher)CoreMatchers.equalTo(Support.nodes(Nodes.ALICE)));
        MatcherAssert.assertThat((Object)path.lastRelationship(), (Matcher)CoreMatchers.nullValue());
        MatcherAssert.assertThat(Support.relationships(path), (Matcher)CoreMatchers.equalTo(Support.relationships(new Relationship[0])));
    }

    @Test
    public void canConstructPathWithLengthOne() {
        Path path = Paths.PATH_WITH_LENGTH_ONE;
        MatcherAssert.assertThat((Object)path.length(), (Matcher)CoreMatchers.equalTo((Object)1));
        MatcherAssert.assertThat((Object)path.startNode(), (Matcher)CoreMatchers.equalTo((Object)Nodes.ALICE));
        MatcherAssert.assertThat((Object)path.endNode(), (Matcher)CoreMatchers.equalTo((Object)Nodes.BOB));
        MatcherAssert.assertThat(Support.nodes(path), (Matcher)CoreMatchers.equalTo(Support.nodes(Nodes.ALICE, Nodes.BOB)));
        MatcherAssert.assertThat((Object)path.lastRelationship(), (Matcher)CoreMatchers.equalTo((Object)Relationships.ALICE_KNOWS_BOB));
        MatcherAssert.assertThat(Support.relationships(path), (Matcher)CoreMatchers.equalTo(Support.relationships(Relationships.ALICE_KNOWS_BOB)));
    }

    @Test
    public void canConstructPathWithLengthTwo() {
        Path path = Paths.PATH_WITH_LENGTH_TWO;
        MatcherAssert.assertThat((Object)path.length(), (Matcher)CoreMatchers.equalTo((Object)2));
        MatcherAssert.assertThat((Object)path.startNode(), (Matcher)CoreMatchers.equalTo((Object)Nodes.ALICE));
        MatcherAssert.assertThat((Object)path.endNode(), (Matcher)CoreMatchers.equalTo((Object)Nodes.DAVE));
        MatcherAssert.assertThat(Support.nodes(path), (Matcher)CoreMatchers.equalTo(Support.nodes(Nodes.ALICE, Nodes.CAROL, Nodes.DAVE)));
        MatcherAssert.assertThat((Object)path.lastRelationship(), (Matcher)CoreMatchers.equalTo((Object)Relationships.CAROL_MARRIED_TO_DAVE));
        MatcherAssert.assertThat(Support.relationships(path), (Matcher)CoreMatchers.equalTo(Support.relationships(Relationships.ALICE_LIKES_CAROL, Relationships.CAROL_MARRIED_TO_DAVE)));
    }

    @Test
    public void canConstructPathWithRelationshipTraversedAgainstItsDirection() {
        Path path = Paths.PATH_WITH_RELATIONSHIP_TRAVERSED_AGAINST_ITS_DIRECTION;
        MatcherAssert.assertThat((Object)path.length(), (Matcher)CoreMatchers.equalTo((Object)3));
        MatcherAssert.assertThat((Object)path.startNode(), (Matcher)CoreMatchers.equalTo((Object)Nodes.ALICE));
        MatcherAssert.assertThat((Object)path.endNode(), (Matcher)CoreMatchers.equalTo((Object)Nodes.DAVE));
        MatcherAssert.assertThat(Support.nodes(path), (Matcher)CoreMatchers.equalTo(Support.nodes(Nodes.ALICE, Nodes.BOB, Nodes.CAROL, Nodes.DAVE)));
        MatcherAssert.assertThat((Object)path.lastRelationship(), (Matcher)CoreMatchers.equalTo((Object)Relationships.CAROL_MARRIED_TO_DAVE));
        MatcherAssert.assertThat(Support.relationships(path), (Matcher)CoreMatchers.equalTo(Support.relationships(Relationships.ALICE_KNOWS_BOB, Relationships.CAROL_DISLIKES_BOB, Relationships.CAROL_MARRIED_TO_DAVE)));
    }

    @Test
    public void canConstructPathWithNodesVisitedMultipleTimes() {
        Path path = Paths.PATH_WITH_NODES_VISITED_MULTIPLE_TIMES;
        MatcherAssert.assertThat((Object)path.length(), (Matcher)CoreMatchers.equalTo((Object)5));
        MatcherAssert.assertThat((Object)path.startNode(), (Matcher)CoreMatchers.equalTo((Object)Nodes.ALICE));
        MatcherAssert.assertThat((Object)path.endNode(), (Matcher)CoreMatchers.equalTo((Object)Nodes.CAROL));
        MatcherAssert.assertThat(Support.nodes(path), (Matcher)CoreMatchers.equalTo(Support.nodes(Nodes.ALICE, Nodes.BOB, Nodes.ALICE, Nodes.CAROL, Nodes.BOB, Nodes.CAROL)));
        MatcherAssert.assertThat((Object)path.lastRelationship(), (Matcher)CoreMatchers.equalTo((Object)Relationships.CAROL_DISLIKES_BOB));
        MatcherAssert.assertThat(Support.relationships(path), (Matcher)CoreMatchers.equalTo(Support.relationships(Relationships.ALICE_KNOWS_BOB, Relationships.ALICE_KNOWS_BOB, Relationships.ALICE_LIKES_CAROL, Relationships.CAROL_DISLIKES_BOB, Relationships.CAROL_DISLIKES_BOB)));
    }

    @Test
    public void canConstructPathWithRelationshipTraversedMultipleTimesInSameDirection() {
        Path path = Paths.PATH_WITH_RELATIONSHIP_TRAVERSED_MULTIPLE_TIMES_IN_SAME_DIRECTION;
        MatcherAssert.assertThat((Object)path.length(), (Matcher)CoreMatchers.equalTo((Object)5));
        MatcherAssert.assertThat((Object)path.startNode(), (Matcher)CoreMatchers.equalTo((Object)Nodes.ALICE));
        MatcherAssert.assertThat((Object)path.endNode(), (Matcher)CoreMatchers.equalTo((Object)Nodes.DAVE));
        MatcherAssert.assertThat(Support.nodes(path), (Matcher)CoreMatchers.equalTo(Support.nodes(Nodes.ALICE, Nodes.CAROL, Nodes.BOB, Nodes.ALICE, Nodes.CAROL, Nodes.DAVE)));
        MatcherAssert.assertThat((Object)path.lastRelationship(), (Matcher)CoreMatchers.equalTo((Object)Relationships.CAROL_MARRIED_TO_DAVE));
        MatcherAssert.assertThat(Support.relationships(path), (Matcher)CoreMatchers.equalTo(Support.relationships(Relationships.ALICE_LIKES_CAROL, Relationships.CAROL_DISLIKES_BOB, Relationships.ALICE_KNOWS_BOB, Relationships.ALICE_LIKES_CAROL, Relationships.CAROL_MARRIED_TO_DAVE)));
    }

    @Test
    public void canConstructPathWithLoop() {
        Path path = Paths.PATH_WITH_LOOP;
        MatcherAssert.assertThat((Object)path.length(), (Matcher)CoreMatchers.equalTo((Object)2));
        MatcherAssert.assertThat((Object)path.startNode(), (Matcher)CoreMatchers.equalTo((Object)Nodes.CAROL));
        MatcherAssert.assertThat((Object)path.endNode(), (Matcher)CoreMatchers.equalTo((Object)Nodes.DAVE));
        MatcherAssert.assertThat(Support.nodes(path), (Matcher)CoreMatchers.equalTo(Support.nodes(Nodes.CAROL, Nodes.DAVE, Nodes.DAVE)));
        MatcherAssert.assertThat((Object)path.lastRelationship(), (Matcher)CoreMatchers.equalTo((Object)Relationships.DAVE_WORKS_FOR_DAVE));
        MatcherAssert.assertThat(Support.relationships(path), (Matcher)CoreMatchers.equalTo(Support.relationships(Relationships.CAROL_MARRIED_TO_DAVE, Relationships.DAVE_WORKS_FOR_DAVE)));
    }
}

