/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.v1.messaging.example;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Path;
import org.neo4j.graphdb.Relationship;

public class Support {
    public static final List<Label> NO_LABELS = new ArrayList<Label>();
    public static final Map<String, Object> NO_PROPERTIES = new HashMap<String, Object>();

    private Support() {
    }

    public static Collection<Label> labels(Node node) {
        ArrayList<Label> labels = new ArrayList<Label>();
        for (Label label : node.getLabels()) {
            labels.add(label);
        }
        return labels;
    }

    public static List<Node> nodes(Node ... nodes) {
        return new ArrayList<Node>(Arrays.asList(nodes));
    }

    public static List<Node> nodes(Path path) {
        ArrayList<Node> nodes = new ArrayList<Node>(path.length() + 1);
        for (Node node : path.nodes()) {
            nodes.add(node);
        }
        return nodes;
    }

    public static List<Relationship> relationships(Relationship ... relationships) {
        return new ArrayList<Relationship>(Arrays.asList(relationships));
    }

    public static List<Relationship> relationships(Path path) {
        ArrayList<Relationship> relationships = new ArrayList<Relationship>(path.length());
        for (Relationship relationship : path.relationships()) {
            relationships.add(relationship);
        }
        return relationships;
    }

    public static List<Integer> sequence(Integer ... integers) {
        return new ArrayList<Integer>(Arrays.asList(integers));
    }
}

