/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.v1.messaging;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.mockito.Mockito;
import org.neo4j.bolt.v1.messaging.BoltIOException;
import org.neo4j.bolt.v1.messaging.Neo4jPack;
import org.neo4j.bolt.v1.messaging.example.Nodes;
import org.neo4j.bolt.v1.messaging.example.Paths;
import org.neo4j.bolt.v1.messaging.example.Relationships;
import org.neo4j.bolt.v1.packstream.PackInput;
import org.neo4j.bolt.v1.packstream.PackOutput;
import org.neo4j.bolt.v1.packstream.PackedInputArray;
import org.neo4j.bolt.v1.packstream.PackedOutputArray;
import org.neo4j.bolt.v1.runtime.Neo4jError;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.NotFoundException;
import org.neo4j.graphdb.Path;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.kernel.impl.util.HexPrinter;

public class Neo4jPackTest {
    @Rule
    public ExpectedException exception = ExpectedException.none();

    private byte[] packed(Object object) throws IOException {
        PackedOutputArray output = new PackedOutputArray();
        Neo4jPack.Packer packer = new Neo4jPack.Packer((PackOutput)output);
        packer.pack(object);
        return output.bytes();
    }

    private Object unpacked(byte[] bytes) throws IOException {
        PackedInputArray input = new PackedInputArray(bytes);
        Neo4jPack.Unpacker unpacker = new Neo4jPack.Unpacker((PackInput)input);
        return unpacker.unpack();
    }

    @Test
    public void shouldBeAbleToPackAndUnpackListStream() throws IOException {
        PackedOutputArray output = new PackedOutputArray();
        Neo4jPack.Packer packer = new Neo4jPack.Packer((PackOutput)output);
        packer.packListStreamHeader();
        ArrayList<String> expected = new ArrayList<String>();
        for (Label label : Nodes.ALICE.getLabels()) {
            String labelName = label.name();
            packer.pack(labelName);
            expected.add(labelName);
        }
        packer.packEndOfStream();
        Object unpacked = this.unpacked(output.bytes());
        MatcherAssert.assertThat((Object)unpacked, (Matcher)CoreMatchers.instanceOf(List.class));
        List unpackedList = (List)unpacked;
        MatcherAssert.assertThat((Object)unpackedList, (Matcher)CoreMatchers.equalTo(expected));
    }

    @Test
    public void shouldBeAbleToPackAndUnpackMapStream() throws IOException {
        PackedOutputArray output = new PackedOutputArray();
        Neo4jPack.Packer packer = new Neo4jPack.Packer((PackOutput)output);
        packer.packMapStreamHeader();
        for (Map.Entry entry : Nodes.ALICE.getAllProperties().entrySet()) {
            packer.pack((String)entry.getKey());
            packer.pack(entry.getValue());
        }
        packer.packEndOfStream();
        Object unpacked = this.unpacked(output.bytes());
        MatcherAssert.assertThat((Object)unpacked, (Matcher)CoreMatchers.instanceOf(Map.class));
        Map unpackedMap = (Map)unpacked;
        MatcherAssert.assertThat((Object)unpackedMap, (Matcher)CoreMatchers.equalTo((Object)Nodes.ALICE.getAllProperties()));
    }

    @Test
    public void shouldFailWhenTryingToPackAndUnpackMapStreamContainingNullKeys() throws IOException {
        PackedOutputArray output = new PackedOutputArray();
        Neo4jPack.Packer packer = new Neo4jPack.Packer((PackOutput)output);
        packer.packMapStreamHeader();
        HashMap<String, Long> map = new HashMap<String, Long>();
        map.put(null, 42L);
        map.put("foo", 1337L);
        for (Map.Entry entry : map.entrySet()) {
            packer.pack((String)entry.getKey());
            packer.pack(entry.getValue());
        }
        packer.packEndOfStream();
        PackedInputArray input = new PackedInputArray(output.bytes());
        Neo4jPack.Unpacker unpacker = new Neo4jPack.Unpacker((PackInput)input);
        unpacker.unpack();
        MatcherAssert.assertThat(unpacker.consumeError().get(), (Matcher)CoreMatchers.equalTo((Object)Neo4jError.from((Status)Status.Request.Invalid, (String)"Value `null` is not supported as key in maps, must be a non-nullable string.")));
    }

    @Test
    public void shouldFailWhenNullKeysInMaps() throws IOException {
        PackedOutputArray output = new PackedOutputArray();
        Neo4jPack.Packer packer = new Neo4jPack.Packer((PackOutput)output);
        HashMap<String, Long> map = new HashMap<String, Long>();
        map.put(null, 42L);
        map.put("foo", 1337L);
        packer.pack(map);
        Assert.assertTrue((boolean)packer.hasErrors());
    }

    @Test
    public void shouldFailNicelyWhenPackingAMapWithUnpackableValues() throws IOException {
        PackedOutputArray output = new PackedOutputArray();
        Neo4jPack.Packer packer = new Neo4jPack.Packer((PackOutput)output);
        packer.packRawMap(MapUtil.map((Object[])new Object[]{"unpackable", new Unpackable()}));
        Object unpacked = this.unpacked(output.bytes());
        MatcherAssert.assertThat((Object)unpacked, (Matcher)CoreMatchers.instanceOf(Map.class));
        Map unpackedMap = (Map)unpacked;
        MatcherAssert.assertThat((Object)unpackedMap, (Matcher)CoreMatchers.equalTo((Object)MapUtil.map((Object[])new Object[]{"unpackable", null})));
        Assert.assertTrue((boolean)packer.hasErrors());
    }

    @Test
    public void shouldErrorOnUnpackingMapWithDuplicateKeys() throws IOException {
        PackedOutputArray output = new PackedOutputArray();
        Neo4jPack.Packer packer = new Neo4jPack.Packer((PackOutput)output);
        packer.packMapHeader(2);
        packer.pack("key");
        packer.pack(1L);
        packer.pack("key");
        packer.pack(2L);
        PackedInputArray input = new PackedInputArray(output.bytes());
        Neo4jPack.Unpacker unpacker = new Neo4jPack.Unpacker((PackInput)input);
        unpacker.unpack();
        MatcherAssert.assertThat(unpacker.consumeError().get(), (Matcher)CoreMatchers.equalTo((Object)Neo4jError.from((Status)Status.Request.Invalid, (String)"Duplicate map key `key`.")));
    }

    @Test
    public void shouldHandleDeletedNodesGracefully() throws IOException {
        Node node = (Node)Mockito.mock(Node.class);
        Mockito.when((Object)node.getId()).thenReturn((Object)42L);
        ((Node)Mockito.doThrow(NotFoundException.class).when((Object)node)).getAllProperties();
        ((Node)Mockito.doThrow(NotFoundException.class).when((Object)node)).getLabels();
        byte[] packed = this.packed(node);
        MatcherAssert.assertThat((Object)HexPrinter.hex((byte[])packed), (Matcher)CoreMatchers.equalTo((Object)"B3 4E 2A 90 A0"));
    }

    @Test
    public void shouldNotBeAbleToUnpackNode() throws IOException {
        this.exception.expect(BoltIOException.class);
        this.unpacked(this.packed(Nodes.ALICE));
    }

    @Test
    public void shouldNotBeAbleToUnpackRelationship() throws IOException {
        this.exception.expect(BoltIOException.class);
        this.unpacked(this.packed(Relationships.ALICE_KNOWS_BOB));
    }

    @Test
    public void shouldNotBeAbleToUnpackPaths() throws IOException {
        for (Path path : Paths.ALL_PATHS) {
            this.exception.expect(BoltIOException.class);
            this.unpacked(this.packed(path));
        }
    }

    @Test
    public void shouldTreatSingleCharAsSingleCharacterString() throws IOException {
        PackedOutputArray output = new PackedOutputArray();
        Neo4jPack.Packer packer = new Neo4jPack.Packer((PackOutput)output);
        packer.pack('C');
        Object unpacked = this.unpacked(output.bytes());
        MatcherAssert.assertThat((Object)unpacked, (Matcher)CoreMatchers.instanceOf(String.class));
        MatcherAssert.assertThat((Object)unpacked, (Matcher)CoreMatchers.equalTo((Object)"C"));
    }

    @Test
    public void shouldTreatCharArrayAsListOfStrings() throws IOException {
        PackedOutputArray output = new PackedOutputArray();
        Neo4jPack.Packer packer = new Neo4jPack.Packer((PackOutput)output);
        packer.pack((Object)new char[]{'W', 'H', 'Y'});
        Object unpacked = this.unpacked(output.bytes());
        MatcherAssert.assertThat((Object)unpacked, (Matcher)CoreMatchers.instanceOf(List.class));
        MatcherAssert.assertThat((Object)unpacked, (Matcher)CoreMatchers.equalTo(Arrays.asList("W", "H", "Y")));
    }

    private static class Unpackable {
        private Unpackable() {
        }
    }
}

