/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.v1.messaging;

import java.io.IOException;
import org.hamcrest.Matcher;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.neo4j.bolt.v1.messaging.BoltResponseMessageHandler;
import org.neo4j.bolt.v1.messaging.MessageProcessingHandler;
import org.neo4j.bolt.v1.packstream.PackOutputClosedException;
import org.neo4j.bolt.v1.runtime.BoltWorker;
import org.neo4j.bolt.v1.runtime.Neo4jError;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.logging.AssertableLogProvider;
import org.neo4j.logging.Log;
import org.neo4j.test.matchers.CommonMatchers;

public class MessageProcessingHandlerTest {
    @Test
    public void shouldCallHaltOnUnexpectedFailures() throws Exception {
        BoltResponseMessageHandler<IOException> msgHandler = MessageProcessingHandlerTest.newResponseHandlerMock();
        ((BoltResponseMessageHandler)Mockito.doThrow((Throwable)new RuntimeException("Something went horribly wrong")).when(msgHandler)).onSuccess(Matchers.anyMapOf(String.class, Object.class));
        BoltWorker worker = (BoltWorker)Mockito.mock(BoltWorker.class);
        MessageProcessingHandler handler = new MessageProcessingHandler(msgHandler, (Runnable)Mockito.mock(Runnable.class), worker, (Log)Mockito.mock(Log.class));
        handler.onFinish();
        ((BoltWorker)Mockito.verify((Object)worker)).halt();
    }

    @Test
    public void shouldLogOriginalErrorWhenOutputIsClosed() throws Exception {
        MessageProcessingHandlerTest.testLoggingOfOriginalErrorWhenOutputIsClosed(false);
    }

    @Test
    public void shouldLogOriginalFatalErrorWhenOutputIsClosed() throws Exception {
        MessageProcessingHandlerTest.testLoggingOfOriginalErrorWhenOutputIsClosed(true);
    }

    @Test
    public void shouldLogWriteErrorAndOriginalErrorWhenUnknownFailure() throws Exception {
        MessageProcessingHandlerTest.testLoggingOfWriteErrorAndOriginalErrorWhenUnknownFailure(false);
    }

    @Test
    public void shouldLogWriteErrorAndOriginalFatalErrorWhenUnknownFailure() throws Exception {
        MessageProcessingHandlerTest.testLoggingOfWriteErrorAndOriginalErrorWhenUnknownFailure(true);
    }

    private static void testLoggingOfOriginalErrorWhenOutputIsClosed(boolean fatalError) throws Exception {
        AssertableLogProvider logProvider = new AssertableLogProvider();
        Log log = logProvider.getLog("Test");
        PackOutputClosedException outputClosed = new PackOutputClosedException("Output closed");
        BoltResponseMessageHandler<IOException> responseHandler = MessageProcessingHandlerTest.newResponseHandlerMock(fatalError, (Throwable)outputClosed);
        MessageProcessingHandler handler = new MessageProcessingHandler(responseHandler, (Runnable)Mockito.mock(Runnable.class), (BoltWorker)Mockito.mock(BoltWorker.class), log);
        RuntimeException originalError = new RuntimeException("Hi, I'm the original error");
        MessageProcessingHandlerTest.markFailed(handler, fatalError, originalError);
        logProvider.assertExactly(new AssertableLogProvider.LogMatcher[]{AssertableLogProvider.inLog((String)"Test").warn(org.hamcrest.Matchers.startsWith((String)"Unable to send error back to the client"), org.hamcrest.Matchers.equalTo((Object)originalError))});
    }

    private static void testLoggingOfWriteErrorAndOriginalErrorWhenUnknownFailure(boolean fatalError) throws Exception {
        AssertableLogProvider logProvider = new AssertableLogProvider();
        Log log = logProvider.getLog("Test");
        RuntimeException outputError = new RuntimeException("Output failed");
        BoltResponseMessageHandler<IOException> responseHandler = MessageProcessingHandlerTest.newResponseHandlerMock(fatalError, outputError);
        MessageProcessingHandler handler = new MessageProcessingHandler(responseHandler, (Runnable)Mockito.mock(Runnable.class), (BoltWorker)Mockito.mock(BoltWorker.class), log);
        RuntimeException originalError = new RuntimeException("Hi, I'm the original error");
        MessageProcessingHandlerTest.markFailed(handler, fatalError, originalError);
        logProvider.assertExactly(new AssertableLogProvider.LogMatcher[]{AssertableLogProvider.inLog((String)"Test").error(org.hamcrest.Matchers.startsWith((String)"Unable to send error back to the client"), (Matcher)org.hamcrest.Matchers.both((Matcher)org.hamcrest.Matchers.equalTo((Object)outputError)).and(CommonMatchers.hasSuppressed((Throwable[])new Throwable[]{originalError})))});
    }

    private static void markFailed(MessageProcessingHandler handler, boolean fatalError, Throwable error) {
        Neo4jError neo4jError = fatalError ? Neo4jError.fatalFrom((Throwable)error) : Neo4jError.from((Throwable)error);
        handler.markFailed(neo4jError);
        handler.onFinish();
    }

    private static BoltResponseMessageHandler<IOException> newResponseHandlerMock(boolean fatalError, Throwable error) throws Exception {
        BoltResponseMessageHandler<IOException> handler = MessageProcessingHandlerTest.newResponseHandlerMock();
        if (fatalError) {
            ((BoltResponseMessageHandler)Mockito.doThrow((Throwable)error).when(handler)).onFatal((Status)Matchers.any(Status.class), Matchers.anyString());
        } else {
            ((BoltResponseMessageHandler)Mockito.doThrow((Throwable)error).when(handler)).onFailure((Status)Matchers.any(Status.class), Matchers.anyString());
        }
        return handler;
    }

    private static BoltResponseMessageHandler<IOException> newResponseHandlerMock() {
        return (BoltResponseMessageHandler)Mockito.mock(BoltResponseMessageHandler.class);
    }
}

