/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.v1.messaging;

import java.io.IOException;
import java.util.Map;
import org.neo4j.bolt.v1.messaging.BoltIOException;
import org.neo4j.bolt.v1.messaging.BoltResponseMessage;
import org.neo4j.bolt.v1.messaging.BoltResponseMessageHandler;
import org.neo4j.bolt.v1.messaging.Neo4jPack;
import org.neo4j.bolt.v1.packstream.PackStream;
import org.neo4j.bolt.v1.runtime.Neo4jError;
import org.neo4j.bolt.v1.runtime.spi.Records;
import org.neo4j.kernel.api.exceptions.Status;

public class BoltResponseMessageReader {
    private final Neo4jPack.Unpacker unpacker;

    public BoltResponseMessageReader(Neo4jPack.Unpacker unpacker) {
        this.unpacker = unpacker;
    }

    public boolean hasNext() throws IOException {
        return this.unpacker.hasNext();
    }

    public <E extends Exception> void read(BoltResponseMessageHandler<E> handler) throws IOException, E {
        try {
            this.unpacker.unpackStructHeader();
            char signature = this.unpacker.unpackStructSignature();
            BoltResponseMessage message = BoltResponseMessage.withSignature((int)signature);
            try {
                switch (message) {
                    case SUCCESS: {
                        Map successMetadata = this.unpacker.unpackMap();
                        handler.onSuccess(successMetadata);
                        break;
                    }
                    case RECORD: {
                        long length = this.unpacker.unpackListHeader();
                        Object[] fields = new Object[(int)length];
                        int i = 0;
                        while ((long)i < length) {
                            fields[i] = this.unpacker.unpack();
                            ++i;
                        }
                        handler.onRecord(Records.record((Object[])fields));
                        break;
                    }
                    case IGNORED: {
                        handler.onIgnored();
                        break;
                    }
                    case FAILURE: {
                        Map failureMetadata = this.unpacker.unpackMap();
                        String code = failureMetadata.containsKey("code") ? (String)failureMetadata.get("code") : Status.General.UnknownError.name();
                        String msg = failureMetadata.containsKey("message") ? (String)failureMetadata.get("message") : "<No message supplied>";
                        handler.onFailure(Neo4jError.codeFromString((String)code), msg);
                        break;
                    }
                    default: {
                        throw new BoltIOException((Status)Status.Request.Invalid, "Message 0x" + Integer.toHexString(signature) + " is not supported.");
                    }
                }
            }
            catch (IllegalArgumentException e) {
                throw new BoltIOException((Status)Status.Request.Invalid, "0x" + Integer.toHexString(signature) + " is not a valid message signature.");
            }
        }
        catch (PackStream.PackStreamException e) {
            throw new BoltIOException((Status)Status.Request.InvalidFormat, "Unable to read message type. Error was: " + e.getMessage(), (Throwable)e);
        }
    }
}

