/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.v1.messaging;

import java.io.IOException;
import java.util.Map;
import org.neo4j.bolt.v1.messaging.BoltRequestMessage;
import org.neo4j.bolt.v1.messaging.BoltRequestMessageHandler;
import org.neo4j.bolt.v1.messaging.BoltResponseMessageBoundaryHook;
import org.neo4j.bolt.v1.messaging.Neo4jPack;
import org.neo4j.bolt.v1.messaging.message.RequestMessage;
import org.neo4j.bolt.v1.runtime.Neo4jError;

public class BoltRequestMessageWriter
implements BoltRequestMessageHandler<IOException> {
    private final Neo4jPack.Packer packer;
    private final BoltResponseMessageBoundaryHook onMessageComplete;

    public BoltRequestMessageWriter(Neo4jPack.Packer packer, BoltResponseMessageBoundaryHook onMessageComplete) {
        this.packer = packer;
        this.onMessageComplete = onMessageComplete;
    }

    public BoltRequestMessageWriter write(RequestMessage message) throws IOException {
        message.dispatch(this);
        return this;
    }

    public void onInit(String clientName, Map<String, Object> credentials) throws IOException {
        this.packer.packStructHeader(1, BoltRequestMessage.INIT.signature());
        this.packer.pack(clientName);
        this.packer.packRawMap(credentials);
        this.onMessageComplete.onMessageComplete();
    }

    public void onAckFailure() throws IOException {
        this.packer.packStructHeader(0, BoltRequestMessage.ACK_FAILURE.signature());
        this.onMessageComplete.onMessageComplete();
    }

    public void onReset() throws IOException {
        this.packer.packStructHeader(0, BoltRequestMessage.RESET.signature());
        this.onMessageComplete.onMessageComplete();
    }

    public void onRun(String statement, Map<String, Object> params) throws IOException {
        this.packer.packStructHeader(2, BoltRequestMessage.RUN.signature());
        this.packer.pack(statement);
        this.packer.packRawMap(params);
        this.onMessageComplete.onMessageComplete();
    }

    public void onDiscardAll() throws IOException {
        this.packer.packStructHeader(0, BoltRequestMessage.DISCARD_ALL.signature());
        this.onMessageComplete.onMessageComplete();
    }

    public void onPullAll() throws IOException {
        this.packer.packStructHeader(0, BoltRequestMessage.PULL_ALL.signature());
        this.onMessageComplete.onMessageComplete();
    }

    public void flush() throws IOException {
        this.packer.flush();
    }

    public void onExternalError(Neo4jError error) throws IOException {
    }
}

