/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.v1.messaging;

import java.io.IOException;
import java.util.Arrays;
import java.util.Map;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.neo4j.bolt.v1.messaging.BoltRequestMessageHandler;
import org.neo4j.bolt.v1.messaging.BoltRequestMessageReader;
import org.neo4j.bolt.v1.messaging.BoltRequestMessageRecorder;
import org.neo4j.bolt.v1.messaging.BoltRequestMessageWriter;
import org.neo4j.bolt.v1.messaging.BoltResponseMessageWriter;
import org.neo4j.bolt.v1.messaging.Neo4jPack;
import org.neo4j.bolt.v1.messaging.RecordingByteChannel;
import org.neo4j.bolt.v1.messaging.infrastructure.ValueNode;
import org.neo4j.bolt.v1.messaging.infrastructure.ValueRelationship;
import org.neo4j.bolt.v1.messaging.message.AckFailureMessage;
import org.neo4j.bolt.v1.messaging.message.DiscardAllMessage;
import org.neo4j.bolt.v1.messaging.message.InitMessage;
import org.neo4j.bolt.v1.messaging.message.PullAllMessage;
import org.neo4j.bolt.v1.messaging.message.RecordMessage;
import org.neo4j.bolt.v1.messaging.message.RequestMessage;
import org.neo4j.bolt.v1.messaging.message.ResetMessage;
import org.neo4j.bolt.v1.messaging.message.RunMessage;
import org.neo4j.bolt.v1.messaging.util.MessageMatchers;
import org.neo4j.bolt.v1.packstream.BufferedChannelInput;
import org.neo4j.bolt.v1.packstream.BufferedChannelOutput;
import org.neo4j.bolt.v1.packstream.PackInput;
import org.neo4j.bolt.v1.packstream.PackOutput;
import org.neo4j.bolt.v1.runtime.spi.Records;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.kernel.impl.util.HexPrinter;

public class BoltRequestMessageTest {
    @Rule
    public ExpectedException exception = ExpectedException.none();

    @Test
    public void shouldHandleCommonMessages() throws Throwable {
        this.assertSerializes(InitMessage.init("MyClient/1.0", MapUtil.map((Object[])new Object[]{"scheme", "basic"})));
        this.assertSerializes(AckFailureMessage.ackFailure());
        this.assertSerializes(ResetMessage.reset());
        this.assertSerializes(RunMessage.run("CREATE (n) RETURN \u00e5\u00e4\u00f6"));
        this.assertSerializes(DiscardAllMessage.discardAll());
        this.assertSerializes(PullAllMessage.pullAll());
    }

    @Test
    public void shouldHandleParameterizedStatements() throws Throwable {
        Map expected = MapUtil.map((Object[])new Object[]{"n", 12L});
        RunMessage msg = this.serializeAndDeserialize(RunMessage.run("asd", expected));
        MatcherAssert.assertThat(msg.params().entrySet(), (Matcher)Matchers.equalTo(expected.entrySet()));
    }

    @Test
    public void shouldSerializeNode() throws Throwable {
        ValueNode valueNode = new ValueNode(12L, Arrays.asList(Label.label((String)"User"), Label.label((String)"Banana")), MapUtil.map((Object[])new Object[]{"name", "Bob", "age", 14}));
        MatcherAssert.assertThat((Object)this.serialized(valueNode), (Matcher)Matchers.equalTo((Object)("B1 71 91 B3 4E 0C 92 84 55 73 65 72 86 42 61 6E" + System.lineSeparator() + "61 6E 61 A2 84 6E 61 6D 65 83 42 6F 62 83 61 67" + System.lineSeparator() + "65 0E")));
    }

    @Test
    public void shouldSerializeRelationship() throws Throwable {
        ValueRelationship valueRelationship = new ValueRelationship(12L, 1L, 2L, RelationshipType.withName((String)"KNOWS"), MapUtil.map((Object[])new Object[]{"name", "Bob", "age", 14}));
        MatcherAssert.assertThat((Object)this.serialized(valueRelationship), (Matcher)Matchers.equalTo((Object)("B1 71 91 B5 52 0C 01 02 85 4B 4E 4F 57 53 A2 84" + System.lineSeparator() + "6E 61 6D 65 83 42 6F 62 83 61 67 65 0E")));
    }

    private String serialized(Object object) throws IOException {
        RecordMessage message = new RecordMessage(Records.record((Object[])new Object[]{object}));
        return HexPrinter.hex((byte[])MessageMatchers.serialize(message), (int)4, (String)" ");
    }

    private void assertSerializes(RequestMessage msg) throws IOException {
        MatcherAssert.assertThat((Object)this.serializeAndDeserialize(msg), (Matcher)Matchers.equalTo((Object)msg));
    }

    private <T extends RequestMessage> T serializeAndDeserialize(T msg) throws IOException {
        RecordingByteChannel channel = new RecordingByteChannel();
        BoltRequestMessageReader reader = new BoltRequestMessageReader(new Neo4jPack.Unpacker((PackInput)new BufferedChannelInput(16).reset(channel)));
        BoltRequestMessageWriter writer = new BoltRequestMessageWriter(new Neo4jPack.Packer((PackOutput)new BufferedChannelOutput(channel)), BoltResponseMessageWriter.NO_BOUNDARY_HOOK);
        writer.write(msg).flush();
        channel.eof();
        return this.unpack(reader, channel);
    }

    private <T extends RequestMessage> T unpack(BoltRequestMessageReader reader, RecordingByteChannel channel) {
        String serialized = HexPrinter.hex((byte[])channel.getBytes());
        BoltRequestMessageRecorder messages = new BoltRequestMessageRecorder();
        try {
            reader.read((BoltRequestMessageHandler)messages);
        }
        catch (Throwable e) {
            throw new AssertionError("Failed to unpack message, wire data was:\n" + serialized + "[" + channel.getBytes().length + "b]", e);
        }
        return (T)((RequestMessage)messages.asList().get(0));
    }
}

