/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.testing;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.neo4j.bolt.v1.messaging.BoltResponseMessage;
import org.neo4j.bolt.v1.runtime.spi.Record;

public class RecordedBoltResponse {
    private List<Record> records = new ArrayList<Record>();
    private BoltResponseMessage response = null;
    private Map<String, Object> metadata = new HashMap<String, Object>();

    public void addRecord(Record record) {
        this.records.add(record);
    }

    public void addMetadata(String key, Object value) {
        this.metadata.put(key, value);
    }

    public BoltResponseMessage message() {
        return this.response;
    }

    public void setResponse(BoltResponseMessage message) {
        this.response = message;
    }

    public boolean hasMetadata(String key) {
        return this.metadata.containsKey(key);
    }

    public Object metadata(String key) {
        return this.metadata.get(key);
    }

    public void assertRecord(int index, Object ... values) {
        MatcherAssert.assertThat((Object)index, (Matcher)Matchers.lessThan((Comparable)Integer.valueOf(this.records.size())));
        Assert.assertArrayEquals((Object[])this.records.get(index).fields(), (Object[])values);
    }

    public Record[] records() {
        Record[] recordArray = new Record[this.records.size()];
        return this.records.toArray(recordArray);
    }
}

