/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.testing;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.junit.Assert;
import org.neo4j.bolt.testing.RecordedBoltResponse;
import org.neo4j.bolt.v1.messaging.BoltResponseMessage;
import org.neo4j.bolt.v1.runtime.BoltResponseHandler;
import org.neo4j.bolt.v1.runtime.Neo4jError;
import org.neo4j.bolt.v1.runtime.spi.BoltResult;
import org.neo4j.bolt.v1.runtime.spi.Record;

public class BoltResponseRecorder
implements BoltResponseHandler {
    private BlockingQueue<RecordedBoltResponse> responses;
    private RecordedBoltResponse currentResponse;

    public BoltResponseRecorder() {
        this.reset();
    }

    public void reset() {
        this.responses = new LinkedBlockingQueue<RecordedBoltResponse>();
        this.currentResponse = new RecordedBoltResponse();
    }

    public void onStart() {
    }

    public void onRecords(BoltResult result, boolean pull) throws Exception {
        result.accept(new BoltResult.Visitor(){

            public void visit(Record record) throws Exception {
                BoltResponseRecorder.this.currentResponse.addRecord(record);
            }

            public void addMetadata(String key, Object value) {
                BoltResponseRecorder.this.currentResponse.addMetadata(key, value);
            }
        });
    }

    public void onMetadata(String key, Object value) {
        this.currentResponse.addMetadata(key, value);
    }

    public void markIgnored() {
        this.currentResponse.setResponse(BoltResponseMessage.IGNORED);
    }

    public void markFailed(Neo4jError error) {
        this.currentResponse.setResponse(BoltResponseMessage.FAILURE);
        this.onMetadata("code", error.status().code().serialize());
        this.onMetadata("message", error.message());
    }

    public void onFinish() {
        if (this.currentResponse.message() == null) {
            this.currentResponse.setResponse(BoltResponseMessage.SUCCESS);
        }
        this.responses.add(this.currentResponse);
        this.currentResponse = new RecordedBoltResponse();
    }

    public int responseCount() {
        return this.responses.size();
    }

    public RecordedBoltResponse nextResponse() throws InterruptedException {
        RecordedBoltResponse response = this.responses.poll(3L, TimeUnit.SECONDS);
        Assert.assertNotNull((String)"No message arrived after 3s", (Object)response);
        return response;
    }
}

