/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.security.auth;

import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ThreadLocalRandom;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.TypeSafeMatcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.mockito.Mockito;
import org.neo4j.bolt.security.auth.Authentication;
import org.neo4j.bolt.security.auth.AuthenticationException;
import org.neo4j.bolt.security.auth.AuthenticationResult;
import org.neo4j.bolt.security.auth.BasicAuthentication;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.kernel.api.security.AccessMode;
import org.neo4j.kernel.api.security.AuthManager;
import org.neo4j.kernel.api.security.PasswordPolicy;
import org.neo4j.kernel.api.security.UserManagerSupplier;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.server.security.auth.BasicAuthManager;
import org.neo4j.server.security.auth.InMemoryUserRepository;
import org.neo4j.server.security.auth.UserRepository;
import org.neo4j.time.Clocks;

public class BasicAuthenticationTest {
    @Rule
    public ExpectedException exception = ExpectedException.none();
    private Authentication authentication;

    @Test
    public void shouldNotDoAnythingOnSuccess() throws Exception {
        AuthenticationResult result = this.authentication.authenticate(MapUtil.map((Object[])new Object[]{"scheme", "basic", "principal", "mike", "credentials", "secret2"}));
        MatcherAssert.assertThat((Object)result.getSecurityContext().mode(), (Matcher)CoreMatchers.equalTo((Object)AccessMode.Static.FULL));
        MatcherAssert.assertThat((Object)result.getSecurityContext().subject().username(), (Matcher)CoreMatchers.equalTo((Object)"mike"));
    }

    @Test
    public void shouldThrowAndLogOnFailure() throws Exception {
        this.exception.expect(AuthenticationException.class);
        this.exception.expect((Matcher)this.hasStatus((Status)Status.Security.Unauthorized));
        this.exception.expectMessage("The client is unauthorized due to authentication failure.");
        this.authentication.authenticate(MapUtil.map((Object[])new Object[]{"scheme", "basic", "principal", "bob", "credentials", "banana"}));
    }

    @Test
    public void shouldIndicateThatCredentialsExpired() throws Exception {
        AuthenticationResult result = this.authentication.authenticate(MapUtil.map((Object[])new Object[]{"scheme", "basic", "principal", "bob", "credentials", "secret"}));
        Assert.assertTrue((boolean)result.credentialsExpired());
    }

    @Test
    public void shouldFailWhenTooManyAttempts() throws Exception {
        int maxFailedAttempts = ThreadLocalRandom.current().nextInt(1, 10);
        Authentication auth = BasicAuthenticationTest.createAuthentication(maxFailedAttempts);
        for (int i = 0; i < maxFailedAttempts; ++i) {
            try {
                auth.authenticate(MapUtil.map((Object[])new Object[]{"scheme", "basic", "principal", "bob", "credentials", "gelato"}));
                continue;
            }
            catch (AuthenticationException e) {
                MatcherAssert.assertThat((Object)e.status(), (Matcher)CoreMatchers.equalTo((Object)Status.Security.Unauthorized));
            }
        }
        this.exception.expect(AuthenticationException.class);
        this.exception.expect((Matcher)this.hasStatus((Status)Status.Security.AuthenticationRateLimit));
        this.exception.expectMessage("The client has provided incorrect authentication details too many times in a row.");
        auth.authenticate(MapUtil.map((Object[])new Object[]{"scheme", "basic", "principal", "bob", "credentials", "gelato"}));
    }

    @Test
    public void shouldBeAbleToUpdateCredentials() throws Exception {
        this.authentication.authenticate(MapUtil.map((Object[])new Object[]{"scheme", "basic", "principal", "mike", "credentials", "secret2", "new_credentials", "secret"}));
        this.authentication.authenticate(MapUtil.map((Object[])new Object[]{"scheme", "basic", "principal", "mike", "credentials", "secret"}));
    }

    @Test
    public void shouldBeAbleToUpdateExpiredCredentials() throws Exception {
        AuthenticationResult result = this.authentication.authenticate(MapUtil.map((Object[])new Object[]{"scheme", "basic", "principal", "bob", "credentials", "secret", "new_credentials", "secret2"}));
        MatcherAssert.assertThat((Object)result.credentialsExpired(), (Matcher)CoreMatchers.equalTo((Object)false));
    }

    @Test
    public void shouldNotBeAbleToUpdateCredentialsIfOldCredentialsAreInvalid() throws Exception {
        this.exception.expect(AuthenticationException.class);
        this.exception.expect((Matcher)this.hasStatus((Status)Status.Security.Unauthorized));
        this.exception.expectMessage("The client is unauthorized due to authentication failure.");
        this.authentication.authenticate(MapUtil.map((Object[])new Object[]{"scheme", "basic", "principal", "bob", "credentials", "gelato", "new_credentials", "secret2"}));
    }

    @Test
    public void shouldThrowWithNoScheme() throws Exception {
        this.exception.expect(AuthenticationException.class);
        this.exception.expect((Matcher)this.hasStatus((Status)Status.Security.Unauthorized));
        this.authentication.authenticate(MapUtil.map((Object[])new Object[]{"principal", "bob", "credentials", "secret"}));
    }

    @Test
    public void shouldFailOnInvalidAuthToken() throws Exception {
        this.exception.expect(AuthenticationException.class);
        this.exception.expect((Matcher)this.hasStatus((Status)Status.Security.Unauthorized));
        this.authentication.authenticate(MapUtil.map((Object[])new Object[]{"this", "does", "not", "matter", "for", "test"}));
    }

    @Test
    public void shouldFailOnMalformedToken() throws Exception {
        this.exception.expect(AuthenticationException.class);
        this.exception.expect((Matcher)this.hasStatus((Status)Status.Security.Unauthorized));
        this.exception.expectMessage("Unsupported authentication token, the value associated with the key `principal` must be a String but was: SingletonList");
        this.authentication.authenticate(MapUtil.map((Object[])new Object[]{"scheme", "basic", "principal", Collections.singletonList("bob"), "credentials", "secret"}));
    }

    @Before
    public void setup() throws Throwable {
        this.authentication = BasicAuthenticationTest.createAuthentication(3);
    }

    private static Authentication createAuthentication(int maxFailedAttempts) throws Exception {
        InMemoryUserRepository users = new InMemoryUserRepository();
        PasswordPolicy policy = (PasswordPolicy)Mockito.mock(PasswordPolicy.class);
        Map<String, String> maxAttamptsConfig = Collections.singletonMap(GraphDatabaseSettings.auth_max_failed_attempts.name(), String.valueOf(maxFailedAttempts));
        Config config = Config.defaults().augment(maxAttamptsConfig);
        BasicAuthManager manager = new BasicAuthManager((UserRepository)users, policy, Clocks.systemClock(), (UserRepository)users, config);
        BasicAuthentication authentication = new BasicAuthentication((AuthManager)manager, (UserManagerSupplier)manager);
        manager.newUser("bob", "secret", true);
        manager.newUser("mike", "secret2", false);
        return authentication;
    }

    private HasStatus hasStatus(Status status) {
        return new HasStatus(status);
    }

    static class HasStatus
    extends TypeSafeMatcher<Status.HasStatus> {
        private Status status;

        HasStatus(Status status) {
            this.status = status;
        }

        protected boolean matchesSafely(Status.HasStatus item) {
            return item.status() == this.status;
        }

        public void describeTo(Description description) {
            description.appendText("expects status ").appendValue((Object)this.status);
        }

        protected void describeMismatchSafely(Status.HasStatus item, Description mismatchDescription) {
            mismatchDescription.appendText("was ").appendValue((Object)item.status());
        }
    }
}

