/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.backup.impl;

import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.neo4j.backup.impl.OnlineBackupContext;
import org.neo4j.backup.impl.OnlineBackupRequiredArguments;
import org.neo4j.backup.impl.SelectedBackupProtocol;
import org.neo4j.commandline.admin.CommandFailed;
import org.neo4j.commandline.admin.IncorrectUsage;
import org.neo4j.commandline.arguments.Arguments;
import org.neo4j.commandline.arguments.MandatoryNamedArg;
import org.neo4j.commandline.arguments.NamedArgument;
import org.neo4j.commandline.arguments.OptionalBooleanArg;
import org.neo4j.commandline.arguments.OptionalNamedArg;
import org.neo4j.commandline.arguments.common.MandatoryCanonicalPath;
import org.neo4j.commandline.arguments.common.OptionalCanonicalPath;
import org.neo4j.consistency.ConsistencyCheckSettings;
import org.neo4j.consistency.checking.full.ConsistencyFlags;
import org.neo4j.graphdb.config.Setting;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.helpers.TimeUtil;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.util.Converters;
import org.neo4j.kernel.impl.util.OptionalHostnamePort;

class OnlineBackupContextFactory {
    static final String ARG_NAME_BACKUP_DIRECTORY = "backup-dir";
    static final String ARG_DESC_BACKUP_DIRECTORY = "Directory to place backup in.";
    static final String ARG_NAME_BACKUP_NAME = "name";
    static final String ARG_DESC_BACKUP_NAME = "Name of backup. If a backup with this name already exists an incremental backup will be attempted.";
    static final String ARG_NAME_BACKUP_SOURCE = "from";
    static final String ARG_DESC_BACKUP_SOURCE = "Host and port of Neo4j.";
    static final String ARG_DFLT_BACKUP_SOURCE = "localhost:6362";
    static final String ARG_NAME_PROTO_OVERRIDE = "protocol";
    static final String ARG_DESC_PROTO_OVERRIDE = "Preferred backup protocol";
    static final String ARG_DFLT_PROTO_OVERRIDE = "any";
    static final String ARG_NAME_TIMEOUT = "timeout";
    static final String ARG_DESC_TIMEOUT = "Timeout in the form <time>[ms|s|m|h], where the default unit is seconds.";
    static final String ARG_DFLT_TIMEOUT = "20m";
    static final String ARG_NAME_PAGECACHE = "pagecache";
    static final String ARG_DESC_PAGECACHE = "The size of the page cache to use for the backup process.";
    static final String ARG_DFLT_PAGECACHE = "8m";
    static final String ARG_NAME_REPORT_DIRECTORY = "cc-report-dir";
    static final String ARG_DESC_REPORT_DIRECTORY = "Directory where consistency report will be written.";
    static final String ARG_NAME_ADDITIONAL_CONFIG_DIR = "additional-config";
    static final String ARG_DESC_ADDITIONAL_CONFIG_DIR = "Configuration file to supply additional configuration in. This argument is DEPRECATED.";
    static final String ARG_NAME_FALLBACK_FULL = "fallback-to-full";
    static final String ARG_DESC_FALLBACK_FULL = "If an incremental backup fails backup will move the old backup to <name>.err.<N> and fallback to a full backup instead.";
    static final String ARG_NAME_CHECK_CONSISTENCY = "check-consistency";
    static final String ARG_DESC_CHECK_CONSISTENCY = "If a consistency check should be made.";
    static final String ARG_NAME_CHECK_GRAPH = "cc-graph";
    static final String ARG_DESC_CHECK_GRAPH = "Perform consistency checks between nodes, relationships, properties, types and tokens.";
    static final String ARG_NAME_CHECK_INDEXES = "cc-indexes";
    static final String ARG_DESC_CHECK_INDEXES = "Perform consistency checks on indexes.";
    static final String ARG_NAME_CHECK_LABELS = "cc-label-scan-store";
    static final String ARG_DESC_CHECK_LABELS = "Perform consistency checks on the label scan store.";
    static final String ARG_NAME_CHECK_OWNERS = "cc-property-owners";
    static final String ARG_DESC_CHECK_OWNERS = "Perform additional consistency checks on property ownership. This check is *very* expensive in time and memory.";
    private final Path homeDir;
    private final Path configDir;

    OnlineBackupContextFactory(Path homeDir, Path configDir) {
        this.homeDir = homeDir;
        this.configDir = configDir;
    }

    public static Arguments arguments() {
        String argExampleProtoOverride = Stream.of(SelectedBackupProtocol.values()).map(SelectedBackupProtocol::getName).sorted().collect(Collectors.joining("|"));
        return new Arguments().withArgument((NamedArgument)new MandatoryCanonicalPath(ARG_NAME_BACKUP_DIRECTORY, "backup-path", ARG_DESC_BACKUP_DIRECTORY)).withArgument((NamedArgument)new MandatoryNamedArg(ARG_NAME_BACKUP_NAME, "graph.db-backup", ARG_DESC_BACKUP_NAME)).withArgument((NamedArgument)new OptionalNamedArg(ARG_NAME_BACKUP_SOURCE, "address", ARG_DFLT_BACKUP_SOURCE, ARG_DESC_BACKUP_SOURCE)).withArgument((NamedArgument)new OptionalNamedArg(ARG_NAME_PROTO_OVERRIDE, argExampleProtoOverride, ARG_DFLT_PROTO_OVERRIDE, ARG_DESC_PROTO_OVERRIDE)).withArgument((NamedArgument)new OptionalBooleanArg(ARG_NAME_FALLBACK_FULL, true, ARG_DESC_FALLBACK_FULL)).withArgument((NamedArgument)new OptionalNamedArg(ARG_NAME_TIMEOUT, ARG_NAME_TIMEOUT, ARG_DFLT_TIMEOUT, ARG_DESC_TIMEOUT)).withArgument((NamedArgument)new OptionalNamedArg(ARG_NAME_PAGECACHE, ARG_DFLT_PAGECACHE, ARG_DFLT_PAGECACHE, ARG_DESC_PAGECACHE)).withArgument((NamedArgument)new OptionalBooleanArg(ARG_NAME_CHECK_CONSISTENCY, true, ARG_DESC_CHECK_CONSISTENCY)).withArgument((NamedArgument)new OptionalCanonicalPath(ARG_NAME_REPORT_DIRECTORY, "directory", ".", ARG_DESC_REPORT_DIRECTORY)).withArgument((NamedArgument)new OptionalCanonicalPath(ARG_NAME_ADDITIONAL_CONFIG_DIR, "config-file-path", "", ARG_DESC_ADDITIONAL_CONFIG_DIR)).withArgument((NamedArgument)new OptionalBooleanArg(ARG_NAME_CHECK_GRAPH, true, ARG_DESC_CHECK_GRAPH)).withArgument((NamedArgument)new OptionalBooleanArg(ARG_NAME_CHECK_INDEXES, true, ARG_DESC_CHECK_INDEXES)).withArgument((NamedArgument)new OptionalBooleanArg(ARG_NAME_CHECK_LABELS, true, ARG_DESC_CHECK_LABELS)).withArgument((NamedArgument)new OptionalBooleanArg(ARG_NAME_CHECK_OWNERS, false, ARG_DESC_CHECK_OWNERS));
    }

    public OnlineBackupContext createContext(String ... args) throws IncorrectUsage, CommandFailed {
        try {
            Arguments arguments = OnlineBackupContextFactory.arguments();
            arguments.parse(args);
            OptionalHostnamePort address = Converters.toOptionalHostnamePortFromRawAddress((String)arguments.get(ARG_NAME_BACKUP_SOURCE));
            Path folder = this.getBackupDirectory(arguments);
            String name = arguments.get(ARG_NAME_BACKUP_NAME);
            boolean fallbackToFull = arguments.getBoolean(ARG_NAME_FALLBACK_FULL);
            boolean doConsistencyCheck = arguments.getBoolean(ARG_NAME_CHECK_CONSISTENCY);
            long timeout = (Long)arguments.get(ARG_NAME_TIMEOUT, TimeUtil.parseTimeMillis);
            SelectedBackupProtocol selectedBackupProtocol = SelectedBackupProtocol.fromUserInput(arguments.get(ARG_NAME_PROTO_OVERRIDE));
            String pagecacheMemory = arguments.get(ARG_NAME_PAGECACHE);
            Optional additionalConfig = arguments.getOptionalPath(ARG_NAME_ADDITIONAL_CONFIG_DIR);
            Path reportDir = (Path)arguments.getOptionalPath(ARG_NAME_REPORT_DIRECTORY).orElseThrow(() -> new IllegalArgumentException("cc-report-dir must be a path"));
            OnlineBackupRequiredArguments requiredArguments = new OnlineBackupRequiredArguments(address, folder, name, selectedBackupProtocol, fallbackToFull, doConsistencyCheck, timeout, reportDir);
            Path configFile = this.configDir.resolve("neo4j.conf");
            Config.Builder builder = Config.fromFile((Path)configFile);
            Path logPath = requiredArguments.getResolvedLocationFromName();
            Config config = builder.withHome(this.homeDir).withSetting(GraphDatabaseSettings.logical_logs_location, logPath.toString()).withConnectorsDisabled().build();
            additionalConfig.map(this::loadAdditionalConfigFile).ifPresent(arg_0 -> ((Config)config).augment(arg_0));
            config.augment(GraphDatabaseSettings.pagecache_memory, pagecacheMemory);
            config.augment("metrics.prometheus.enabled", "false");
            BiFunction<String, Setting, Boolean> oneOf = (a, s) -> arguments.has(a) ? Boolean.valueOf(arguments.getBoolean(a)) : (Boolean)config.get(s);
            ConsistencyFlags consistencyFlags = new ConsistencyFlags(oneOf.apply(ARG_NAME_CHECK_GRAPH, ConsistencyCheckSettings.consistency_check_graph).booleanValue(), oneOf.apply(ARG_NAME_CHECK_INDEXES, ConsistencyCheckSettings.consistency_check_indexes).booleanValue(), oneOf.apply(ARG_NAME_CHECK_LABELS, ConsistencyCheckSettings.consistency_check_label_scan_store).booleanValue(), oneOf.apply(ARG_NAME_CHECK_OWNERS, ConsistencyCheckSettings.consistency_check_property_owners).booleanValue());
            return new OnlineBackupContext(requiredArguments, config, consistencyFlags);
        }
        catch (IllegalArgumentException e) {
            throw new IncorrectUsage(e.getMessage());
        }
        catch (UncheckedIOException e) {
            throw new CommandFailed(e.getMessage(), (Throwable)e);
        }
    }

    private Path getBackupDirectory(Arguments arguments) throws CommandFailed {
        Path path = arguments.getMandatoryPath(ARG_NAME_BACKUP_DIRECTORY);
        try {
            return path.toRealPath(new LinkOption[0]);
        }
        catch (IOException e) {
            throw new CommandFailed(String.format("Directory '%s' does not exist.", path));
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Config loadAdditionalConfigFile(Path path) {
        try (InputStream in = Files.newInputStream(path, new OpenOption[0]);){
            Config config = Config.fromSettings((Map)MapUtil.load((InputStream)in)).build();
            return config;
        }
        catch (IOException e) {
            throw new UncheckedIOException("Could not read additional configuration from " + path + ". The file either does not exist, is not a regular file, or is not readable.", e);
        }
    }
}

