/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.backup.impl;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Path;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.neo4j.backup.impl.OnlineBackupCommandProvider;
import org.neo4j.backup.impl.SelectedBackupProtocol;
import org.neo4j.commandline.admin.CommandFailed;
import org.neo4j.commandline.admin.IncorrectUsage;
import org.neo4j.commandline.admin.OutsideWorld;
import org.neo4j.commandline.admin.ParameterisedOutsideWorld;
import org.neo4j.io.fs.DefaultFileSystemAbstraction;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.kernel.configuration.Config;

public class OnlineBackupCommandBuilder {
    private String host;
    private Integer port;
    private Boolean fallbackToFull;
    private Long timeout;
    private Boolean checkConsistency;
    private File consistencyReportLocation;
    private Config additionalConfig;
    private SelectedBackupProtocol selectedBackupProtocol;
    private Boolean consistencyCheckGraph;
    private Boolean consistencyCheckIndexes;
    private Boolean consistencyCheckLabel;
    private Boolean consistencyCheckOwners;
    private OutputStream output;
    private Optional<String[]> rawArgs = Optional.empty();

    public OnlineBackupCommandBuilder withRawArgs(String ... args) {
        this.rawArgs = Optional.of(args);
        return this;
    }

    public OnlineBackupCommandBuilder withHost(String host) {
        this.host = host;
        return this;
    }

    public OnlineBackupCommandBuilder withPort(Integer port) {
        this.port = port;
        return this;
    }

    public OnlineBackupCommandBuilder withFallbackToFull(Boolean flag) {
        this.fallbackToFull = flag;
        return this;
    }

    public OnlineBackupCommandBuilder withTimeout(Long timeoutInMillis) {
        this.timeout = timeoutInMillis;
        return this;
    }

    public OnlineBackupCommandBuilder withConsistencyCheck(Boolean flag) {
        this.checkConsistency = flag;
        return this;
    }

    public OnlineBackupCommandBuilder withReportFlag(File consistencyReportLocation) {
        this.consistencyReportLocation = consistencyReportLocation;
        return this;
    }

    public OnlineBackupCommandBuilder withAdditionalConfig(Config additionalConfig) {
        this.additionalConfig = additionalConfig;
        return this;
    }

    public OnlineBackupCommandBuilder withGraphConsistencyCheck(Boolean flag) {
        this.consistencyCheckGraph = flag;
        return this;
    }

    public OnlineBackupCommandBuilder withIndexConsistencyCheck(Boolean flag) {
        this.consistencyCheckIndexes = flag;
        return this;
    }

    public OnlineBackupCommandBuilder withLabelConsistencyCheck(Boolean flag) {
        this.consistencyCheckLabel = flag;
        return this;
    }

    public OnlineBackupCommandBuilder withOwnerConsistencyCheck(Boolean flag) {
        this.consistencyCheckOwners = flag;
        return this;
    }

    public OnlineBackupCommandBuilder withOutput(OutputStream outputStream) {
        this.output = outputStream;
        return this;
    }

    public OnlineBackupCommandBuilder withSelectedBackupStrategy(SelectedBackupProtocol selectedBackupStrategy) {
        this.selectedBackupProtocol = selectedBackupStrategy;
        return this;
    }

    public boolean backup(File neo4jHome, String backupName) throws CommandFailed, IncorrectUsage {
        String[] args;
        File targetLocation = new File(neo4jHome, backupName);
        if (this.rawArgs.isPresent()) {
            args = this.rawArgs.get();
        } else {
            try {
                args = this.resolveArgs(targetLocation);
            }
            catch (IOException e) {
                throw new CommandFailed("Failed to resolve arguments", (Throwable)e);
            }
        }
        new OnlineBackupCommandProvider().create(neo4jHome.toPath(), OnlineBackupCommandBuilder.configDirFromTarget(neo4jHome.toPath()), this.resolveOutsideWorld()).execute(args);
        return true;
    }

    public String[] resolveArgs(File targetLocation) throws IOException {
        return OnlineBackupCommandBuilder.args(this.argBackupName(targetLocation), this.argBackupLocation(targetLocation), this.argFrom(), this.argFallbackToFull(), this.argSelectedProtocol(), this.argTimeout(), this.argCheckConsistency(), this.argReportDir(), this.argAdditionalConf(targetLocation), this.argCcGraph(), this.argCcIndexes(), this.argCcLabel(), this.argCcOwners());
    }

    private OutsideWorld resolveOutsideWorld() {
        Optional<OutputStream> output = Optional.ofNullable(this.output);
        return new ParameterisedOutsideWorld(System.console(), output.orElse(System.out), output.orElse(System.err), System.in, (FileSystemAbstraction)new DefaultFileSystemAbstraction());
    }

    private String argFrom() {
        if (this.host == null && this.port == null) {
            return "";
        }
        String address = String.join((CharSequence)":", Optional.ofNullable(this.host).orElse(""), Optional.ofNullable(this.port).map(port -> Integer.toString(port)).orElse(""));
        return String.format("--from=%s", address);
    }

    private String argBackupLocation(File targetLocation) {
        String location = Optional.ofNullable(targetLocation).map(f -> targetLocation.getParentFile()).orElseThrow(OnlineBackupCommandBuilder.wrongArguments("No target location specified")).toString();
        return String.format("--backup-dir=%s", location);
    }

    private String argBackupName(File targetLocation) {
        String backupName = Optional.ofNullable(targetLocation).map(File::getName).orElseThrow(OnlineBackupCommandBuilder.wrongArguments("No target location specified"));
        return String.format("--name=%s", backupName);
    }

    private static Supplier<IllegalArgumentException> wrongArguments(String message) {
        return () -> new IllegalArgumentException(message);
    }

    private String argFallbackToFull() {
        return Optional.ofNullable(this.fallbackToFull).map(flag -> String.format("--fallback-to-full=%s", flag)).orElse("");
    }

    private String argSelectedProtocol() {
        return Optional.ofNullable(this.selectedBackupProtocol).map(SelectedBackupProtocol::getName).map(argValue -> String.format("--%s=%s", "protocol", argValue)).orElse("");
    }

    private String argTimeout() {
        return Optional.ofNullable(this.timeout).map(value -> String.format("--timeout=%dms", value)).orElse("");
    }

    private String argCcOwners() {
        return Optional.ofNullable(this.consistencyCheckOwners).map(value -> String.format("--check-consistency=%b", this.consistencyCheckOwners)).orElse("");
    }

    private String argCcLabel() {
        return Optional.ofNullable(this.consistencyCheckLabel).map(value -> String.format("--cc-label-scan-store=%b", this.consistencyCheckLabel)).orElse("");
    }

    private String argCcIndexes() {
        return Optional.ofNullable(this.consistencyCheckIndexes).map(value -> String.format("--cc-indexes=%b", this.consistencyCheckIndexes)).orElse("");
    }

    private String argCcGraph() {
        return Optional.ofNullable(this.consistencyCheckGraph).map(value -> String.format("--cc-graph=%b", this.consistencyCheckGraph)).orElse("");
    }

    private String argAdditionalConf(File backupTarget) throws IOException {
        if (this.additionalConfig == null) {
            return "";
        }
        File configFile = backupTarget.toPath().resolve("../additional_neo4j.conf").toFile();
        OnlineBackupCommandBuilder.writeConfigToFile(this.additionalConfig, configFile);
        return String.format("--additional-config=%s", configFile);
    }

    static void writeConfigToFile(Config config, File file) throws IOException {
        try (BufferedWriter fileWriter = new BufferedWriter(new FileWriter(file));){
            for (Map.Entry entry : config.getRaw().entrySet()) {
                fileWriter.write(String.format("%s=%s\n", entry.getKey(), entry.getValue()));
            }
        }
    }

    private String argReportDir() {
        return Optional.ofNullable(this.consistencyReportLocation).map(value -> String.format("--cc-report-dir=%s", value)).orElse("");
    }

    private String argCheckConsistency() {
        return Optional.ofNullable(this.checkConsistency).map(value -> String.format("--check-consistency=%s", value)).orElse("");
    }

    private static String[] args(String ... args) {
        return (String[])Stream.of(args).filter(xva$0 -> StringUtils.isNoneEmpty((CharSequence[])new CharSequence[]{xva$0})).toArray(String[]::new);
    }

    private static Path configDirFromTarget(Path neo4jHome) {
        return neo4jHome.resolve("conf");
    }
}

