/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.backup.impl;

import java.io.File;
import java.nio.file.Path;
import java.util.Map;
import org.neo4j.backup.impl.BackupProtocolService;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.io.fs.FileUtils;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.internal.GraphDatabaseAPI;

class BackupRecoveryService {
    BackupRecoveryService() {
    }

    void recoverWithDatabase(Path databaseDirectory, PageCache pageCache, Config config) {
        Map configParams = config.getRaw();
        configParams.put(GraphDatabaseSettings.logical_logs_location.name(), databaseDirectory.toString());
        configParams.put(GraphDatabaseSettings.active_database.name(), databaseDirectory.getFileName().toString());
        configParams.put(GraphDatabaseSettings.pagecache_warmup_enabled.name(), "false");
        GraphDatabaseAPI targetDb = BackupProtocolService.startTemporaryDb(databaseDirectory.getParent(), pageCache, configParams);
        targetDb.shutdown();
        File lockFile = new File(databaseDirectory.getParent().toFile(), "store_lock");
        if (lockFile.exists()) {
            FileUtils.deleteFile((File)lockFile);
        }
    }
}

