/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.backup;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.ZoneId;
import java.util.Map;
import java.util.NoSuchElementException;
import org.neo4j.backup.BackupExtensionService;
import org.neo4j.backup.IncrementalBackupNotPossibleException;
import org.neo4j.backup.impl.BackupClient;
import org.neo4j.backup.impl.BackupOutcome;
import org.neo4j.backup.impl.BackupProtocolService;
import org.neo4j.backup.impl.ConsistencyCheck;
import org.neo4j.com.ComException;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.helpers.Args;
import org.neo4j.helpers.HostnamePort;
import org.neo4j.helpers.Service;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.logging.LogService;
import org.neo4j.kernel.impl.logging.SimpleLogService;
import org.neo4j.kernel.impl.store.MismatchingStoreIdException;
import org.neo4j.kernel.impl.store.UnexpectedStoreVersionException;
import org.neo4j.logging.FormattedLogProvider;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.LogTimeZone;
import org.neo4j.logging.NullLogProvider;

@Deprecated
public class BackupTool {
    private static final String TO = "to";
    private static final String HOST = "host";
    private static final String PORT = "port";
    private static final String FROM = "from";
    private static final String VERIFY = "verify";
    private static final String CONFIG = "config";
    private static final String CONSISTENCY_CHECKER = "consistency-checker";
    private static final String TIMEOUT = "timeout";
    private static final String FORENSICS = "gather-forensics";
    public static final String DEFAULT_SCHEME = "single";
    static final String MISMATCHED_STORE_ID = "You tried to perform a backup from database %s, but the target directory contained a backup from database %s. ";
    static final String WRONG_FROM_ADDRESS_SYNTAX = "Please properly specify a location to backup in the form " + BackupTool.dash("host") + " <host> " + BackupTool.dash("port") + " <port>";
    static final String UNKNOWN_SCHEMA_MESSAGE_PATTERN = "%s was specified as a backup module but it was not found. Please make sure that the implementing service is on the classpath.";
    static final String NO_SOURCE_SPECIFIED = "Please specify " + BackupTool.dash("host") + " and optionally " + BackupTool.dash("port") + ", examples:\n  " + BackupTool.dash("host") + " 192.168.1.34\n  " + BackupTool.dash("host") + " 192.168.1.34 " + BackupTool.dash("port") + " 1234";
    private final BackupProtocolService backupProtocolService;
    private final PrintStream systemOut;

    public static void main(String[] args) {
        System.err.println("WARNING: neo4j-backup is deprecated and support for it will be removed in a future\nversion of Neo4j; please use neo4j-admin backup instead.\n");
        BackupTool tool = new BackupTool(new BackupProtocolService(), System.out);
        try {
            BackupOutcome backupOutcome = tool.run(args);
            if (!backupOutcome.isConsistent()) {
                BackupTool.exitFailure("WARNING: The database is inconsistent.");
            }
        }
        catch (ToolFailureException e) {
            System.out.println("Backup failed.");
            BackupTool.exitFailure(e.getMessage());
        }
    }

    BackupTool(BackupProtocolService backupProtocolService, PrintStream systemOut) {
        this.backupProtocolService = backupProtocolService;
        this.systemOut = systemOut;
    }

    BackupOutcome run(String[] args) throws ToolFailureException {
        Args arguments = Args.withFlags((String[])new String[]{VERIFY}).parse(args);
        if (!arguments.hasNonNull(TO)) {
            throw new ToolFailureException("Specify target location with " + BackupTool.dash(TO) + " <target-directory>");
        }
        if (arguments.hasNonNull(FROM) && !arguments.has(HOST) && !arguments.has(PORT)) {
            return this.runBackupWithLegacyArgs(arguments);
        }
        if (arguments.hasNonNull(HOST)) {
            return this.runBackup(arguments);
        }
        throw new ToolFailureException(NO_SOURCE_SPECIFIED);
    }

    private BackupOutcome runBackupWithLegacyArgs(Args args) throws ToolFailureException {
        String from = args.get(FROM).trim();
        Path to = Paths.get(args.get(TO).trim(), new String[0]);
        Config tuningConfiguration = BackupTool.readConfiguration(args);
        boolean forensics = args.getBoolean(FORENSICS, Boolean.valueOf(false), Boolean.valueOf(true));
        ConsistencyCheck consistencyCheck = BackupTool.parseConsistencyChecker(args);
        long timeout = args.getDuration(TIMEOUT, BackupClient.BIG_READ_TIMEOUT);
        URI backupURI = BackupTool.resolveBackupUri(from, args, tuningConfiguration);
        HostnamePort hostnamePort = BackupTool.newHostnamePort(backupURI);
        return this.executeBackup(hostnamePort, to, consistencyCheck, tuningConfiguration, timeout, forensics);
    }

    private static ConsistencyCheck parseConsistencyChecker(Args args) {
        boolean verify = args.getBoolean(VERIFY, Boolean.valueOf(true), Boolean.valueOf(true));
        if (verify) {
            String consistencyCheckerName = args.get(CONSISTENCY_CHECKER, ConsistencyCheck.FULL.name(), ConsistencyCheck.FULL.name());
            return ConsistencyCheck.fromString(consistencyCheckerName);
        }
        return ConsistencyCheck.NONE;
    }

    private BackupOutcome runBackup(Args args) throws ToolFailureException {
        String host = args.get(HOST).trim();
        int port = args.getNumber(PORT, (Number)6362).intValue();
        Path to = Paths.get(args.get(TO).trim(), new String[0]);
        Config tuningConfiguration = BackupTool.readConfiguration(args);
        boolean forensics = args.getBoolean(FORENSICS, Boolean.valueOf(false), Boolean.valueOf(true));
        ConsistencyCheck consistencyCheck = BackupTool.parseConsistencyChecker(args);
        if (host.contains(":")) {
            if (!host.startsWith("[")) {
                host = "[" + host;
            }
            if (!host.endsWith("]")) {
                host = host + "]";
            }
        }
        long timeout = args.getDuration(TIMEOUT, BackupClient.BIG_READ_TIMEOUT);
        URI backupURI = BackupTool.newURI("single://" + host + ":" + port);
        HostnamePort hostnamePort = BackupTool.newHostnamePort(backupURI);
        return this.executeBackup(hostnamePort, to, consistencyCheck, tuningConfiguration, timeout, forensics);
    }

    BackupOutcome executeBackup(HostnamePort hostnamePort, Path to, ConsistencyCheck consistencyCheck, Config config, long timeout, boolean forensics) throws ToolFailureException {
        try {
            this.systemOut.println("Performing backup from '" + hostnamePort + "'");
            String host = hostnamePort.getHost();
            int port = hostnamePort.getPort();
            BackupOutcome outcome = this.backupProtocolService.doIncrementalBackupOrFallbackToFull(host, port, to, consistencyCheck, config, timeout, forensics);
            this.systemOut.println("Done");
            return outcome;
        }
        catch (IncrementalBackupNotPossibleException | UnexpectedStoreVersionException e) {
            throw new ToolFailureException(e.getMessage(), e);
        }
        catch (MismatchingStoreIdException e) {
            throw new ToolFailureException(String.format(MISMATCHED_STORE_ID, e.getExpected(), e.getEncountered()));
        }
        catch (ComException e) {
            throw new ToolFailureException("Couldn't connect to '" + hostnamePort + "'", e);
        }
    }

    private static Config readConfiguration(Args arguments) throws ToolFailureException {
        Map specifiedConfig = MapUtil.stringMap((String[])new String[0]);
        String configFilePath = arguments.get(CONFIG, null);
        if (configFilePath != null) {
            File configFile = new File(configFilePath);
            try {
                specifiedConfig = MapUtil.load((File)configFile);
            }
            catch (IOException e) {
                throw new ToolFailureException(String.format("Could not read configuration file [%s]", configFilePath), e);
            }
        }
        return Config.defaults((Map)specifiedConfig);
    }

    private static URI resolveBackupUri(String from, Args arguments, Config config) throws ToolFailureException {
        if (from.contains(",")) {
            if (!from.startsWith("ha://")) {
                BackupTool.checkNoSchemaIsPresent(from);
                from = "ha://" + from;
            }
            return BackupTool.resolveUriWithProvider("ha", config, from, arguments);
        }
        if (!from.startsWith("single://")) {
            from = from.replace("ha://", "");
            BackupTool.checkNoSchemaIsPresent(from);
            from = "single://" + from;
        }
        return BackupTool.newURI(from);
    }

    private static void checkNoSchemaIsPresent(String address) throws ToolFailureException {
        if (address.contains("://")) {
            throw new ToolFailureException(WRONG_FROM_ADDRESS_SYNTAX);
        }
    }

    private static URI newURI(String uriString) throws ToolFailureException {
        try {
            return new URI(uriString);
        }
        catch (URISyntaxException e) {
            throw new ToolFailureException(WRONG_FROM_ADDRESS_SYNTAX);
        }
    }

    private static URI resolveUriWithProvider(String providerName, Config config, String from, Args args) throws ToolFailureException {
        BackupExtensionService service;
        try {
            service = (BackupExtensionService)Service.load(BackupExtensionService.class, (String)providerName);
        }
        catch (NoSuchElementException e) {
            throw new ToolFailureException(String.format(UNKNOWN_SCHEMA_MESSAGE_PATTERN, providerName));
        }
        try {
            ZoneId logTimeZone = ((LogTimeZone)config.get(GraphDatabaseSettings.db_timezone)).getZoneId();
            FormattedLogProvider userLogProvider = FormattedLogProvider.withZoneId((ZoneId)logTimeZone).toOutputStream((OutputStream)System.out);
            return service.resolve(from, args, (LogService)new SimpleLogService((LogProvider)userLogProvider, (LogProvider)NullLogProvider.getInstance()));
        }
        catch (Throwable t) {
            throw new ToolFailureException(t.getMessage());
        }
    }

    private static HostnamePort newHostnamePort(URI backupURI) throws ToolFailureException {
        if (backupURI == null || backupURI.getHost() == null) {
            throw new ToolFailureException(WRONG_FROM_ADDRESS_SYNTAX);
        }
        String host = backupURI.getHost();
        int port = backupURI.getPort();
        if (port == -1) {
            port = 6362;
        }
        return new HostnamePort(host, port);
    }

    private static String dash(String name) {
        return "-" + name;
    }

    static void exitFailure(String msg) {
        System.out.println(msg);
        System.exit(1);
    }

    static class ToolFailureException
    extends Exception {
        ToolFailureException(String message) {
            super(message);
        }

        ToolFailureException(String message, Throwable cause) {
            super(message, cause);
        }
    }
}

