/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.backup_stores;

import java.io.File;
import java.util.Optional;
import java.util.UUID;
import org.neo4j.causalclustering.BackupUtil;
import org.neo4j.causalclustering.backup_stores.BackupStore;
import org.neo4j.causalclustering.discovery.Cluster;
import org.neo4j.causalclustering.discovery.CoreClusterMember;

public abstract class AbstractStoreGenerator
implements BackupStore {
    abstract CoreClusterMember createData(Cluster<?> var1) throws Exception;

    abstract void modify(File var1);

    @Override
    public Optional<File> generate(File backupDir, Cluster<?> backupCluster) throws Exception {
        CoreClusterMember core = this.createData(backupCluster);
        File backupFromCore = BackupUtil.createBackupFromCore(core, AbstractStoreGenerator.backupName(), backupDir);
        this.modify(backupFromCore);
        return Optional.of(backupFromCore);
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }

    private static String backupName() {
        return "backup-" + UUID.randomUUID().toString().substring(5);
    }
}

