/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering;

import java.io.File;
import java.io.IOException;
import org.junit.Assert;
import org.neo4j.causalclustering.BackupCoreIT;
import org.neo4j.causalclustering.discovery.ClusterMember;
import org.neo4j.causalclustering.discovery.CoreClusterMember;
import org.neo4j.commandline.admin.CommandFailed;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.restore.RestoreDatabaseCommand;
import org.neo4j.util.TestHelpers;

public class BackupUtil {
    private static String backupAddress(CoreClusterMember core) {
        return core.settingValue("causal_clustering.transaction_listen_address");
    }

    public static File createBackupFromCore(CoreClusterMember core, String backupName, File baseBackupDir) throws Exception {
        String[] args = BackupCoreIT.backupArguments(BackupUtil.backupAddress(core), baseBackupDir, backupName);
        Assert.assertEquals((long)0L, (long)TestHelpers.runBackupToolFromOtherJvmToGetExitCode((File)baseBackupDir, (String[])args));
        return new File(baseBackupDir, backupName);
    }

    public static void restoreFromBackup(File backup, FileSystemAbstraction fsa, ClusterMember clusterMember) throws IOException, CommandFailed {
        Config config = clusterMember.config();
        RestoreDatabaseCommand restoreDatabaseCommand = new RestoreDatabaseCommand(fsa, backup, config, "graph.db", true);
        restoreDatabaseCommand.execute();
    }
}

