/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering;

import java.io.File;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.causalclustering.core.CoreGraphDatabase;
import org.neo4j.causalclustering.core.consensus.roles.Role;
import org.neo4j.causalclustering.discovery.Cluster;
import org.neo4j.causalclustering.discovery.CoreClusterMember;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.enterprise.configuration.OnlineBackupSettings;
import org.neo4j.ports.allocation.PortAuthority;
import org.neo4j.test.DbRepresentation;
import org.neo4j.test.causalclustering.ClusterRule;
import org.neo4j.test.rule.SuppressOutput;
import org.neo4j.util.TestHelpers;

public class BackupCoreIT {
    @Rule
    public final SuppressOutput suppressOutput = SuppressOutput.suppressAll();
    @Rule
    public final ClusterRule clusterRule = new ClusterRule().withNumberOfCoreMembers(3).withNumberOfReadReplicas(0);
    private Cluster<?> cluster;
    private File backupsDir;

    @Before
    public void setup() throws Exception {
        this.backupsDir = this.clusterRule.testDirectory().cleanDirectory("backups");
        this.cluster = this.clusterRule.startCluster();
    }

    @Test
    public void makeSureBackupCanBePerformedFromAnyInstance() throws Throwable {
        for (CoreClusterMember db : this.cluster.coreMembers()) {
            DbRepresentation beforeChange = DbRepresentation.of((GraphDatabaseService)BackupCoreIT.createSomeData(this.cluster));
            String[] args = BackupCoreIT.backupArguments(BackupCoreIT.backupAddress(this.cluster), this.backupsDir, "" + db.serverId());
            org.neo4j.test.assertion.Assert.assertEventually(() -> TestHelpers.runBackupToolFromOtherJvmToGetExitCode((File)this.clusterRule.clusterDirectory(), (String[])args), (Matcher)Matchers.equalTo((Object)0), (long)5L, (TimeUnit)TimeUnit.SECONDS);
            DbRepresentation afterChange = DbRepresentation.of((GraphDatabaseService)BackupCoreIT.createSomeData(this.cluster));
            Config config = BackupCoreIT.getConfig();
            config.augment(GraphDatabaseSettings.active_database, "" + db.serverId());
            DbRepresentation backupRepresentation = DbRepresentation.of((File)this.backupsDir, (Config)config);
            Assert.assertEquals((Object)beforeChange, (Object)backupRepresentation);
            Assert.assertNotEquals((Object)backupRepresentation, (Object)afterChange);
        }
    }

    static CoreGraphDatabase createSomeData(Cluster<?> cluster) throws Exception {
        return cluster.coreTx((db, tx) -> {
            Node node = db.createNode(new Label[]{Label.label((String)"boo")});
            node.setProperty("foobar", (Object)"baz_bat");
            tx.success();
        }).database();
    }

    private static String backupAddress(Cluster<?> cluster) {
        return cluster.getMemberWithRole(Role.LEADER).settingValue("causal_clustering.transaction_listen_address");
    }

    static String[] backupArguments(String from, File backupsDir, String name) {
        ArrayList<String> args = new ArrayList<String>();
        args.add("--from=" + from);
        args.add("--cc-report-dir=" + backupsDir);
        args.add("--backup-dir=" + backupsDir);
        args.add("--protocol=catchup");
        args.add("--name=" + name);
        return args.toArray(new String[0]);
    }

    static Config getConfig() {
        Map config = MapUtil.stringMap((String[])new String[]{GraphDatabaseSettings.record_format.name(), "standard", OnlineBackupSettings.online_backup_server.name(), "127.0.0.1:" + PortAuthority.allocatePort()});
        return Config.defaults((Map)config);
    }
}

