/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.backup.impl;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.internal.matchers.ThrowableCauseMatcher;
import org.junit.rules.ExpectedException;
import org.neo4j.backup.impl.OnlineBackupContext;
import org.neo4j.backup.impl.OnlineBackupContextFactory;
import org.neo4j.backup.impl.OnlineBackupRequiredArguments;
import org.neo4j.backup.impl.SelectedBackupProtocol;
import org.neo4j.causalclustering.core.CausalClusteringSettings;
import org.neo4j.commandline.admin.CommandFailed;
import org.neo4j.commandline.admin.IncorrectUsage;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.test.rule.SuppressOutput;
import org.neo4j.test.rule.TestDirectory;

public class OnlineBackupContextFactoryTest {
    @Rule
    public TestDirectory testDirectory = TestDirectory.testDirectory();
    @Rule
    public ExpectedException expected = ExpectedException.none();
    @Rule
    public SuppressOutput suppress = SuppressOutput.suppressAll();
    private Path homeDir;
    private Path configDir;
    private Path configFile;

    @Before
    public void setUp() throws IOException {
        this.homeDir = this.testDirectory.directory("home").toPath();
        this.configDir = this.testDirectory.directory("config").toPath();
        this.configFile = this.configDir.resolve("neo4j.conf");
        String neo4jConfContents = "dbms.backup.address = localhost:1234";
        Files.write(this.configFile, Collections.singletonList(neo4jConfContents), new OpenOption[0]);
    }

    @Test
    public void unspecifiedHostnameIsEmptyOptional() throws Exception {
        OnlineBackupContextFactory handler = new OnlineBackupContextFactory(this.homeDir, this.configDir);
        OnlineBackupContext context = handler.createContext(this.requiredAnd("--from=:1234"));
        OnlineBackupRequiredArguments requiredArguments = context.getRequiredArguments();
        Assert.assertFalse((boolean)requiredArguments.getAddress().getHostname().isPresent());
        Assert.assertEquals((long)1234L, (long)((Integer)requiredArguments.getAddress().getPort().get()).intValue());
    }

    @Test
    public void unspecifiedPortIsEmptyOptional() throws Exception {
        OnlineBackupContextFactory handler = new OnlineBackupContextFactory(this.homeDir, this.configDir);
        OnlineBackupContext context = handler.createContext(this.requiredAnd("--from=abc"));
        OnlineBackupRequiredArguments requiredArguments = context.getRequiredArguments();
        Assert.assertEquals((Object)"abc", requiredArguments.getAddress().getHostname().get());
        Assert.assertFalse((boolean)requiredArguments.getAddress().getPort().isPresent());
    }

    @Test
    public void acceptHostWithTrailingPort() throws Exception {
        OnlineBackupContextFactory handler = new OnlineBackupContextFactory(this.homeDir, this.configDir);
        OnlineBackupContext context = handler.createContext(this.requiredAnd("--from=foo.bar.server:"));
        OnlineBackupRequiredArguments requiredArguments = context.getRequiredArguments();
        Assert.assertEquals((Object)"foo.bar.server", requiredArguments.getAddress().getHostname().get());
        Assert.assertFalse((boolean)requiredArguments.getAddress().getPort().isPresent());
    }

    @Test
    public void acceptPortWithPrecedingEmptyHost() throws Exception {
        OnlineBackupContextFactory handler = new OnlineBackupContextFactory(this.homeDir, this.configDir);
        OnlineBackupContext context = handler.createContext(this.requiredAnd("--from=:1234"));
        OnlineBackupRequiredArguments requiredArguments = context.getRequiredArguments();
        Assert.assertFalse((boolean)requiredArguments.getAddress().getHostname().isPresent());
        Assert.assertEquals((long)1234L, (long)((Integer)requiredArguments.getAddress().getPort().get()).intValue());
    }

    @Test
    public void acceptBothIfSpecified() throws Exception {
        OnlineBackupContextFactory handler = new OnlineBackupContextFactory(this.homeDir, this.configDir);
        OnlineBackupContext context = handler.createContext(this.requiredAnd("--from=foo.bar.server:1234"));
        OnlineBackupRequiredArguments requiredArguments = context.getRequiredArguments();
        Assert.assertEquals((Object)"foo.bar.server", requiredArguments.getAddress().getHostname().get());
        Assert.assertEquals((long)1234L, (long)((Integer)requiredArguments.getAddress().getPort().get()).intValue());
    }

    @Test
    public void backupDirectoryArgumentIsMandatory() throws Exception {
        this.expected.expect(IncorrectUsage.class);
        this.expected.expectMessage("Missing argument 'backup-dir'");
        new OnlineBackupContextFactory(this.homeDir, this.configDir).createContext(new String[0]);
    }

    @Test
    public void shouldDefaultTimeoutToTwentyMinutes() throws Exception {
        OnlineBackupContextFactory handler = new OnlineBackupContextFactory(this.homeDir, this.configDir);
        OnlineBackupContext context = handler.createContext(new String[]{"--backup-dir=/", "--name=mybackup"});
        OnlineBackupRequiredArguments requiredArguments = context.getRequiredArguments();
        Assert.assertEquals((long)TimeUnit.MINUTES.toMillis(20L), (long)requiredArguments.getTimeout());
    }

    @Test
    public void shouldInterpretAUnitlessTimeoutAsSeconds() throws Exception {
        OnlineBackupContextFactory handler = new OnlineBackupContextFactory(this.homeDir, this.configDir);
        OnlineBackupContext context = handler.createContext(new String[]{"--timeout=10", "--backup-dir=/", "--name=mybackup"});
        OnlineBackupRequiredArguments requiredArguments = context.getRequiredArguments();
        Assert.assertEquals((long)TimeUnit.SECONDS.toMillis(10L), (long)requiredArguments.getTimeout());
    }

    @Test
    public void shouldParseATimeoutWithUnits() throws Exception {
        OnlineBackupContextFactory handler = new OnlineBackupContextFactory(this.homeDir, this.configDir);
        OnlineBackupContext context = handler.createContext(this.requiredAnd("--timeout=10h"));
        OnlineBackupRequiredArguments requiredArguments = context.getRequiredArguments();
        Assert.assertEquals((long)TimeUnit.HOURS.toMillis(10L), (long)requiredArguments.getTimeout());
    }

    @Test
    public void shouldTreatNameArgumentAsMandatory() throws Exception {
        this.expected.expect(IncorrectUsage.class);
        this.expected.expectMessage("Missing argument 'name'");
        OnlineBackupContextFactory handler = new OnlineBackupContextFactory(this.homeDir, this.configDir);
        handler.createContext(new String[]{"--backup-dir=/"});
    }

    @Test
    public void reportDirMustBeAPath() throws Exception {
        this.expected.expect(IncorrectUsage.class);
        this.expected.expectMessage("cc-report-dir must be a path");
        OnlineBackupContextFactory handler = new OnlineBackupContextFactory(this.homeDir, this.configDir);
        handler.createContext(this.requiredAnd("--check-consistency", "--cc-report-dir"));
    }

    @Test
    public void errorHandledForNonExistingAdditionalConfigFile() throws Exception {
        Path additionalConf = this.homeDir.resolve("neo4j.conf");
        this.expected.expect(CommandFailed.class);
        this.expected.expectCause(ThrowableCauseMatcher.hasCause((Matcher)Matchers.any(NoSuchFileException.class)));
        OnlineBackupContextFactory handler = new OnlineBackupContextFactory(this.homeDir, this.configDir);
        handler.createContext(this.requiredAnd("--additional-config=" + additionalConf));
    }

    @Test
    public void prioritiseConfigDirOverHomeDir() throws Exception {
        Files.write(this.configFile, Collections.singletonList("causal_clustering.minimum_core_cluster_size_at_startup=4"), StandardOpenOption.WRITE);
        Path homeDirConfigFile = this.homeDir.resolve("neo4j.conf");
        Files.write(homeDirConfigFile, Arrays.asList("causal_clustering.minimum_core_cluster_size_at_startup=5", "causal_clustering.raft_in_queue_max_batch=21"), new OpenOption[0]);
        OnlineBackupContextFactory handler = new OnlineBackupContextFactory(this.homeDir, this.configDir);
        Config config = handler.createContext(this.requiredAnd(new String[0])).getConfig();
        Assert.assertEquals((Object)3, (Object)config.get(CausalClusteringSettings.minimum_core_cluster_size_at_formation));
        Assert.assertEquals((Object)128, (Object)config.get(CausalClusteringSettings.raft_in_queue_max_batch));
    }

    @Test
    public void prioritiseAdditionalOverConfigDir() throws Exception {
        Files.write(this.configFile, Arrays.asList("causal_clustering.minimum_core_cluster_size_at_startup=4", "causal_clustering.raft_in_queue_max_batch=21"), new OpenOption[0]);
        Path additionalConf = this.homeDir.resolve("additional-neo4j.conf");
        Files.write(additionalConf, Collections.singletonList("causal_clustering.minimum_core_cluster_size_at_startup=5"), new OpenOption[0]);
        OnlineBackupContextFactory handler = new OnlineBackupContextFactory(this.homeDir, this.configDir);
        OnlineBackupContext context = handler.createContext(this.requiredAnd("--additional-config=" + additionalConf));
        Config config = context.getConfig();
        Assert.assertEquals((Object)3, (Object)config.get(CausalClusteringSettings.minimum_core_cluster_size_at_formation));
        Assert.assertEquals((Object)21, (Object)config.get(CausalClusteringSettings.raft_in_queue_max_batch));
    }

    @Test
    public void mustIgnorePageCacheConfigInConfigFile() throws Exception {
        Files.write(this.configFile, Collections.singletonList(GraphDatabaseSettings.pagecache_memory.name() + "=42m"), new OpenOption[0]);
        OnlineBackupContextFactory contextBuilder = new OnlineBackupContextFactory(this.homeDir, this.configDir);
        OnlineBackupContext context = contextBuilder.createContext(this.requiredAnd(new String[0]));
        Assert.assertThat((Object)context.getConfig().get(GraphDatabaseSettings.pagecache_memory), (Matcher)Matchers.is((Object)"8m"));
    }

    @Test
    public void mustIgnorePageCacheConfigInAdditionalConfigFile() throws Exception {
        Path additionalConf = this.homeDir.resolve("additional-neo4j.conf");
        Files.write(additionalConf, Collections.singletonList(GraphDatabaseSettings.pagecache_memory.name() + "=42m"), new OpenOption[0]);
        OnlineBackupContextFactory builder = new OnlineBackupContextFactory(this.homeDir, this.configDir);
        OnlineBackupContext context = builder.createContext(this.requiredAnd("--additional-config=" + additionalConf));
        Assert.assertThat((Object)context.getConfig().get(GraphDatabaseSettings.pagecache_memory), (Matcher)Matchers.is((Object)"8m"));
    }

    @Test
    public void mustRespectPageCacheConfigFromCommandLineArguments() throws Exception {
        OnlineBackupContextFactory builder = new OnlineBackupContextFactory(this.homeDir, this.configDir);
        OnlineBackupContext context = builder.createContext(this.requiredAnd("--pagecache=42m"));
        Assert.assertThat((Object)context.getConfig().get(GraphDatabaseSettings.pagecache_memory), (Matcher)Matchers.is((Object)"42m"));
    }

    @Test
    public void logsMustBePlacedInTargetBackupDirectory() throws Exception {
        String name = "mybackup";
        Path backupDir = this.homeDir.resolve("poke");
        Path backupPath = backupDir.resolve(name);
        Files.createDirectories(backupDir, new FileAttribute[0]);
        OnlineBackupContextFactory builder = new OnlineBackupContextFactory(this.homeDir, this.configDir);
        OnlineBackupContext context = builder.createContext(new String[]{"--backup-dir=" + backupDir, "--name=" + name});
        Assert.assertThat((Object)((File)context.getConfig().get(GraphDatabaseSettings.logical_logs_location)).getAbsolutePath(), (Matcher)Matchers.is((Object)backupPath.toString()));
    }

    @Test
    public void defaultProtocolIsAny() throws CommandFailed, IncorrectUsage {
        OnlineBackupContextFactory builder = new OnlineBackupContextFactory(this.homeDir, this.configDir);
        OnlineBackupContext context = builder.createContext(this.requiredAnd(new String[0]));
        Assert.assertEquals((Object)SelectedBackupProtocol.ANY, (Object)context.getRequiredArguments().getSelectedBackupProtocol());
    }

    @Test
    public void overrideWithLegacy() throws CommandFailed, IncorrectUsage {
        List<String> input = Arrays.asList("common", "catchup");
        List<SelectedBackupProtocol> expected = Arrays.asList(SelectedBackupProtocol.COMMON, SelectedBackupProtocol.CATCHUP);
        for (int useCase = 0; useCase < input.size(); ++useCase) {
            OnlineBackupContextFactory builder = new OnlineBackupContextFactory(this.homeDir, this.configDir);
            OnlineBackupContext context = builder.createContext(this.requiredAnd("--protocol=" + input.get(useCase)));
            Assert.assertEquals((Object)expected.get(useCase), (Object)context.getRequiredArguments().getSelectedBackupProtocol());
        }
    }

    @Test
    public void prometheusShouldBeDisabledToAvoidPortConflicts() throws CommandFailed, IncorrectUsage {
        OnlineBackupContext context = new OnlineBackupContextFactory(this.homeDir, this.configDir).createContext(this.requiredAnd(new String[0]));
        Assert.assertEquals((Object)"false", context.getConfig().getRaw().get("metrics.prometheus.enabled"));
    }

    @Test
    public void ipv6CanBeProcessed() throws CommandFailed, IncorrectUsage {
        OnlineBackupContextFactory builder = new OnlineBackupContextFactory(this.homeDir, this.configDir);
        OnlineBackupContext context = builder.createContext(this.requiredAnd("--from=[fd00:ce10::2]:6362"));
        Assert.assertEquals((Object)"fd00:ce10::2", context.getRequiredArguments().getAddress().getHostname().get());
        Assert.assertEquals((Object)6362, context.getRequiredArguments().getAddress().getPort().get());
    }

    private String[] requiredAnd(String ... additionalArgs) {
        ArrayList<String> args = new ArrayList<String>();
        args.add("--backup-dir=/");
        args.add("--name=mybackup");
        Collections.addAll(args, additionalArgs);
        return args.toArray(new String[0]);
    }
}

