/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.backup.impl;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.List;
import org.hamcrest.Matcher;
import org.hamcrest.core.StringContains;
import org.hamcrest.text.StringContainsInOrder;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.neo4j.backup.impl.BackupDelegator;
import org.neo4j.backup.impl.BackupProtocolService;
import org.neo4j.backup.impl.BackupStrategyCoordinator;
import org.neo4j.backup.impl.BackupStrategyCoordinatorFactory;
import org.neo4j.backup.impl.BackupSupportingClasses;
import org.neo4j.backup.impl.BackupSupportingClassesFactory;
import org.neo4j.backup.impl.OnlineBackupCommand;
import org.neo4j.backup.impl.OnlineBackupCommandProvider;
import org.neo4j.backup.impl.OnlineBackupContext;
import org.neo4j.backup.impl.OnlineBackupContextFactory;
import org.neo4j.backup.impl.OnlineBackupRequiredArguments;
import org.neo4j.backup.impl.SelectedBackupProtocol;
import org.neo4j.commandline.admin.AdminCommand;
import org.neo4j.commandline.admin.CommandFailed;
import org.neo4j.commandline.admin.CommandLocator;
import org.neo4j.commandline.admin.IncorrectUsage;
import org.neo4j.commandline.admin.OutsideWorld;
import org.neo4j.commandline.admin.ParameterisedOutsideWorld;
import org.neo4j.commandline.admin.Usage;
import org.neo4j.consistency.checking.full.ConsistencyFlags;
import org.neo4j.io.fs.DefaultFileSystemAbstraction;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.util.OptionalHostnamePort;
import org.neo4j.test.rule.TestDirectory;

public class OnlineBackupCommandTest {
    @Rule
    public ExpectedException expected = ExpectedException.none();
    private FileSystemAbstraction fileSystemAbstraction = new DefaultFileSystemAbstraction();
    @Rule
    public TestDirectory testDirectory = TestDirectory.testDirectory((FileSystemAbstraction)this.fileSystemAbstraction);
    private BackupStrategyCoordinatorFactory backupStrategyCoordinatorFactory = (BackupStrategyCoordinatorFactory)Mockito.mock(BackupStrategyCoordinatorFactory.class);
    private BackupStrategyCoordinator backupStrategyCoordinator = (BackupStrategyCoordinator)Mockito.mock(BackupStrategyCoordinator.class);
    private ByteArrayOutputStream baosOut = new ByteArrayOutputStream();
    private ByteArrayOutputStream baosErr = new ByteArrayOutputStream();
    private PrintStream stdout = new PrintStream(this.baosOut);
    private PrintStream stderr = new PrintStream(this.baosErr);
    private OutsideWorld outsideWorld = new ParameterisedOutsideWorld(System.console(), (OutputStream)this.stdout, (OutputStream)this.stderr, System.in, this.fileSystemAbstraction);
    private final Config config = Config.defaults();
    private OnlineBackupRequiredArguments requiredArguments;
    private final ConsistencyFlags consistencyFlags = new ConsistencyFlags(true, true, true, true);
    private Path backupDirectory;
    private Path reportDirectory;
    private BackupSupportingClassesFactory backupSupportingClassesFactory = (BackupSupportingClassesFactory)Mockito.mock(BackupSupportingClassesFactory.class);
    private final OptionalHostnamePort address = new OptionalHostnamePort("hostname", Integer.valueOf(12), Integer.valueOf(34));
    private final String backupName = "backup name";
    private final boolean fallbackToFull = true;
    private final boolean doConsistencyCheck = true;
    private final long timeout = 1000L;
    private OnlineBackupCommand subject;

    @Before
    public void setup() {
        this.backupDirectory = this.testDirectory.directory("backupDirectory").toPath();
        this.reportDirectory = this.testDirectory.directory("reportDirectory/").toPath();
        BackupSupportingClasses backupSupportingClasses = new BackupSupportingClasses((BackupDelegator)Mockito.mock(BackupDelegator.class), (BackupProtocolService)Mockito.mock(BackupProtocolService.class), (PageCache)Mockito.mock(PageCache.class));
        Mockito.when((Object)this.backupSupportingClassesFactory.createSupportingClasses((Config)ArgumentMatchers.any())).thenReturn((Object)backupSupportingClasses);
        this.requiredArguments = new OnlineBackupRequiredArguments(this.address, this.backupDirectory, "backup name", SelectedBackupProtocol.ANY, true, true, 1000L, this.reportDirectory);
        OnlineBackupContext onlineBackupContext = new OnlineBackupContext(this.requiredArguments, this.config, this.consistencyFlags);
        Mockito.when((Object)this.backupStrategyCoordinatorFactory.backupStrategyCoordinator((OnlineBackupContext)ArgumentMatchers.any(), (BackupProtocolService)ArgumentMatchers.any(), (BackupDelegator)ArgumentMatchers.any(), (PageCache)ArgumentMatchers.any())).thenReturn((Object)this.backupStrategyCoordinator);
        this.subject = OnlineBackupCommandTest.newOnlineBackupCommand(this.outsideWorld, onlineBackupContext, this.backupSupportingClassesFactory, this.backupStrategyCoordinatorFactory);
    }

    @Test
    public void nonExistingBackupDirectoryRaisesException() throws CommandFailed, IncorrectUsage, IOException {
        this.fileSystemAbstraction.deleteRecursively(this.backupDirectory.toFile());
        this.fileSystemAbstraction.create(this.backupDirectory.toFile()).close();
        this.expected.expect(CommandFailed.class);
        this.expected.expectMessage(StringContainsInOrder.stringContainsInOrder(Arrays.asList("Directory '", "backupDirectory' does not exist.")));
        this.execute();
    }

    @Test
    public void nonExistingReportDirectoryRaisesException() throws CommandFailed, IncorrectUsage, IOException {
        this.fileSystemAbstraction.deleteRecursively(this.reportDirectory.toFile());
        this.fileSystemAbstraction.create(this.reportDirectory.toFile()).close();
        this.expected.expect(CommandFailed.class);
        this.expected.expectMessage(StringContainsInOrder.stringContainsInOrder(Arrays.asList("Directory '", "reportDirectory' does not exist.")));
        this.execute();
    }

    @Test
    public void shouldPrintNiceHelp() throws Throwable {
        Usage usage = new Usage("neo4j-admin", (CommandLocator)Mockito.mock(CommandLocator.class));
        usage.printUsageForCommand((AdminCommand.Provider)new OnlineBackupCommandProvider(), this.stdout::println);
        Assert.assertEquals((Object)String.format("usage: neo4j-admin backup --backup-dir=<backup-path> --name=<graph.db-backup>%n                          [--from=<address>] [--protocol=<any|catchup|common>]%n                          [--fallback-to-full[=<true|false>]]%n                          [--timeout=<timeout>] [--pagecache=<8m>]%n                          [--check-consistency[=<true|false>]]%n                          [--cc-report-dir=<directory>]%n                          [--additional-config=<config-file-path>]%n                          [--cc-graph[=<true|false>]]%n                          [--cc-indexes[=<true|false>]]%n                          [--cc-label-scan-store[=<true|false>]]%n                          [--cc-property-owners[=<true|false>]]%n%nenvironment variables:%n    NEO4J_CONF    Path to directory which contains neo4j.conf.%n    NEO4J_DEBUG   Set to anything to enable debug output.%n    NEO4J_HOME    Neo4j home directory.%n    HEAP_SIZE     Set JVM maximum heap size during command execution.%n                  Takes a number and a unit, for example 512m.%n%nPerform an online backup from a running Neo4j enterprise server. Neo4j's backup%nservice must have been configured on the server beforehand.%n%nAll consistency checks except 'cc-graph' can be quite expensive so it may be%nuseful to turn them off for very large databases. Increasing the heap size can%nalso be a good idea. See 'neo4j-admin help' for details.%n%nFor more information see:%nhttps://neo4j.com/docs/operations-manual/current/backup/%n%noptions:%n  --backup-dir=<backup-path>               Directory to place backup in.%n  --name=<graph.db-backup>                 Name of backup. If a backup with this%n                                           name already exists an incremental%n                                           backup will be attempted.%n  --from=<address>                         Host and port of Neo4j.%n                                           [default:localhost:6362]%n  --protocol=<any|catchup|common>          Preferred backup protocol%n                                           [default:any]%n  --fallback-to-full=<true|false>          If an incremental backup fails backup%n                                           will move the old backup to%n                                           <name>.err.<N> and fallback to a full%n                                           backup instead. [default:true]%n  --timeout=<timeout>                      Timeout in the form <time>[ms|s|m|h],%n                                           where the default unit is seconds.%n                                           [default:20m]%n  --pagecache=<8m>                         The size of the page cache to use for%n                                           the backup process. [default:8m]%n  --check-consistency=<true|false>         If a consistency check should be%n                                           made. [default:true]%n  --cc-report-dir=<directory>              Directory where consistency report%n                                           will be written. [default:.]%n  --additional-config=<config-file-path>   Configuration file to supply%n                                           additional configuration in. This%n                                           argument is DEPRECATED. [default:]%n  --cc-graph=<true|false>                  Perform consistency checks between%n                                           nodes, relationships, properties,%n                                           types and tokens. [default:true]%n  --cc-indexes=<true|false>                Perform consistency checks on%n                                           indexes. [default:true]%n  --cc-label-scan-store=<true|false>       Perform consistency checks on the%n                                           label scan store. [default:true]%n  --cc-property-owners=<true|false>        Perform additional consistency checks%n                                           on property ownership. This check is%n                                           *very* expensive in time and memory.%n                                           [default:false]%n", new Object[0]), (Object)this.baosOut.toString());
    }

    @Test
    public void protocolOverrideWarnsUser() throws CommandFailed, IncorrectUsage {
        List<Object[]> cases = Arrays.asList({SelectedBackupProtocol.CATCHUP, String.format("The selected protocol `catchup` means that it is only compatible with causal clustering instances%n", new Object[0])}, {SelectedBackupProtocol.COMMON, String.format("The selected protocol `common` means that it is only compatible with HA and single instances%n", new Object[0])});
        for (Object[] thisCase : cases) {
            this.requiredArguments = new OnlineBackupRequiredArguments(this.address, this.backupDirectory, "backup name", (SelectedBackupProtocol)thisCase[0], true, true, 1000L, this.reportDirectory);
            OnlineBackupContext onlineBackupContext = new OnlineBackupContext(this.requiredArguments, this.config, this.consistencyFlags);
            this.subject = OnlineBackupCommandTest.newOnlineBackupCommand(this.outsideWorld, onlineBackupContext, this.backupSupportingClassesFactory, this.backupStrategyCoordinatorFactory);
            this.execute();
            Assert.assertThat((Object)this.baosOut.toString(), (Matcher)StringContains.containsString((String)((String)thisCase[1])));
            this.baosOut.reset();
        }
    }

    private static OnlineBackupCommand newOnlineBackupCommand(OutsideWorld outsideWorld, OnlineBackupContext onlineBackupContext, BackupSupportingClassesFactory backupSupportingClassesFactory, BackupStrategyCoordinatorFactory backupStrategyCoordinatorFactory) {
        OnlineBackupContextFactory contextBuilder = (OnlineBackupContextFactory)Mockito.mock(OnlineBackupContextFactory.class);
        try {
            Mockito.when((Object)contextBuilder.createContext((String[])ArgumentMatchers.any())).thenReturn((Object)onlineBackupContext);
        }
        catch (CommandFailed | IncorrectUsage e) {
            throw new RuntimeException("Shouldn't happen", e);
        }
        return new OnlineBackupCommand(outsideWorld, contextBuilder, backupSupportingClassesFactory, backupStrategyCoordinatorFactory);
    }

    private void execute() throws IncorrectUsage, CommandFailed {
        String[] implementationDoesNotUseArguments = new String[]{};
        this.subject.execute(implementationDoesNotUseArguments);
    }
}

