/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.backup.impl;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.PrintStream;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import java.util.stream.LongStream;
import org.apache.commons.lang3.SystemUtils;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.neo4j.backup.impl.BackupTransactionLogFilesHelper;
import org.neo4j.backup.impl.OnlineBackupCommandBuilder;
import org.neo4j.backup.impl.OnlineBackupCommandCcIT;
import org.neo4j.graphdb.DatabaseShutdownException;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.config.Setting;
import org.neo4j.graphdb.factory.GraphDatabaseBuilder;
import org.neo4j.graphdb.factory.GraphDatabaseFactory;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.io.ByteUnit;
import org.neo4j.io.fs.DefaultFileSystemAbstraction;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.enterprise.configuration.OnlineBackupSettings;
import org.neo4j.kernel.impl.transaction.log.files.LogFiles;
import org.neo4j.kernel.impl.transaction.log.files.LogFilesBuilder;
import org.neo4j.ports.allocation.PortAuthority;
import org.neo4j.test.DbRepresentation;
import org.neo4j.test.rule.EmbeddedDatabaseRule;
import org.neo4j.test.rule.SuppressOutput;
import org.neo4j.test.rule.TestDirectory;
import org.neo4j.util.TestHelpers;

@RunWith(value=Parameterized.class)
public class OnlineBackupCommandHaIT {
    private final TestDirectory testDirectory = TestDirectory.testDirectory();
    private final SuppressOutput suppressOutput = SuppressOutput.suppressAll();
    private final EmbeddedDatabaseRule db = new EmbeddedDatabaseRule().startLazily();
    @Rule
    public final RuleChain ruleChain = RuleChain.outerRule((TestRule)this.suppressOutput).around((TestRule)this.testDirectory).around((TestRule)this.db);
    private File backupDir;
    @Parameterized.Parameter
    public String recordFormat;
    private List<Runnable> oneOffShutdownTasks;
    private static final Label label = Label.label((String)"any_label");
    private static final String PROP_NAME = "name";
    private static final String PROP_RANDOM = "random";

    @Parameterized.Parameters(name="{0}")
    public static List<String> recordFormats() {
        return Arrays.asList("standard", "high_limit");
    }

    @Before
    public void resetTasks() {
        this.backupDir = this.testDirectory.directory("backups");
        this.oneOffShutdownTasks = new ArrayList<Runnable>();
    }

    @After
    public void shutdownTasks() {
        this.oneOffShutdownTasks.forEach(Runnable::run);
    }

    @Test
    public void makeSureBackupCanBePerformedWithCustomPort() throws Exception {
        Assume.assumeFalse((boolean)SystemUtils.IS_OS_WINDOWS);
        String backupName = "customport" + this.recordFormat;
        int backupPort = PortAuthority.allocatePort();
        this.startDb(backupPort);
        Assert.assertEquals((String)"should not be able to do backup when noone is listening", (long)1L, (long)OnlineBackupCommandHaIT.runBackupTool(this.testDirectory.absolutePath(), "--from", "127.0.0.1:" + PortAuthority.allocatePort(), "--cc-report-dir=" + this.backupDir, "--backup-dir=" + this.backupDir, "--name=" + backupName));
        Assert.assertEquals((long)0L, (long)OnlineBackupCommandHaIT.runBackupTool(this.testDirectory.absolutePath(), "--from", "127.0.0.1:" + backupPort, "--cc-report-dir=" + this.backupDir, "--backup-dir=" + this.backupDir, "--name=" + backupName));
        Assert.assertEquals((Object)DbRepresentation.of((GraphDatabaseService)this.db), (Object)this.getBackupDbRepresentation(backupName));
        OnlineBackupCommandHaIT.createSomeData((GraphDatabaseService)this.db);
        Assert.assertEquals((long)0L, (long)OnlineBackupCommandHaIT.runBackupTool(this.testDirectory.absolutePath(), "--from", "127.0.0.1:" + backupPort, "--cc-report-dir=" + this.backupDir, "--backup-dir=" + this.backupDir, "--name=" + backupName));
        Assert.assertEquals((Object)DbRepresentation.of((GraphDatabaseService)this.db), (Object)this.getBackupDbRepresentation(backupName));
    }

    @Test
    public void dataIsInAUsableStateAfterBackup() throws Exception {
        int backupPort = PortAuthority.allocatePort();
        this.startDb(backupPort);
        OnlineBackupCommandHaIT.createIndexes((GraphDatabaseService)this.db);
        AtomicBoolean continueFlagReference = new AtomicBoolean(true);
        new Thread(() -> OnlineBackupCommandHaIT.repeatedlyPopulateDatabase((GraphDatabaseService)this.db, continueFlagReference)).start();
        this.oneOffShutdownTasks.add(() -> continueFlagReference.set(false));
        String ip = ":" + backupPort;
        String backupName = "usableState" + this.recordFormat;
        Assert.assertEquals((long)0L, (long)OnlineBackupCommandHaIT.runBackupTool(this.testDirectory.absolutePath(), "--from", ip, "--cc-report-dir=" + this.backupDir, "--backup-dir=" + this.backupDir, "--name=" + backupName));
        this.db.shutdown();
    }

    @Test
    public void backupDatabaseTransactionLogsStoredWithDatabase() throws Exception {
        int backupPort = PortAuthority.allocatePort();
        this.startDb(backupPort);
        String ip = ":" + backupPort;
        String name = "backupWithTxLogs" + this.recordFormat;
        Assert.assertEquals((long)0L, (long)OnlineBackupCommandHaIT.runBackupTool(this.testDirectory.absolutePath(), "--from", ip, "--cc-report-dir=" + this.backupDir, "--backup-dir=" + this.backupDir, "--name=" + name));
        this.db.shutdown();
        try (DefaultFileSystemAbstraction fileSystem = new DefaultFileSystemAbstraction();){
            LogFiles logFiles = LogFilesBuilder.logFilesBasedOnlyBuilder((File)new File(this.backupDir, name), (FileSystemAbstraction)fileSystem).build();
            Assert.assertTrue((boolean)logFiles.versionExists(0L));
            Assert.assertThat((Object)logFiles.getLogFileForVersion(0L).length(), (Matcher)Matchers.greaterThan((Comparable)Long.valueOf(50L)));
        }
    }

    @Test
    public void backupFailsWithCatchupProtoOverride() throws Exception {
        String backupName = "portOverride" + this.recordFormat;
        int backupPort = PortAuthority.allocatePort();
        this.startDb(backupPort);
        Assert.assertEquals((long)1L, (long)OnlineBackupCommandHaIT.runBackupTool(this.testDirectory.absolutePath(), "--from", "127.0.0.1:" + backupPort, "--cc-report-dir=" + this.backupDir, "--backup-dir=" + this.backupDir, "--protocol=catchup", "--name=" + backupName));
    }

    @Test
    public void backupDoesNotDisplayExceptionWhenSuccessful() throws Exception {
        String backupName = "noErrorTest_" + this.recordFormat;
        int backupPort = PortAuthority.allocatePort();
        this.startDb(backupPort);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        PrintStream outputStream = OnlineBackupCommandCcIT.wrapWithNormalOutput(System.out, new PrintStream(byteArrayOutputStream));
        ByteArrayOutputStream byteArrayErrorStream = new ByteArrayOutputStream();
        PrintStream errorStream = OnlineBackupCommandCcIT.wrapWithNormalOutput(System.err, new PrintStream(byteArrayErrorStream));
        Assert.assertEquals((long)0L, (long)OnlineBackupCommandHaIT.runBackupTool(this.testDirectory.absolutePath(), outputStream, errorStream, "--from", "127.0.0.1:" + backupPort, "--cc-report-dir=" + this.backupDir, "--backup-dir=" + this.backupDir, "--name=" + backupName));
        Assert.assertFalse((boolean)byteArrayErrorStream.toString().toLowerCase().contains("exception"));
        Assert.assertFalse((boolean)byteArrayOutputStream.toString().toLowerCase().contains("exception"));
    }

    @Test
    public void reportsProgress() throws Exception {
        String backupName = "reportsProgress_" + this.recordFormat;
        int backupPort = PortAuthority.allocatePort();
        this.startDb(backupPort);
        Assert.assertEquals((long)0L, (long)OnlineBackupCommandHaIT.runBackupTool(this.backupDir, System.out, System.err, "--from", "127.0.0.1:" + backupPort, "--protocol=common", "--cc-report-dir=" + this.backupDir, "--backup-dir=" + this.backupDir, "--name=" + backupName));
        String output = this.suppressOutput.getOutputVoice().toString();
        String legacyImplementationDetail = "temp-copy";
        String location = Paths.get(this.backupDir.toString(), backupName, legacyImplementationDetail, "graph.db").toString();
        Assert.assertTrue((boolean)output.contains("Start receiving store files"));
        Assert.assertTrue((boolean)output.contains("Finish receiving store files"));
        String tested = Paths.get(location, "neostore.nodestore.db.labels").toString();
        Assert.assertTrue((String)tested, (boolean)output.contains(String.format("Start receiving store file %s", tested)));
        Assert.assertTrue((String)tested, (boolean)output.contains(String.format("Finish receiving store file %s", tested)));
        Assert.assertFalse((boolean)output.contains("Start receiving transactions from "));
        Assert.assertFalse((boolean)output.contains("Finish receiving transactions at "));
        Assert.assertTrue((boolean)output.contains("Start recovering store"));
        Assert.assertTrue((boolean)output.contains("Finish recovering store"));
        Assert.assertFalse((boolean)output.contains("Start receiving index snapshots"));
        Assert.assertFalse((boolean)output.contains("Start receiving index snapshot id 1"));
        Assert.assertFalse((boolean)output.contains("Finished receiving index snapshot id 1"));
        Assert.assertFalse((boolean)output.contains("Finished receiving index snapshots"));
    }

    @Test
    public void backupRenamesWork() {
        String backupName = "preexistingBackup_" + this.recordFormat;
        int firstBackupPort = PortAuthority.allocatePort();
        this.startDb(firstBackupPort);
        OnlineBackupCommandHaIT.createSpecificNodePair((GraphDatabaseService)this.db, "first");
        Assert.assertEquals((long)0L, (long)OnlineBackupCommandHaIT.runSameJvm(this.backupDir, backupName, "--from", "127.0.0.1:" + firstBackupPort, "--cc-report-dir=" + this.backupDir, "--protocol=common", "--backup-dir=" + this.backupDir, "--name=" + backupName));
        DbRepresentation firstDatabaseRepresentation = DbRepresentation.of((GraphDatabaseService)this.db);
        int secondBackupPort = PortAuthority.allocatePort();
        GraphDatabaseService db2 = this.createDb2(secondBackupPort);
        OnlineBackupCommandHaIT.createSpecificNodePair(db2, "second");
        DbRepresentation secondDatabaseRepresentation = DbRepresentation.of((GraphDatabaseService)db2);
        Assert.assertEquals((long)0L, (long)OnlineBackupCommandHaIT.runSameJvm(this.backupDir, backupName, "--from", "127.0.0.1:" + secondBackupPort, "--cc-report-dir=" + this.backupDir, "--backup-dir=" + this.backupDir, "--protocol=common", "--name=" + backupName));
        Assert.assertEquals((Object)secondDatabaseRepresentation, (Object)this.getBackupDbRepresentation(backupName));
        Assert.assertEquals((Object)firstDatabaseRepresentation, (Object)this.getBackupDbRepresentation(backupName + ".err.0"));
        Assert.assertNotEquals((Object)firstDatabaseRepresentation, (Object)secondDatabaseRepresentation);
        db2.shutdown();
    }

    @Test
    public void onlyTheLatestTransactionIsKeptAfterIncrementalBackup() throws Exception {
        int port = PortAuthority.allocatePort();
        this.startDb(port);
        OnlineBackupCommandHaIT.createSomeData((GraphDatabaseService)this.db);
        Config config = Config.builder().withSetting(GraphDatabaseSettings.logical_log_rotation_threshold, "1m").build();
        File configOverrideFile = this.testDirectory.file("neo4j-backup.conf");
        OnlineBackupCommandBuilder.writeConfigToFile((Config)config, (File)configOverrideFile);
        String backupName = "backupName" + this.recordFormat;
        String address = "localhost:" + port;
        Assert.assertEquals((long)0L, (long)TestHelpers.runBackupToolFromOtherJvmToGetExitCode((File)this.backupDir, (String[])new String[]{"--from", address, "--cc-report-dir=" + this.backupDir, "--backup-dir=" + this.backupDir, "--protocol=common", "--additional-config=" + configOverrideFile, "--name=" + backupName}));
        OnlineBackupCommandHaIT.transactions1M((GraphDatabaseService)this.db);
        OnlineBackupCommandHaIT.transactions1M((GraphDatabaseService)this.db);
        Assert.assertEquals((long)0L, (long)TestHelpers.runBackupToolFromOtherJvmToGetExitCode((File)this.backupDir, (String[])new String[]{"--from", address, "--cc-report-dir=" + this.backupDir, "--backup-dir=" + this.backupDir, "--protocol=common", "--additional-config=" + configOverrideFile, "--name=" + backupName}));
        BackupTransactionLogFilesHelper backupTransactionLogFilesHelper = new BackupTransactionLogFilesHelper();
        LogFiles logFiles = backupTransactionLogFilesHelper.readLogFiles(this.backupDir.toPath().resolve(backupName).toFile());
        long highestTxIdInLogFiles = logFiles.getHighestLogVersion();
        Assert.assertEquals((long)2L, (long)highestTxIdInLogFiles);
        long lowestTxIdInLogFiles = logFiles.getLowestLogVersion();
        Assert.assertEquals((long)0L, (long)lowestTxIdInLogFiles);
    }

    private static void transactions1M(GraphDatabaseService db) {
        int numberOfTransactions = 500;
        long sizeOfTransaction = ByteUnit.mebiBytes((long)1L) / (long)numberOfTransactions + 1L;
        for (int txId = 0; txId < numberOfTransactions; ++txId) {
            try (Transaction tx = db.beginTx();){
                Node node = db.createNode();
                String longString = LongStream.range(0L, sizeOfTransaction).map(l -> l % 10L).mapToObj(Long::toString).collect(Collectors.joining(""));
                node.setProperty(PROP_NAME, (Object)longString);
                db.createNode().createRelationshipTo(node, RelationshipType.withName((String)"KNOWS"));
                tx.success();
                continue;
            }
        }
    }

    private static void createSomeData(GraphDatabaseService db) {
        try (Transaction tx = db.beginTx();){
            Node node = db.createNode();
            node.setProperty(PROP_NAME, (Object)"Neo");
            db.createNode().createRelationshipTo(node, RelationshipType.withName((String)"KNOWS"));
            tx.success();
        }
    }

    private static void createSpecificNodePair(GraphDatabaseService db, String name) {
        try (Transaction tx = db.beginTx();){
            Node left = db.createNode();
            left.setProperty(PROP_NAME, (Object)(name + "Left"));
            Node right = db.createNode();
            right.setProperty(PROP_NAME, (Object)(name + "Right"));
            right.createRelationshipTo(left, RelationshipType.withName((String)"KNOWS"));
            tx.success();
        }
    }

    private static void repeatedlyPopulateDatabase(GraphDatabaseService db, AtomicBoolean continueFlagReference) {
        while (continueFlagReference.get()) {
            try {
                OnlineBackupCommandHaIT.createSomeData(db);
            }
            catch (DatabaseShutdownException ex) {
                break;
            }
        }
    }

    private static void createIndexes(GraphDatabaseService db) {
        try (Transaction tx = db.beginTx();){
            db.schema().indexFor(label).on(PROP_NAME).on(PROP_RANDOM).create();
            tx.success();
        }
    }

    private GraphDatabaseService createDb2(Integer backupPort) {
        File storeDir = this.testDirectory.directory("graph-db-2");
        GraphDatabaseFactory factory = new GraphDatabaseFactory();
        GraphDatabaseBuilder builder = factory.newEmbeddedDatabaseBuilder(storeDir);
        builder.setConfig(OnlineBackupSettings.online_backup_server, "0.0.0.0:" + backupPort);
        return builder.newGraphDatabase();
    }

    private void startDb(Integer backupPort) {
        this.startDb(this.db, backupPort);
    }

    private void startDb(EmbeddedDatabaseRule db, Integer backupPort) {
        db.setConfig(GraphDatabaseSettings.record_format, this.recordFormat);
        db.setConfig(OnlineBackupSettings.online_backup_enabled, "true");
        db.setConfig(OnlineBackupSettings.online_backup_server, "127.0.0.1:" + backupPort);
        db.ensureStarted(new String[0]);
        OnlineBackupCommandHaIT.createSomeData((GraphDatabaseService)db);
    }

    private static int runBackupTool(File neo4jHome, PrintStream outputStream, PrintStream errorStream, String ... args) throws Exception {
        return TestHelpers.runBackupToolFromOtherJvmToGetExitCode((File)neo4jHome, (PrintStream)outputStream, (PrintStream)errorStream, (boolean)false, (String[])args);
    }

    private static int runBackupTool(File neo4jHome, String ... args) throws Exception {
        return TestHelpers.runBackupToolFromOtherJvmToGetExitCode((File)neo4jHome, (String[])args);
    }

    private static int runSameJvm(File home, String name, String ... args) {
        try {
            new OnlineBackupCommandBuilder().withRawArgs(args).backup(home, name);
            return 0;
        }
        catch (Exception e) {
            e.printStackTrace();
            return 1;
        }
    }

    private DbRepresentation getBackupDbRepresentation(String name) {
        Config config = Config.defaults((Setting)OnlineBackupSettings.online_backup_enabled, (String)"false");
        config.augment(GraphDatabaseSettings.active_database, name);
        return DbRepresentation.of((File)this.backupDir, (Config)config);
    }
}

