/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.backup.impl;

import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.neo4j.backup.impl.AddressResolver;
import org.neo4j.backup.impl.BackupDelegator;
import org.neo4j.backup.impl.BackupStageOutcome;
import org.neo4j.backup.impl.CausalClusteringBackupStrategy;
import org.neo4j.backup.impl.Fallible;
import org.neo4j.causalclustering.catchup.CatchupResult;
import org.neo4j.causalclustering.catchup.storecopy.StoreCopyFailedException;
import org.neo4j.causalclustering.catchup.storecopy.StoreFiles;
import org.neo4j.causalclustering.catchup.storecopy.StoreIdDownloadFailedException;
import org.neo4j.causalclustering.identity.StoreId;
import org.neo4j.helpers.AdvertisedSocketAddress;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.util.OptionalHostnamePort;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.NullLogProvider;

public class CausalClusteringBackupStrategyTest {
    @Rule
    public ExpectedException expected = ExpectedException.none();
    BackupDelegator backupDelegator = (BackupDelegator)Mockito.mock(BackupDelegator.class);
    AddressResolver addressResolver = (AddressResolver)Mockito.mock(AddressResolver.class);
    AdvertisedSocketAddress resolvedFromAddress = new AdvertisedSocketAddress("resolved-host", 1358);
    CausalClusteringBackupStrategy subject;
    Path desiredBackupLocation = (Path)Mockito.mock(Path.class);
    Config config = (Config)Mockito.mock(Config.class);
    OptionalHostnamePort userProvidedAddress = new OptionalHostnamePort((String)null, null, null);
    StoreFiles storeFiles = (StoreFiles)Mockito.mock(StoreFiles.class);
    StoreId expectedStoreId = new StoreId(11L, 22L, 33L, 44L);

    @Before
    public void setup() throws IOException, StoreIdDownloadFailedException {
        Mockito.when((Object)this.addressResolver.resolveCorrectCCAddress((Config)ArgumentMatchers.any(), (OptionalHostnamePort)ArgumentMatchers.any())).thenReturn((Object)this.resolvedFromAddress);
        Mockito.when((Object)this.storeFiles.readStoreId((File)ArgumentMatchers.any())).thenReturn((Object)this.expectedStoreId);
        Mockito.when((Object)this.backupDelegator.fetchStoreId((AdvertisedSocketAddress)ArgumentMatchers.any())).thenReturn((Object)this.expectedStoreId);
        this.subject = new CausalClusteringBackupStrategy(this.backupDelegator, this.addressResolver, (LogProvider)NullLogProvider.getInstance(), this.storeFiles);
    }

    @Test
    public void incrementalBackupsUseCorrectResolvedAddress() throws StoreCopyFailedException {
        AdvertisedSocketAddress expectedAddress = new AdvertisedSocketAddress("expected-host", 1298);
        Mockito.when((Object)this.addressResolver.resolveCorrectCCAddress((Config)ArgumentMatchers.any(), (OptionalHostnamePort)ArgumentMatchers.any())).thenReturn((Object)expectedAddress);
        this.subject.performIncrementalBackup(this.desiredBackupLocation, this.config, this.userProvidedAddress);
        ((BackupDelegator)Mockito.verify((Object)this.backupDelegator)).tryCatchingUp((AdvertisedSocketAddress)ArgumentMatchers.eq((Object)expectedAddress), (StoreId)ArgumentMatchers.any(), (Path)ArgumentMatchers.any());
    }

    @Test
    public void fullBackupUsesCorrectResolvedAddress() throws StoreIdDownloadFailedException {
        AdvertisedSocketAddress expectedAddress = new AdvertisedSocketAddress("expected-host", 1578);
        Mockito.when((Object)this.addressResolver.resolveCorrectCCAddress((Config)ArgumentMatchers.any(), (OptionalHostnamePort)ArgumentMatchers.any())).thenReturn((Object)expectedAddress);
        this.subject.performFullBackup(this.desiredBackupLocation, this.config, this.userProvidedAddress);
        ((BackupDelegator)Mockito.verify((Object)this.backupDelegator)).fetchStoreId(expectedAddress);
    }

    @Test
    public void incrementalRunsCatchupWithTargetsStoreId() throws StoreIdDownloadFailedException, StoreCopyFailedException {
        this.subject.performIncrementalBackup(this.desiredBackupLocation, this.config, this.userProvidedAddress);
        ((BackupDelegator)Mockito.verify((Object)this.backupDelegator)).fetchStoreId(this.resolvedFromAddress);
        ((BackupDelegator)Mockito.verify((Object)this.backupDelegator)).tryCatchingUp((AdvertisedSocketAddress)ArgumentMatchers.eq((Object)this.resolvedFromAddress), (StoreId)ArgumentMatchers.eq((Object)this.expectedStoreId), (Path)ArgumentMatchers.any());
    }

    @Test
    public void fullRunsRetrieveStoreWithTargetsStoreId() throws StoreIdDownloadFailedException, StoreCopyFailedException, IOException {
        Mockito.when((Object)this.storeFiles.readStoreId((File)ArgumentMatchers.any())).thenThrow(IOException.class);
        this.subject.performFullBackup(this.desiredBackupLocation, this.config, this.userProvidedAddress);
        ((BackupDelegator)Mockito.verify((Object)this.backupDelegator)).fetchStoreId(this.resolvedFromAddress);
        ((BackupDelegator)Mockito.verify((Object)this.backupDelegator)).copy(this.resolvedFromAddress, this.expectedStoreId, this.desiredBackupLocation);
    }

    @Test
    public void failingToRetrieveStoreIdCausesFailWithStatus_incrementalBackup() throws StoreIdDownloadFailedException {
        StoreIdDownloadFailedException storeIdDownloadFailedException = new StoreIdDownloadFailedException("Expected description");
        Mockito.when((Object)this.backupDelegator.fetchStoreId((AdvertisedSocketAddress)ArgumentMatchers.any())).thenThrow(new Throwable[]{storeIdDownloadFailedException});
        Fallible state = this.subject.performIncrementalBackup(this.desiredBackupLocation, this.config, this.userProvidedAddress);
        Assert.assertEquals((Object)BackupStageOutcome.WRONG_PROTOCOL, (Object)state.getState());
        Assert.assertEquals((Object)storeIdDownloadFailedException, state.getCause().get());
    }

    @Test
    public void failingToCopyStoresCausesFailWithStatus_incrementalBackup() throws StoreIdDownloadFailedException, StoreCopyFailedException {
        Mockito.when((Object)this.backupDelegator.tryCatchingUp((AdvertisedSocketAddress)ArgumentMatchers.any(), (StoreId)ArgumentMatchers.eq((Object)this.expectedStoreId), (Path)ArgumentMatchers.any())).thenThrow(StoreCopyFailedException.class);
        Fallible state = this.subject.performIncrementalBackup(this.desiredBackupLocation, this.config, this.userProvidedAddress);
        Assert.assertEquals((Object)BackupStageOutcome.FAILURE, (Object)state.getState());
        Assert.assertEquals(StoreCopyFailedException.class, state.getCause().get().getClass());
    }

    @Test
    public void failingToRetrieveStoreIdCausesFailWithStatus_fullBackup() throws StoreIdDownloadFailedException {
        StoreIdDownloadFailedException storeIdDownloadFailedException = new StoreIdDownloadFailedException("Expected description");
        Mockito.when((Object)this.backupDelegator.fetchStoreId((AdvertisedSocketAddress)ArgumentMatchers.any())).thenThrow(new Throwable[]{storeIdDownloadFailedException});
        Fallible state = this.subject.performFullBackup(this.desiredBackupLocation, this.config, this.userProvidedAddress);
        Assert.assertEquals((Object)BackupStageOutcome.WRONG_PROTOCOL, (Object)state.getState());
        Assert.assertEquals((Object)storeIdDownloadFailedException, state.getCause().get());
    }

    @Test
    public void failingToCopyStoresCausesFailWithStatus_fullBackup() throws StoreCopyFailedException, IOException {
        ((BackupDelegator)Mockito.doThrow(StoreCopyFailedException.class).when((Object)this.backupDelegator)).copy((AdvertisedSocketAddress)ArgumentMatchers.any(), (StoreId)ArgumentMatchers.any(), (Path)ArgumentMatchers.any());
        Mockito.when((Object)this.storeFiles.readStoreId((File)ArgumentMatchers.any())).thenThrow(IOException.class);
        Fallible state = this.subject.performFullBackup(this.desiredBackupLocation, this.config, this.userProvidedAddress);
        Assert.assertEquals((Object)BackupStageOutcome.FAILURE, (Object)state.getState());
        System.out.println(state.getCause());
        Assert.assertEquals(StoreCopyFailedException.class, state.getCause().get().getClass());
    }

    @Test
    public void incrementalBackupsEndingInUnacceptedCatchupStateCauseFailures() throws StoreCopyFailedException {
        Mockito.when((Object)this.backupDelegator.tryCatchingUp((AdvertisedSocketAddress)ArgumentMatchers.any(), (StoreId)ArgumentMatchers.any(), (Path)ArgumentMatchers.any())).thenReturn((Object)CatchupResult.E_STORE_UNAVAILABLE);
        Fallible state = this.subject.performIncrementalBackup(this.desiredBackupLocation, this.config, this.userProvidedAddress);
        Assert.assertEquals((Object)BackupStageOutcome.FAILURE, (Object)state.getState());
        Assert.assertEquals(StoreCopyFailedException.class, ((Throwable)state.getCause().get()).getClass());
        Assert.assertEquals((Object)"End state of catchup was not a successful end of stream", (Object)((Throwable)state.getCause().get()).getMessage());
    }

    @Test
    public void lifecycleDelegatesToNecessaryServices() throws Throwable {
        this.subject.start();
        ((BackupDelegator)Mockito.verify((Object)this.backupDelegator)).start();
        ((BackupDelegator)Mockito.verify((Object)this.backupDelegator, (VerificationMode)Mockito.never())).stop();
        this.subject.stop();
        ((BackupDelegator)Mockito.verify((Object)this.backupDelegator)).start();
        ((BackupDelegator)Mockito.verify((Object)this.backupDelegator)).stop();
    }

    @Test
    public void exceptionWhenStoreMismatchNoExistingBackup() throws IOException {
        Mockito.when((Object)this.storeFiles.readStoreId((File)ArgumentMatchers.any())).thenThrow(IOException.class);
        Fallible state = this.subject.performIncrementalBackup(this.desiredBackupLocation, this.config, this.userProvidedAddress);
        Assert.assertEquals(StoreIdDownloadFailedException.class, ((Throwable)state.getCause().get()).getClass());
        Assert.assertEquals((Object)BackupStageOutcome.FAILURE, (Object)state.getState());
    }

    @Test
    public void exceptionWhenStoreMismatch() throws IOException {
        Mockito.when((Object)this.storeFiles.readStoreId((File)ArgumentMatchers.any())).thenReturn((Object)new StoreId(5L, 4L, 3L, 2L));
        Fallible state = this.subject.performIncrementalBackup(this.desiredBackupLocation, this.config, this.userProvidedAddress);
        Assert.assertEquals(StoreIdDownloadFailedException.class, ((Throwable)state.getCause().get()).getClass());
        Assert.assertEquals((Object)BackupStageOutcome.FAILURE, (Object)state.getState());
    }

    @Test
    public void fullBackupFailsWhenTargetHasStoreId() throws IOException {
        Mockito.when((Object)this.storeFiles.readStoreId((File)ArgumentMatchers.any())).thenReturn((Object)this.expectedStoreId);
        Fallible state = this.subject.performFullBackup(this.desiredBackupLocation, this.config, this.userProvidedAddress);
        Assert.assertEquals(StoreIdDownloadFailedException.class, ((Throwable)state.getCause().get()).getClass());
        Assert.assertEquals((Object)BackupStageOutcome.FAILURE, (Object)state.getState());
    }
}

