/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.backup.impl;

import java.io.OutputStream;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.backup.impl.BackupOutputMonitor;
import org.neo4j.com.storecopy.StoreCopyClientMonitor;
import org.neo4j.commandline.admin.OutsideWorld;
import org.neo4j.commandline.admin.ParameterisedOutsideWorld;
import org.neo4j.io.fs.DefaultFileSystemAbstraction;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.kernel.monitoring.Monitors;
import org.neo4j.test.rule.SuppressOutput;

public class BackupOutputMonitorTest {
    @Rule
    public final SuppressOutput suppressOutput = SuppressOutput.suppressAll();
    private final Monitors monitors = new Monitors();
    private OutsideWorld outsideWorld;

    @Before
    public void setup() {
        this.outsideWorld = new ParameterisedOutsideWorld(System.console(), (OutputStream)System.out, (OutputStream)System.err, System.in, (FileSystemAbstraction)new DefaultFileSystemAbstraction());
    }

    @Test
    public void receivingStoreFilesMessageCorrect() {
        this.monitors.addMonitorListener((Object)new BackupOutputMonitor(this.outsideWorld), new String[0]);
        StoreCopyClientMonitor storeCopyClientMonitor = (StoreCopyClientMonitor)this.monitors.newMonitor(StoreCopyClientMonitor.class, new String[0]);
        storeCopyClientMonitor.startReceivingStoreFiles();
        Assert.assertTrue((boolean)this.suppressOutput.getOutputVoice().toString().toString().contains("Start receiving store files"));
    }
}

