/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.backup;

import java.io.File;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;
import org.neo4j.backup.OnlineBackup;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.kernel.impl.enterprise.configuration.OnlineBackupSettings;
import org.neo4j.ports.allocation.PortAuthority;
import org.neo4j.test.TestGraphDatabaseFactory;
import org.neo4j.test.rule.SuppressOutput;
import org.neo4j.test.rule.TestDirectory;

public class TestConfiguration {
    public SuppressOutput suppressOutput = SuppressOutput.suppressAll();
    public TestDirectory dir = TestDirectory.testDirectory();
    @Rule
    public RuleChain rules = RuleChain.outerRule((TestRule)this.dir).around((TestRule)this.suppressOutput);
    private static final String HOST_ADDRESS = "127.0.0.1";
    private File storeDir;
    private String backupDir;

    @Before
    public void before() throws Exception {
        this.storeDir = this.dir.storeDir();
        this.backupDir = this.dir.cleanDirectory("full-backup").getAbsolutePath();
    }

    @Test
    public void testOnByDefault() {
        int port = PortAuthority.allocatePort();
        GraphDatabaseService db = new TestGraphDatabaseFactory().newEmbeddedDatabaseBuilder(this.storeDir).setConfig(OnlineBackupSettings.online_backup_server, "localhost:" + port).newGraphDatabase();
        OnlineBackup.from((String)HOST_ADDRESS, (int)port).full(this.backupDir);
        db.shutdown();
    }

    @Test
    public void testOffByConfig() {
        int port = PortAuthority.allocatePort();
        GraphDatabaseService db = new TestGraphDatabaseFactory().newEmbeddedDatabaseBuilder(this.storeDir).setConfig(OnlineBackupSettings.online_backup_enabled, "false").setConfig(OnlineBackupSettings.online_backup_server, "localhost:" + port).newGraphDatabase();
        try {
            OnlineBackup.from((String)HOST_ADDRESS, (int)port).full(this.backupDir);
            Assert.fail((String)"Shouldn't be possible");
        }
        catch (Exception exception) {
            // empty catch block
        }
        db.shutdown();
    }

    @Test
    public void testEnableDefaultsInConfig() {
        int port = PortAuthority.allocatePort();
        GraphDatabaseService db = new TestGraphDatabaseFactory().newEmbeddedDatabaseBuilder(this.storeDir).setConfig(OnlineBackupSettings.online_backup_enabled, "true").setConfig(OnlineBackupSettings.online_backup_server, "localhost:" + port).newGraphDatabase();
        OnlineBackup.from((String)HOST_ADDRESS, (int)port).full(this.backupDir);
        db.shutdown();
    }

    @Test
    public void testEnableCustomPortInConfig() {
        int customPort = PortAuthority.allocatePort();
        GraphDatabaseService db = new TestGraphDatabaseFactory().newEmbeddedDatabaseBuilder(this.storeDir).setConfig(OnlineBackupSettings.online_backup_enabled, "true").setConfig(OnlineBackupSettings.online_backup_server, ":" + customPort).newGraphDatabase();
        try {
            OnlineBackup.from((String)HOST_ADDRESS, (int)PortAuthority.allocatePort()).full(this.backupDir);
            Assert.fail((String)"Shouldn't be possible");
        }
        catch (Exception exception) {
            // empty catch block
        }
        OnlineBackup.from((String)HOST_ADDRESS, (int)customPort).full(this.backupDir);
        db.shutdown();
    }
}

