/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.backup;

import java.util.function.Supplier;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.Mockito;
import org.neo4j.backup.OnlineBackupExtensionFactory;
import org.neo4j.backup.OnlineBackupKernelExtension;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.kernel.NeoStoreDataSource;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.factory.DatabaseInfo;
import org.neo4j.kernel.impl.logging.LogService;
import org.neo4j.kernel.impl.logging.SimpleLogService;
import org.neo4j.kernel.impl.spi.KernelContext;
import org.neo4j.kernel.impl.spi.SimpleKernelContext;
import org.neo4j.kernel.impl.transaction.log.LogFileInformation;
import org.neo4j.kernel.impl.transaction.log.LogicalTransactionStore;
import org.neo4j.kernel.impl.transaction.log.TransactionIdStore;
import org.neo4j.kernel.impl.transaction.log.checkpoint.CheckPointer;
import org.neo4j.kernel.impl.transaction.log.checkpoint.StoreCopyCheckPointMutex;
import org.neo4j.kernel.impl.util.Dependencies;
import org.neo4j.kernel.impl.util.DependencySatisfier;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.kernel.lifecycle.Lifecycle;
import org.neo4j.kernel.monitoring.Monitors;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.NullLogProvider;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.TestDirectoryExtension;
import org.neo4j.test.rule.TestDirectory;

@ExtendWith(value={TestDirectoryExtension.class})
class OnlineBackupExtensionFactoryTest {
    @Inject
    private TestDirectory testDirectory;
    private OnlineBackupExtensionFactory extensionFactory = new OnlineBackupExtensionFactory();
    private Dependencies dependencies = new Dependencies();

    OnlineBackupExtensionFactoryTest() {
    }

    @Test
    void doNotCreateExtensionForNonDefaultDatabase() {
        SimpleKernelContext kernelContext = new SimpleKernelContext(this.testDirectory.databaseDir(), DatabaseInfo.ENTERPRISE, (DependencySatisfier)this.dependencies);
        Lifecycle instance = this.extensionFactory.newInstance((KernelContext)kernelContext, (OnlineBackupExtensionFactory.Dependencies)new TestBackDependencies("another"));
        MatcherAssert.assertThat((Object)instance, (Matcher)Matchers.not((Matcher)Matchers.instanceOf(OnlineBackupKernelExtension.class)));
    }

    @Test
    void createExtensionForDefaultDatabase() {
        SimpleKernelContext kernelContext = new SimpleKernelContext(this.testDirectory.databaseDir(), DatabaseInfo.ENTERPRISE, (DependencySatisfier)this.dependencies);
        Lifecycle instance = this.extensionFactory.newInstance((KernelContext)kernelContext, (OnlineBackupExtensionFactory.Dependencies)new TestBackDependencies("graph.db"));
        MatcherAssert.assertThat((Object)instance, (Matcher)Matchers.instanceOf(OnlineBackupKernelExtension.class));
    }

    private static class TestBackDependencies
    implements OnlineBackupExtensionFactory.Dependencies {
        private final String databaseName;

        TestBackDependencies(String databaseName) {
            this.databaseName = databaseName;
        }

        public Config getConfig() {
            return null;
        }

        public GraphDatabaseAPI getGraphDatabaseAPI() {
            return null;
        }

        public LogService logService() {
            return new SimpleLogService((LogProvider)NullLogProvider.getInstance());
        }

        public Monitors monitors() {
            return null;
        }

        public NeoStoreDataSource neoStoreDataSource() {
            NeoStoreDataSource neoStoreDataSource = (NeoStoreDataSource)Mockito.mock(NeoStoreDataSource.class);
            Mockito.when((Object)neoStoreDataSource.getDatabaseName()).thenReturn((Object)this.databaseName);
            return neoStoreDataSource;
        }

        public Supplier<CheckPointer> checkPointer() {
            return null;
        }

        public Supplier<TransactionIdStore> transactionIdStoreSupplier() {
            return null;
        }

        public Supplier<LogicalTransactionStore> logicalTransactionStoreSupplier() {
            return null;
        }

        public Supplier<LogFileInformation> logFileInformationSupplier() {
            return null;
        }

        public FileSystemAbstraction fileSystemAbstraction() {
            return null;
        }

        public PageCache pageCache() {
            return null;
        }

        public StoreCopyCheckPointMutex storeCopyCheckPointMutex() {
            return null;
        }
    }
}

