/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.backup;

import java.io.File;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestName;
import org.junit.rules.TestRule;
import org.neo4j.backup.EmbeddedServer;
import org.neo4j.backup.OnlineBackup;
import org.neo4j.backup.ServerInterface;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.config.Setting;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.enterprise.configuration.OnlineBackupSettings;
import org.neo4j.ports.allocation.PortAuthority;
import org.neo4j.test.DbRepresentation;
import org.neo4j.test.TestGraphDatabaseFactory;
import org.neo4j.test.rule.SuppressOutput;
import org.neo4j.test.rule.TestDirectory;

public class IncrementalBackupIT {
    private TestName testName = new TestName();
    public TestDirectory testDirectory = TestDirectory.testDirectory();
    public SuppressOutput suppressOutput = SuppressOutput.suppressAll();
    @Rule
    public RuleChain rules = RuleChain.outerRule((TestRule)this.testName).around((TestRule)this.testDirectory).around((TestRule)this.suppressOutput);
    private File serverPath;
    private File backupDatabase;
    private ServerInterface server;
    private GraphDatabaseService db;
    private File backupStore;

    @Before
    public void before() {
        this.serverPath = this.testDirectory.storeDir("server");
        this.backupStore = this.testDirectory.storeDir("backupStore");
        this.backupDatabase = this.testDirectory.databaseDir(this.backupStore);
    }

    @After
    public void shutItDown() throws Exception {
        if (this.server != null) {
            IncrementalBackupIT.shutdownServer(this.server);
            this.server = null;
        }
        if (this.db != null) {
            this.db.shutdown();
            this.db = null;
        }
    }

    @Test
    public void shouldDoIncrementalBackup() throws Exception {
        DbRepresentation initialDataSetRepresentation = this.createInitialDataSet(this.serverPath);
        int port = PortAuthority.allocatePort();
        this.server = IncrementalBackupIT.startServer(this.serverPath, "127.0.0.1:" + port);
        OnlineBackup backup = OnlineBackup.from((String)"127.0.0.1", (int)port);
        backup.full(this.backupDatabase.getPath());
        Assert.assertEquals((Object)initialDataSetRepresentation, (Object)this.getBackupDbRepresentation());
        IncrementalBackupIT.shutdownServer(this.server);
        DbRepresentation furtherRepresentation = this.addMoreData2(this.serverPath);
        this.server = IncrementalBackupIT.startServer(this.serverPath, "127.0.0.1:" + port);
        backup.incremental(this.backupDatabase.getPath());
        Assert.assertEquals((Object)furtherRepresentation, (Object)this.getBackupDbRepresentation());
        IncrementalBackupIT.shutdownServer(this.server);
    }

    @Test
    public void shouldNotServeTransactionsWithInvalidHighIds() throws Exception {
        DbRepresentation initialDataSetRepresentation = this.createInitialDataSet(this.serverPath);
        int port = PortAuthority.allocatePort();
        this.server = IncrementalBackupIT.startServer(this.serverPath, "127.0.0.1:" + port);
        OnlineBackup backup = OnlineBackup.from((String)"127.0.0.1", (int)port);
        backup.full(this.backupDatabase.getPath());
        Assert.assertEquals((Object)initialDataSetRepresentation, (Object)this.getBackupDbRepresentation());
        IncrementalBackupIT.shutdownServer(this.server);
        DbRepresentation furtherRepresentation = this.createTransactionWithWeirdRelationshipGroupRecord(this.serverPath);
        this.server = IncrementalBackupIT.startServer(this.serverPath, "127.0.0.1:" + port);
        backup.incremental(this.backupDatabase.getPath());
        Assert.assertEquals((Object)furtherRepresentation, (Object)this.getBackupDbRepresentation());
        IncrementalBackupIT.shutdownServer(this.server);
    }

    private DbRepresentation createInitialDataSet(File path) {
        this.db = IncrementalBackupIT.startGraphDatabase(path);
        try (Transaction tx = this.db.beginTx();){
            this.db.createNode().setProperty("name", (Object)"Goofy");
            Node donald = this.db.createNode();
            donald.setProperty("name", (Object)"Donald");
            Node daisy = this.db.createNode();
            daisy.setProperty("name", (Object)"Daisy");
            Relationship knows = donald.createRelationshipTo(daisy, RelationshipType.withName((String)"LOVES"));
            knows.setProperty("since", (Object)1940);
            tx.success();
        }
        DbRepresentation result = DbRepresentation.of((GraphDatabaseService)this.db);
        this.db.shutdown();
        return result;
    }

    private DbRepresentation addMoreData2(File path) {
        this.db = IncrementalBackupIT.startGraphDatabase(path);
        try (Transaction tx = this.db.beginTx();){
            Node donald = this.db.getNodeById(2L);
            Node gladstone = this.db.createNode();
            gladstone.setProperty("name", (Object)"Gladstone");
            Relationship hates = donald.createRelationshipTo(gladstone, RelationshipType.withName((String)"HATES"));
            hates.setProperty("since", (Object)1948);
            tx.success();
        }
        DbRepresentation result = DbRepresentation.of((GraphDatabaseService)this.db);
        this.db.shutdown();
        return result;
    }

    private DbRepresentation createTransactionWithWeirdRelationshipGroupRecord(File path) {
        Node node;
        this.db = IncrementalBackupIT.startGraphDatabase(path);
        RelationshipType typeToDelete = RelationshipType.withName((String)"A");
        RelationshipType theOtherType = RelationshipType.withName((String)"B");
        int defaultDenseNodeThreshold = Integer.parseInt(GraphDatabaseSettings.dense_node_threshold.getDefaultValue());
        try (Transaction tx = this.db.beginTx();){
            node = this.db.createNode();
            for (int i = 0; i < defaultDenseNodeThreshold - 1; ++i) {
                node.createRelationshipTo(this.db.createNode(), theOtherType);
            }
            node.createRelationshipTo(this.db.createNode(), typeToDelete);
            tx.success();
        }
        tx = this.db.beginTx();
        var8_7 = null;
        try {
            node.createRelationshipTo(this.db.createNode(), theOtherType);
            for (Relationship relationship : node.getRelationships(Direction.BOTH, new RelationshipType[]{typeToDelete})) {
                relationship.delete();
            }
            tx.success();
        }
        catch (Throwable throwable) {
            var8_7 = throwable;
            throw throwable;
        }
        finally {
            if (tx != null) {
                if (var8_7 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable) {
                        var8_7.addSuppressed(throwable);
                    }
                } else {
                    tx.close();
                }
            }
        }
        DbRepresentation result = DbRepresentation.of((GraphDatabaseService)this.db);
        this.db.shutdown();
        return result;
    }

    private static GraphDatabaseService startGraphDatabase(File storeDir) {
        return new TestGraphDatabaseFactory().newEmbeddedDatabaseBuilder(storeDir).setConfig(OnlineBackupSettings.online_backup_enabled, "false").setConfig(GraphDatabaseSettings.keep_logical_logs, "true").newGraphDatabase();
    }

    private static ServerInterface startServer(File storeDir, String serverAddress) {
        EmbeddedServer server = new EmbeddedServer(storeDir, serverAddress);
        server.awaitStarted();
        return server;
    }

    private static void shutdownServer(ServerInterface server) throws Exception {
        server.shutdown();
        Thread.sleep(1000L);
    }

    private DbRepresentation getBackupDbRepresentation() {
        return DbRepresentation.of((File)this.backupStore, (Config)Config.defaults((Setting)OnlineBackupSettings.online_backup_enabled, (String)"false"));
    }
}

