/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.backup;

import java.io.PrintStream;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.List;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.runners.Enclosed;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.neo4j.backup.BackupTool;
import org.neo4j.backup.impl.BackupClient;
import org.neo4j.backup.impl.BackupProtocolService;
import org.neo4j.backup.impl.ConsistencyCheck;
import org.neo4j.kernel.configuration.Config;

@RunWith(value=Enclosed.class)
public class BackupToolUrisTest {

    private static abstract class UriTests {
        final String host;
        final Integer port;
        final String uri;
        final BackupProtocolService backupProtocolService;
        final PrintStream systemOut;

        UriTests(String host, Integer port) {
            this.uri = port == null ? host : host + ":" + port;
            this.host = host.replace("ha://", "").replace("single://", "");
            this.port = port == null ? 6362 : port;
            this.backupProtocolService = (BackupProtocolService)Mockito.mock(BackupProtocolService.class);
            this.systemOut = (PrintStream)Mockito.mock(PrintStream.class);
        }

        static Object[] uri(String host) {
            return UriTests.uri(host, null);
        }

        static Object[] uri(String host, Integer port) {
            return new Object[]{host, port};
        }

        BackupTool newBackupTool() {
            return (BackupTool)Mockito.spy((Object)new BackupTool(this.backupProtocolService, this.systemOut));
        }
    }

    @RunWith(value=Parameterized.class)
    public static class IPv6UriTests
    extends UriTests {
        public IPv6UriTests(String host, Integer port) {
            super(host, port);
        }

        @Parameterized.Parameters
        public static List<Object[]> data() {
            return Arrays.asList(IPv6UriTests.uri("[2001:cdba:0000:0000:0000:0000:3257:9652]"), IPv6UriTests.uri("[2001:cdba:0000:0000:0000:0000:3257:9652]", 5656), IPv6UriTests.uri("[2001:cdba:0:0:0:0:3257:9652]"), IPv6UriTests.uri("[2001:cdba:0:0:0:0:3257:9652]", 9091), IPv6UriTests.uri("[2001:cdba::3257:9652]"), IPv6UriTests.uri("[2001:cdba::3257:9652]", 20), IPv6UriTests.uri("[2001:db8::1]", 9991), IPv6UriTests.uri("[2001:db8::1]", 1990), IPv6UriTests.uri("[::1]"), IPv6UriTests.uri("[::1]", 8989), IPv6UriTests.uri("[fe80::]"), IPv6UriTests.uri("[fe80::]", 1209), IPv6UriTests.uri("[::ffff:0:0]"), IPv6UriTests.uri("[::ffff:0:0]", 4545), IPv6UriTests.uri("[ff02::1:1]"), IPv6UriTests.uri("[ff02::1:1]", 6767), IPv6UriTests.uri("[2002::]"), IPv6UriTests.uri("[2002::]", 3040));
        }

        @Test
        public void shouldExecuteBackupWithValidUri() throws Exception {
            String[] args = new String[]{"-host", this.host, "-port", String.valueOf(this.port), "-to", "/var/backup/graph"};
            this.newBackupTool().run(args);
            ((BackupProtocolService)Mockito.verify((Object)this.backupProtocolService)).doIncrementalBackupOrFallbackToFull((String)ArgumentMatchers.eq((Object)this.host), ((Integer)ArgumentMatchers.eq((Object)this.port)).intValue(), (Path)ArgumentMatchers.eq((Object)Paths.get("/var/backup/graph", new String[0])), (ConsistencyCheck)ArgumentMatchers.eq((Object)ConsistencyCheck.FULL), (Config)ArgumentMatchers.any(Config.class), ArgumentMatchers.eq((long)BackupClient.BIG_READ_TIMEOUT), ArgumentMatchers.eq((boolean)false));
        }
    }

    @RunWith(value=Parameterized.class)
    public static class InvalidUriTests
    extends UriTests {
        public InvalidUriTests(String host, Integer port) {
            super(host, port);
        }

        @Parameterized.Parameters
        public static List<Object[]> data() {
            return Arrays.asList(InvalidUriTests.uri("foo://127.0.1.1"), InvalidUriTests.uri("single://localhost,ha://not-localhost"), InvalidUriTests.uri("single://127.0.0.1:6361,single://127.0.0.1:6362"), InvalidUriTests.uri("300.400.500.600"), InvalidUriTests.uri("host-name_with*wrong$chars.com"), InvalidUriTests.uri("dir://my"), InvalidUriTests.uri("dir://my", 10), InvalidUriTests.uri("foo://127.0.1.1"), InvalidUriTests.uri("foo://127.0.1.1", 6567), InvalidUriTests.uri("cat://localhost"), InvalidUriTests.uri("cat://localhost", 4444), InvalidUriTests.uri("notHA://instance1:,instance2:,instance3", 5454));
        }

        @Test
        public void shouldThrowForInvalidUri() {
            String[] args = new String[]{"-from", this.uri, "-to", "/var/backup/graph"};
            try {
                this.newBackupTool().run(args);
                Assert.fail((String)("Should exit abnormally for '" + this.uri + "'"));
            }
            catch (BackupTool.ToolFailureException e) {
                Assert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.equalTo((Object)BackupTool.WRONG_FROM_ADDRESS_SYNTAX));
            }
            Mockito.verifyZeroInteractions((Object[])new Object[]{this.backupProtocolService, this.systemOut});
        }
    }

    @RunWith(value=Parameterized.class)
    public static class ValidUriTests
    extends UriTests {
        public ValidUriTests(String host, Integer port) {
            super(host, port);
        }

        @Parameterized.Parameters
        public static List<Object[]> data() {
            return Arrays.asList(ValidUriTests.uri("127.0.0.1"), ValidUriTests.uri("127.0.0.1", 6362), ValidUriTests.uri("localhost"), ValidUriTests.uri("localhost", 1234), ValidUriTests.uri("192.127.10.12"), ValidUriTests.uri("192.127.10.12", 20), ValidUriTests.uri("1.1.1.1"), ValidUriTests.uri("1.1.1.1", 1), ValidUriTests.uri("neo4j.company.com"), ValidUriTests.uri("neo4j.company.com", 65200), ValidUriTests.uri("single://localhost", 7090), ValidUriTests.uri("test-site.with-long.name.com", 55555), ValidUriTests.uri("single://neo4j-backup.server", 6468), ValidUriTests.uri("single://apple.com"), ValidUriTests.uri("single://255.255.255.0"), ValidUriTests.uri("single://255.1.255.1", 88), ValidUriTests.uri("single://127.0.0.1"), ValidUriTests.uri("single://localhost"), ValidUriTests.uri("single://127.0.0.1", 6264), ValidUriTests.uri("ha://test.server"), ValidUriTests.uri("ha://test.server", 1212));
        }

        @Test
        public void shouldExecuteBackupWithValidUri() throws Exception {
            String[] args = new String[]{"-from", this.uri, "-to", "/var/backup/graph"};
            this.newBackupTool().run(args);
            ((BackupProtocolService)Mockito.verify((Object)this.backupProtocolService)).doIncrementalBackupOrFallbackToFull((String)ArgumentMatchers.eq((Object)this.host), ((Integer)ArgumentMatchers.eq((Object)this.port)).intValue(), (Path)ArgumentMatchers.eq((Object)Paths.get("/var/backup/graph", new String[0])), (ConsistencyCheck)ArgumentMatchers.eq((Object)ConsistencyCheck.FULL), (Config)ArgumentMatchers.any(Config.class), ArgumentMatchers.eq((long)BackupClient.BIG_READ_TIMEOUT), ArgumentMatchers.eq((boolean)false));
        }
    }
}

