/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.backup;

import java.io.PrintStream;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Deque;
import java.util.List;
import java.util.Map;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.neo4j.backup.BackupTool;
import org.neo4j.backup.impl.BackupClient;
import org.neo4j.backup.impl.BackupProtocolService;
import org.neo4j.backup.impl.ConsistencyCheck;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.kernel.configuration.Config;

@RunWith(value=Parameterized.class)
public class BackupToolCmdArgumentsAcceptanceTest {
    private static final String HOST = "localhost";
    private static final int PORT = 9090;
    private static final Path PATH = Paths.get("/var/backup/neo4j/", new String[0]);
    @Parameterized.Parameter(value=0)
    public String argsAsString;
    @Parameterized.Parameter(value=1)
    public boolean expectedVerifyStoreValue;

    @Parameterized.Parameters(name="args=({0})")
    public static Iterable<Object[]> data() {
        return Iterables.concat((Iterable[])new Iterable[]{BackupToolCmdArgumentsAcceptanceTest.allCombinations(MapUtil.stringMap((String[])new String[]{"host", HOST, "port", String.valueOf(9090), "to", PATH.toString()})), BackupToolCmdArgumentsAcceptanceTest.allCombinations(MapUtil.stringMap((String[])new String[]{"from", "localhost:9090", "to", PATH.toString()}))});
    }

    @Test
    public void shouldInvokeBackupServiceWhenArgsAreValid() throws Exception {
        String[] args = this.argsAsString.split(" ");
        BackupProtocolService backupProtocolService = (BackupProtocolService)Mockito.mock(BackupProtocolService.class);
        PrintStream printStream = (PrintStream)Mockito.mock(PrintStream.class);
        BackupTool backupTool = new BackupTool(backupProtocolService, printStream);
        backupTool.run(args);
        ((BackupProtocolService)Mockito.verify((Object)backupProtocolService)).doIncrementalBackupOrFallbackToFull((String)ArgumentMatchers.eq((Object)HOST), ArgumentMatchers.eq((int)9090), (Path)ArgumentMatchers.eq((Object)PATH), this.expectedVerifyStoreValue ? (ConsistencyCheck)ArgumentMatchers.eq((Object)ConsistencyCheck.FULL) : (ConsistencyCheck)ArgumentMatchers.eq((Object)ConsistencyCheck.NONE), (Config)ArgumentMatchers.any(Config.class), ArgumentMatchers.eq((long)BackupClient.BIG_READ_TIMEOUT), ArgumentMatchers.eq((boolean)false));
    }

    private static List<String> allFlagValues(String name, boolean value) {
        return value ? Arrays.asList("-" + name, "--" + name, "-" + name + "=true", "--" + name + "=true", "-" + name + " true", "--" + name + " true") : Arrays.asList("-" + name + "=false", "--" + name + "=false", "-" + name + " false", "--" + name + " false");
    }

    private static Iterable<Object[]> allCombinations(Map<String, String> optionsMap) {
        return Iterables.concat((Iterable[])new Iterable[]{BackupToolCmdArgumentsAcceptanceTest.allCombinations(optionsMap, true), BackupToolCmdArgumentsAcceptanceTest.allCombinations(optionsMap, false)});
    }

    private static List<Object[]> allCombinations(Map<String, String> optionsMap, boolean verifyStore) {
        ArrayList<Object[]> result = new ArrayList<Object[]>();
        List<List<String>> optionCombinations = BackupToolCmdArgumentsAcceptanceTest.gatherAllOptionCombinations(optionsMap);
        List<String> verifyFlagValues = BackupToolCmdArgumentsAcceptanceTest.allFlagValues("verify", verifyStore);
        for (List<String> options : optionCombinations) {
            for (String flag : verifyFlagValues) {
                List<String> args = BackupToolCmdArgumentsAcceptanceTest.join(options, flag);
                StringBuilder sb = new StringBuilder();
                for (String arg : args) {
                    sb.append(sb.length() > 0 ? " " : "").append(arg);
                }
                String argsJoinedAsString = sb.toString();
                result.add(new Object[]{argsJoinedAsString, verifyStore});
            }
        }
        return result;
    }

    private static List<List<String>> gatherAllOptionCombinations(Map<String, String> optionsMap) {
        ArrayList<List<String>> result = new ArrayList<List<String>>();
        ArrayDeque<String> stack = new ArrayDeque<String>();
        Map.Entry[] entries = optionsMap.entrySet().toArray(new Map.Entry[0]);
        BackupToolCmdArgumentsAcceptanceTest.gatherAllOptionCombinations(entries, 0, stack, result);
        return result;
    }

    private static void gatherAllOptionCombinations(Map.Entry<String, String>[] entries, int current, Deque<String> stack, List<List<String>> result) {
        if (current == entries.length) {
            result.add(new ArrayList<String>(stack));
        } else {
            Map.Entry<String, String> entry = entries[current];
            int next = current + 1;
            for (String arg : BackupToolCmdArgumentsAcceptanceTest.possibleArgs(entry.getKey(), entry.getValue())) {
                stack.push(arg);
                BackupToolCmdArgumentsAcceptanceTest.gatherAllOptionCombinations(entries, next, stack, result);
                stack.pop();
            }
        }
    }

    private static List<String> possibleArgs(String key, String value) {
        return value == null ? Arrays.asList("-" + key, "--" + key) : Arrays.asList("-" + key + "=" + value, "--" + key + "=" + value, "-" + key + " " + value, "--" + key + " " + value);
    }

    private static List<String> join(List<String> list, String element) {
        ArrayList<String> result = new ArrayList<String>(list);
        result.add(element);
        return result;
    }
}

