/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.restore;

import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import org.neo4j.commandline.Util;
import org.neo4j.commandline.admin.CommandFailed;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.transaction.log.files.LogFiles;
import org.neo4j.kernel.impl.transaction.log.files.LogFilesBuilder;
import org.neo4j.kernel.impl.util.Validators;

public class RestoreDatabaseCommand {
    private FileSystemAbstraction fs;
    private final File fromPath;
    private final File databaseDir;
    private final File transactionLogsDirectory;
    private String databaseName;
    private boolean forceOverwrite;

    public RestoreDatabaseCommand(FileSystemAbstraction fs, File fromPath, Config config, String databaseName, boolean forceOverwrite) {
        this.fs = fs;
        this.fromPath = fromPath;
        this.databaseName = databaseName;
        this.forceOverwrite = forceOverwrite;
        this.databaseDir = ((File)config.get(GraphDatabaseSettings.database_path)).getAbsoluteFile();
        this.transactionLogsDirectory = ((File)config.get(GraphDatabaseSettings.logical_logs_location)).getAbsoluteFile();
    }

    public void execute() throws IOException, CommandFailed {
        if (!this.fs.fileExists(this.fromPath)) {
            throw new IllegalArgumentException(String.format("Source directory does not exist [%s]", this.fromPath));
        }
        try {
            Validators.CONTAINS_EXISTING_DATABASE.validate((Object)this.fromPath);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException(String.format("Source directory is not a database backup [%s]", this.fromPath));
        }
        if (this.fs.fileExists(this.databaseDir) && !this.forceOverwrite) {
            throw new IllegalArgumentException(String.format("Database with name [%s] already exists at %s", this.databaseName, this.databaseDir));
        }
        Util.checkLock((Path)this.databaseDir.toPath());
        this.fs.deleteRecursively(this.databaseDir);
        if (!Util.isSameOrChildFile((File)this.databaseDir, (File)this.transactionLogsDirectory)) {
            this.fs.deleteRecursively(this.transactionLogsDirectory);
        }
        LogFiles backupLogFiles = LogFilesBuilder.logFilesBasedOnlyBuilder((File)this.fromPath, (FileSystemAbstraction)this.fs).build();
        this.restoreDatabaseFiles(backupLogFiles, this.fromPath.listFiles());
    }

    private void restoreDatabaseFiles(LogFiles backupLogFiles, File[] files) throws IOException {
        if (files != null) {
            for (File file : files) {
                if (file.isDirectory()) {
                    File destination = new File(this.databaseDir, file.getName());
                    this.fs.mkdirs(destination);
                    this.fs.copyRecursively(file, destination);
                    continue;
                }
                this.fs.copyToDirectory(file, backupLogFiles.isLogFile(file) ? this.transactionLogsDirectory : this.databaseDir);
            }
        }
    }
}

