/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.backup.impl;

import java.io.OutputStream;
import java.time.Clock;
import java.time.Duration;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import org.neo4j.backup.impl.BackupDelegator;
import org.neo4j.backup.impl.BackupModule;
import org.neo4j.backup.impl.BackupOutputMonitor;
import org.neo4j.backup.impl.BackupProtocolService;
import org.neo4j.backup.impl.BackupSupportingClasses;
import org.neo4j.causalclustering.catchup.CatchUpClient;
import org.neo4j.causalclustering.catchup.CatchupClientBuilder;
import org.neo4j.causalclustering.catchup.storecopy.RemoteStore;
import org.neo4j.causalclustering.catchup.storecopy.StoreCopyClient;
import org.neo4j.causalclustering.catchup.tx.TransactionLogCatchUpFactory;
import org.neo4j.causalclustering.catchup.tx.TxPullClient;
import org.neo4j.causalclustering.core.CausalClusteringSettings;
import org.neo4j.causalclustering.core.SupportedProtocolCreator;
import org.neo4j.causalclustering.handlers.PipelineWrapper;
import org.neo4j.causalclustering.handlers.VoidPipelineWrapperFactory;
import org.neo4j.causalclustering.helper.ExponentialBackoffStrategy;
import org.neo4j.causalclustering.helper.TimeoutStrategy;
import org.neo4j.causalclustering.protocol.NettyPipelineBuilderFactory;
import org.neo4j.causalclustering.protocol.handshake.ApplicationSupportedProtocols;
import org.neo4j.commandline.admin.OutsideWorld;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.enterprise.configuration.OnlineBackupSettings;
import org.neo4j.kernel.impl.pagecache.ConfigurableStandalonePageCacheFactory;
import org.neo4j.kernel.monitoring.Monitors;
import org.neo4j.logging.LogProvider;

public class BackupSupportingClassesFactory {
    protected final LogProvider logProvider;
    protected final Clock clock;
    protected final Monitors monitors;
    protected final FileSystemAbstraction fileSystemAbstraction;
    protected final TransactionLogCatchUpFactory transactionLogCatchUpFactory;
    protected final OutputStream logDestination;
    protected final OutsideWorld outsideWorld;

    protected BackupSupportingClassesFactory(BackupModule backupModule) {
        this.logProvider = backupModule.getLogProvider();
        this.clock = backupModule.getClock();
        this.monitors = backupModule.getMonitors();
        this.fileSystemAbstraction = backupModule.getFileSystemAbstraction();
        this.transactionLogCatchUpFactory = backupModule.getTransactionLogCatchUpFactory();
        this.logDestination = backupModule.getOutsideWorld().outStream();
        this.outsideWorld = backupModule.getOutsideWorld();
    }

    BackupSupportingClasses createSupportingClasses(Config config) {
        this.monitors.addMonitorListener((Object)new BackupOutputMonitor(this.outsideWorld), new String[0]);
        PageCache pageCache = BackupSupportingClassesFactory.createPageCache(this.fileSystemAbstraction, config);
        return new BackupSupportingClasses(this.backupDelegatorFromConfig(pageCache, config), this.haFromConfig(pageCache), pageCache);
    }

    private BackupProtocolService haFromConfig(PageCache pageCache) {
        Supplier<FileSystemAbstraction> fileSystemSupplier = () -> this.fileSystemAbstraction;
        return new BackupProtocolService(fileSystemSupplier, this.logProvider, this.logDestination, this.monitors, pageCache);
    }

    private BackupDelegator backupDelegatorFromConfig(PageCache pageCache, Config config) {
        CatchUpClient catchUpClient = this.catchUpClient(config);
        TxPullClient txPullClient = new TxPullClient(catchUpClient, this.monitors);
        ExponentialBackoffStrategy backOffStrategy = new ExponentialBackoffStrategy(1L, ((Duration)config.get(CausalClusteringSettings.store_copy_backoff_max_wait)).toMillis(), TimeUnit.MILLISECONDS);
        StoreCopyClient storeCopyClient = new StoreCopyClient(catchUpClient, this.monitors, this.logProvider, (TimeoutStrategy)backOffStrategy);
        RemoteStore remoteStore = new RemoteStore(this.logProvider, this.fileSystemAbstraction, pageCache, storeCopyClient, txPullClient, this.transactionLogCatchUpFactory, config, this.monitors);
        return BackupSupportingClassesFactory.backupDelegator(remoteStore, catchUpClient, storeCopyClient);
    }

    protected PipelineWrapper createPipelineWrapper(Config config) {
        return new VoidPipelineWrapperFactory().forClient(config, null, this.logProvider, OnlineBackupSettings.ssl_policy);
    }

    private CatchUpClient catchUpClient(Config config) {
        SupportedProtocolCreator supportedProtocolCreator = new SupportedProtocolCreator(config, this.logProvider);
        ApplicationSupportedProtocols supportedCatchupProtocols = supportedProtocolCreator.createSupportedCatchupProtocol();
        List supportedModifierProtocols = supportedProtocolCreator.createSupportedModifierProtocols();
        NettyPipelineBuilderFactory clientPipelineBuilderFactory = new NettyPipelineBuilderFactory(this.createPipelineWrapper(config));
        Duration handshakeTimeout = (Duration)config.get(CausalClusteringSettings.handshake_timeout);
        return new CatchupClientBuilder(supportedCatchupProtocols, (Collection)supportedModifierProtocols, clientPipelineBuilderFactory, handshakeTimeout, this.logProvider, this.logProvider, this.clock).build();
    }

    private static BackupDelegator backupDelegator(RemoteStore remoteStore, CatchUpClient catchUpClient, StoreCopyClient storeCopyClient) {
        return new BackupDelegator(remoteStore, catchUpClient, storeCopyClient);
    }

    private static PageCache createPageCache(FileSystemAbstraction fileSystemAbstraction, Config config) {
        return ConfigurableStandalonePageCacheFactory.createPageCache((FileSystemAbstraction)fileSystemAbstraction, (Config)config);
    }
}

