/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.commandline.admin;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.backup.impl.BackupHelpOutput;
import org.neo4j.commandline.admin.AdminTool;
import org.neo4j.commandline.admin.CommandLocator;
import org.neo4j.commandline.admin.OutsideWorld;
import org.neo4j.commandline.admin.ParameterisedOutsideWorld;
import org.neo4j.io.fs.DefaultFileSystemAbstraction;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.test.rule.SuppressOutput;

public class BackupUsageTest {
    private static final Path HERE = Paths.get(".", new String[0]);
    @Rule
    public SuppressOutput suppressOutput = SuppressOutput.suppressAll();
    private final CommandLocator commandLocator = CommandLocator.fromServiceLocator();

    @Test
    public void outputMatchesExpectedForMissingBackupDir() {
        String output = this.runBackup(new String[0]);
        String reason = "Missing argument 'backup-dir'";
        Assert.assertThat((Object)output, (Matcher)Matchers.containsString((String)reason));
        for (String line : BackupHelpOutput.BACKUP_OUTPUT_LINES) {
            Assert.assertThat((Object)output, (Matcher)Matchers.containsString((String)line));
        }
    }

    @Test
    public void missingBackupName() {
        String output = this.runBackup("--backup-dir=target");
        String reason = "Missing argument 'name'";
        Assert.assertThat((Object)output, (Matcher)Matchers.containsString((String)reason));
        for (String line : BackupHelpOutput.BACKUP_OUTPUT_LINES) {
            Assert.assertThat((String)("Failed for line: " + line), (Object)output, (Matcher)Matchers.containsString((String)line));
        }
    }

    @Test
    public void incorrectBackupDirectory() throws IOException {
        Path backupDirectoryResolved = HERE.toRealPath(new LinkOption[0]).resolve("non_existing_dir");
        String output = this.runBackup("--backup-dir=non_existing_dir", "--name=mybackup");
        String reason = String.format("command failed: Directory '%s' does not exist.", backupDirectoryResolved);
        Assert.assertThat((Object)output, (Matcher)Matchers.containsString((String)reason));
    }

    private String runBackup(String ... args) {
        return this.runBackup(false, args);
    }

    private String runBackup(boolean debug, String ... args) {
        ParameterisedOutsideWorld outsideWorld = new ParameterisedOutsideWorld(System.console(), (OutputStream)System.out, (OutputStream)System.err, System.in, (FileSystemAbstraction)new DefaultFileSystemAbstraction());
        AdminTool subject = new AdminTool(this.commandLocator, cmd -> new ArrayList(), (OutsideWorld)outsideWorld, debug);
        Path homeDir = HERE;
        Path configDir = HERE;
        ArrayList<String> params = new ArrayList<String>();
        params.add("backup");
        params.addAll(Arrays.asList(args));
        String[] argArray = params.toArray(new String[params.size()]);
        subject.execute(homeDir, configDir, argArray);
        return this.suppressOutput.getErrorVoice().toString() + System.lineSeparator() + this.suppressOutput.getOutputVoice().toString();
    }
}

