/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering;

import org.neo4j.causalclustering.core.CoreGraphDatabase;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.test.DbRepresentation;

public class ClusterHelper {
    public static final Label label = Label.label((String)"any_label");
    public static final String PROP_NAME = "name";
    public static final String PROP_RANDOM = "random";

    public static DbRepresentation createSomeData(GraphDatabaseService db) {
        try (Transaction tx = db.beginTx();){
            ClusterHelper.createSomeData(db, tx);
        }
        return DbRepresentation.of((GraphDatabaseService)db);
    }

    public static void createSomeData(GraphDatabaseService db, Transaction tx) {
        Node node = db.createNode();
        node.setProperty(PROP_NAME, (Object)"Neo");
        node.setProperty(PROP_RANDOM, (Object)(Math.random() * 10000.0));
        db.createNode().createRelationshipTo(node, RelationshipType.withName((String)"KNOWS"));
        tx.success();
    }

    public static void createIndexes(CoreGraphDatabase db) {
        try (Transaction tx = db.beginTx();){
            db.schema().indexFor(label).on(PROP_NAME).on(PROP_RANDOM).create();
            tx.success();
        }
    }
}

