/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.backup.impl;

import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.neo4j.backup.impl.BackupModule;
import org.neo4j.backup.impl.BackupSupportingClassesFactory;
import org.neo4j.backup.impl.BackupSupportingClassesFactoryProvider;
import org.neo4j.causalclustering.handlers.PipelineWrapper;
import org.neo4j.causalclustering.handlers.VoidPipelineWrapperFactory;
import org.neo4j.commandline.admin.OutsideWorld;
import org.neo4j.kernel.configuration.Config;

public class OnlineBackupCommandProviderTest {
    @Test
    public void communityBackupSupportingFactory() {
        BackupModule backupModule = (BackupModule)Mockito.mock(BackupModule.class);
        OutsideWorld outsideWorld = (OutsideWorld)Mockito.mock(OutsideWorld.class);
        Mockito.when((Object)backupModule.getOutsideWorld()).thenReturn((Object)outsideWorld);
        BackupSupportingClassesFactoryProvider provider = (BackupSupportingClassesFactoryProvider)BackupSupportingClassesFactoryProvider.getProvidersByPriority().findFirst().get();
        BackupSupportingClassesFactory factory = provider.getFactory(backupModule);
        Assert.assertEquals((Object)VoidPipelineWrapperFactory.VOID_WRAPPER, (Object)factory.createPipelineWrapper(Config.defaults()));
    }

    public static class DummyProvider
    extends BackupSupportingClassesFactoryProvider {
        public BackupSupportingClassesFactory getFactory(BackupModule backupModule) {
            return new BackupSupportingClassesFactory(backupModule){

                protected PipelineWrapper createPipelineWrapper(Config config) {
                    throw new AssertionError((Object)"This provider should never be loaded");
                }
            };
        }

        protected int getPriority() {
            return super.getPriority() - 1;
        }
    }
}

