/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.backup.impl;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.lang3.SystemUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.neo4j.backup.impl.BackupTransactionLogFilesHelper;
import org.neo4j.backup.impl.OnlineBackupCommandBuilder;
import org.neo4j.backup.impl.OnlineBackupCommandHaIT;
import org.neo4j.causalclustering.ClusterHelper;
import org.neo4j.causalclustering.core.CausalClusteringSettings;
import org.neo4j.causalclustering.core.CoreGraphDatabase;
import org.neo4j.causalclustering.core.consensus.roles.Role;
import org.neo4j.causalclustering.discovery.Cluster;
import org.neo4j.causalclustering.discovery.CoreClusterMember;
import org.neo4j.causalclustering.discovery.DiscoveryServiceFactory;
import org.neo4j.causalclustering.discovery.IpFamily;
import org.neo4j.causalclustering.discovery.SharedDiscoveryServiceFactory;
import org.neo4j.causalclustering.helpers.CausalClusteringTestHelpers;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.enterprise.configuration.OnlineBackupSettings;
import org.neo4j.kernel.impl.factory.GraphDatabaseFacade;
import org.neo4j.kernel.impl.transaction.log.files.LogFiles;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.ports.allocation.PortAuthority;
import org.neo4j.test.DbRepresentation;
import org.neo4j.test.causalclustering.ClusterRule;
import org.neo4j.test.rule.SuppressOutput;
import org.neo4j.test.rule.TestDirectory;
import org.neo4j.util.TestHelpers;

@RunWith(value=Parameterized.class)
public class OnlineBackupCommandCcIT {
    @Rule
    public final TestDirectory testDirectory = TestDirectory.testDirectory();
    @Rule
    public ClusterRule clusterRule = new ClusterRule().withNumberOfCoreMembers(3).withNumberOfReadReplicas(3).withSharedCoreParam(CausalClusteringSettings.cluster_topology_refresh, "5s");
    @Rule
    public final RuleChain ruleChain = RuleChain.outerRule((TestRule)SuppressOutput.suppressAll()).around((TestRule)this.clusterRule);
    private File backupDir;
    private List<Runnable> oneOffShutdownTasks;
    @Parameterized.Parameter
    public String recordFormat;

    @Parameterized.Parameters(name="{0}")
    public static List<String> recordFormats() {
        return Arrays.asList("standard", "high_limit");
    }

    @Before
    public void initialiseBackupDirectory() {
        this.oneOffShutdownTasks = new ArrayList<Runnable>();
        this.backupDir = this.testDirectory.directory("backups");
    }

    @After
    public void performShutdownTasks() {
        this.oneOffShutdownTasks.forEach(Runnable::run);
    }

    @Test
    public void backupCanBePerformedOverCcWithCustomPort() throws Exception {
        Assume.assumeFalse((boolean)SystemUtils.IS_OS_WINDOWS);
        Cluster cluster = this.startCluster(this.recordFormat);
        String customAddress = CausalClusteringTestHelpers.transactionAddress((GraphDatabaseFacade)OnlineBackupCommandCcIT.clusterLeader(cluster).database());
        Assert.assertEquals((long)0L, (long)this.runBackupToolFromOtherJvmToGetExitCode("--from", customAddress, "--cc-report-dir=" + this.backupDir, "--backup-dir=" + this.backupDir, "--name=defaultport"));
        Assert.assertEquals((Object)DbRepresentation.of((GraphDatabaseService)OnlineBackupCommandCcIT.clusterDatabase(cluster)), (Object)OnlineBackupCommandCcIT.getBackupDbRepresentation("defaultport", this.backupDir));
        OnlineBackupCommandCcIT.createSomeData(cluster);
        Assert.assertEquals((long)0L, (long)this.runBackupToolFromOtherJvmToGetExitCode("--from", customAddress, "--cc-report-dir=" + this.backupDir, "--backup-dir=" + this.backupDir, "--name=defaultport"));
        Assert.assertEquals((Object)DbRepresentation.of((GraphDatabaseService)OnlineBackupCommandCcIT.clusterDatabase(cluster)), (Object)OnlineBackupCommandCcIT.getBackupDbRepresentation("defaultport", this.backupDir));
    }

    @Test
    public void dataIsInAUsableStateAfterBackup() throws Exception {
        Cluster cluster = this.startCluster(this.recordFormat);
        ClusterHelper.createIndexes(cluster.getMemberWithAnyRole(new Role[]{Role.LEADER}).database());
        AtomicBoolean populateDatabaseFlag = new AtomicBoolean(true);
        new Thread(() -> this.repeatedlyPopulateDatabase(cluster, populateDatabaseFlag)).start();
        this.oneOffShutdownTasks.add(() -> populateDatabaseFlag.set(false));
        String address = TestHelpers.backupAddressCc((GraphDatabaseAPI)OnlineBackupCommandCcIT.clusterLeader(cluster).database());
        Assert.assertEquals((long)0L, (long)this.runBackupToolFromOtherJvmToGetExitCode("--from", address, "--cc-report-dir=" + this.backupDir, "--backup-dir=" + this.backupDir, "--name=defaultport"));
    }

    @Test
    public void backupCanBeOptionallySwitchedOnWithTheBackupConfig() throws Exception {
        int[] backupPorts = new int[]{PortAuthority.allocatePort(), PortAuthority.allocatePort(), PortAuthority.allocatePort()};
        String value = "localhost:%d";
        this.clusterRule = this.clusterRule.withSharedCoreParam(OnlineBackupSettings.online_backup_enabled, "true").withInstanceCoreParam(OnlineBackupSettings.online_backup_server, i -> String.format(value, backupPorts[i]));
        Cluster cluster = this.startCluster(this.recordFormat);
        String customAddress = "localhost:" + backupPorts[0];
        Assert.assertEquals((long)0L, (long)this.runBackupToolFromOtherJvmToGetExitCode("--from=" + customAddress, "--cc-report-dir=" + this.backupDir, "--backup-dir=" + this.backupDir, "--name=defaultport"));
        Assert.assertEquals((Object)DbRepresentation.of((GraphDatabaseService)OnlineBackupCommandCcIT.clusterDatabase(cluster)), (Object)OnlineBackupCommandCcIT.getBackupDbRepresentation("defaultport", this.backupDir));
        OnlineBackupCommandCcIT.createSomeData(cluster);
        Assert.assertEquals((long)0L, (long)this.runBackupToolFromOtherJvmToGetExitCode("--from=" + customAddress, "--cc-report-dir=" + this.backupDir, "--backup-dir=" + this.backupDir, "--name=defaultport"));
        Assert.assertEquals((Object)DbRepresentation.of((GraphDatabaseService)OnlineBackupCommandCcIT.clusterDatabase(cluster)), (Object)OnlineBackupCommandCcIT.getBackupDbRepresentation("defaultport", this.backupDir));
    }

    @Test
    public void secondaryTransactionProtocolIsSwitchedOffCorrespondingBackupSetting() throws Exception {
        int[] backupPorts = new int[]{PortAuthority.allocatePort(), PortAuthority.allocatePort(), PortAuthority.allocatePort()};
        String value = "localhost:%d";
        this.clusterRule = this.clusterRule.withSharedCoreParam(OnlineBackupSettings.online_backup_enabled, "false").withInstanceCoreParam(OnlineBackupSettings.online_backup_server, i -> String.format(value, backupPorts[i]));
        this.startCluster(this.recordFormat);
        String customAddress = "localhost:" + backupPorts[0];
        Assert.assertEquals((long)1L, (long)this.runBackupToolFromOtherJvmToGetExitCode("--from=" + customAddress, "--cc-report-dir=" + this.backupDir, "--backup-dir=" + this.backupDir, "--name=defaultport"));
    }

    @Test
    public void backupDoesntDisplayExceptionWhenSuccessful() throws Exception {
        Cluster cluster = this.startCluster(this.recordFormat);
        String customAddress = CausalClusteringTestHelpers.transactionAddress((GraphDatabaseFacade)OnlineBackupCommandCcIT.clusterLeader(cluster).database());
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        PrintStream outputStream = OnlineBackupCommandCcIT.wrapWithNormalOutput(System.out, new PrintStream(byteArrayOutputStream));
        ByteArrayOutputStream byteArrayErrorStream = new ByteArrayOutputStream();
        PrintStream errorStream = OnlineBackupCommandCcIT.wrapWithNormalOutput(System.err, new PrintStream(byteArrayErrorStream));
        Assert.assertEquals((long)0L, (long)this.runBackupToolFromOtherJvmToGetExitCode(outputStream, errorStream, "--from", customAddress, "--cc-report-dir=" + this.backupDir, "--backup-dir=" + this.backupDir, "--name=defaultport"));
        Assert.assertFalse((boolean)byteArrayErrorStream.toString().toLowerCase().contains("exception"));
        Assert.assertFalse((boolean)byteArrayOutputStream.toString().toLowerCase().contains("exception"));
    }

    @Test
    public void reportsProgress() throws Exception {
        Cluster cluster = this.startCluster(this.recordFormat);
        ClusterHelper.createIndexes(cluster.getMemberWithAnyRole(new Role[]{Role.LEADER}).database());
        String customAddress = CausalClusteringTestHelpers.backupAddress((GraphDatabaseFacade)OnlineBackupCommandCcIT.clusterLeader(cluster).database());
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        PrintStream outputStream = OnlineBackupCommandCcIT.wrapWithNormalOutput(System.out, new PrintStream(byteArrayOutputStream));
        ByteArrayOutputStream byteArrayErrorStream = new ByteArrayOutputStream();
        PrintStream errorStream = OnlineBackupCommandCcIT.wrapWithNormalOutput(System.err, new PrintStream(byteArrayErrorStream));
        String backupName = "reportsProgress_" + this.recordFormat;
        Assert.assertEquals((long)0L, (long)this.runBackupToolFromOtherJvmToGetExitCode(outputStream, errorStream, "--from", customAddress, "--protocol=catchup", "--cc-report-dir=" + this.backupDir, "--backup-dir=" + this.backupDir, "--name=" + backupName));
        String output = byteArrayOutputStream.toString();
        String location = Paths.get(this.backupDir.toString(), backupName).toString();
        Assert.assertTrue((boolean)output.contains("Start receiving store files"));
        Assert.assertTrue((boolean)output.contains("Finish receiving store files"));
        String tested = Paths.get(location, "neostore.nodestore.db.labels").toString();
        Assert.assertTrue((String)tested, (boolean)output.contains(String.format("Start receiving store file %s", tested)));
        Assert.assertTrue((String)tested, (boolean)output.contains(String.format("Finish receiving store file %s", tested)));
        Assert.assertTrue((boolean)output.contains("Start receiving transactions from "));
        Assert.assertTrue((boolean)output.contains("Finish receiving transactions at "));
        Assert.assertTrue((boolean)output.contains("Start receiving index snapshots"));
        Assert.assertTrue((boolean)output.contains("Finished receiving index snapshots"));
    }

    @Test
    public void onlyTheLatestTransactionIsKeptAfterIncrementalBackup() throws Exception {
        Cluster cluster = this.startCluster(this.recordFormat);
        OnlineBackupCommandCcIT.createSomeData(cluster);
        Config config = Config.builder().withSetting(GraphDatabaseSettings.logical_log_rotation_threshold, "1m").build();
        File configOverrideFile = this.testDirectory.file("neo4j-backup.conf");
        OnlineBackupCommandBuilder.writeConfigToFile((Config)config, (File)configOverrideFile);
        String backupName = "backupName" + this.recordFormat;
        String address = CausalClusteringTestHelpers.backupAddress((GraphDatabaseFacade)OnlineBackupCommandCcIT.clusterLeader(cluster).database());
        Assert.assertEquals((long)0L, (long)this.runBackupToolFromOtherJvmToGetExitCode("--from", address, "--cc-report-dir=" + this.backupDir, "--backup-dir=" + this.backupDir, "--additional-config=" + configOverrideFile, "--name=" + backupName));
        OnlineBackupCommandHaIT.transactions1M((GraphDatabaseService)OnlineBackupCommandCcIT.clusterLeader(cluster).database());
        OnlineBackupCommandHaIT.transactions1M((GraphDatabaseService)OnlineBackupCommandCcIT.clusterLeader(cluster).database());
        Assert.assertEquals((long)0L, (long)this.runBackupToolFromSameJvm("--from", address, "--cc-report-dir=" + this.backupDir, "--backup-dir=" + this.backupDir, "--additional-config=" + configOverrideFile, "--name=" + backupName));
        BackupTransactionLogFilesHelper backupTransactionLogFilesHelper = new BackupTransactionLogFilesHelper();
        LogFiles logFiles = backupTransactionLogFilesHelper.readLogFiles(this.backupDir.toPath().resolve(backupName).toFile());
        long highestTxIdInLogFiles = logFiles.getHighestLogVersion();
        Assert.assertEquals((long)2L, (long)highestTxIdInLogFiles);
        long lowestTxIdInLogFiles = logFiles.getLowestLogVersion();
        Assert.assertEquals((long)0L, (long)lowestTxIdInLogFiles);
    }

    @Test
    public void backupRenamesWork() throws Exception {
        String backupName = "preexistingBackup_" + this.recordFormat;
        Cluster cluster = this.startCluster(this.recordFormat);
        String firstBackupAddress = CausalClusteringTestHelpers.transactionAddress((GraphDatabaseFacade)OnlineBackupCommandCcIT.clusterLeader(cluster).database());
        Assert.assertEquals((long)0L, (long)this.runBackupToolFromOtherJvmToGetExitCode("--from", firstBackupAddress, "--cc-report-dir=" + this.backupDir, "--backup-dir=" + this.backupDir, "--name=" + backupName));
        DbRepresentation firstDatabaseRepresentation = DbRepresentation.of((GraphDatabaseService)OnlineBackupCommandCcIT.clusterLeader(cluster).database());
        Cluster cluster2 = this.startCluster2(this.recordFormat);
        DbRepresentation secondDatabaseRepresentation = DbRepresentation.of((GraphDatabaseService)OnlineBackupCommandCcIT.clusterLeader(cluster2).database());
        Assert.assertNotEquals((Object)firstDatabaseRepresentation, (Object)secondDatabaseRepresentation);
        String secondBackupAddress = CausalClusteringTestHelpers.transactionAddress((GraphDatabaseFacade)OnlineBackupCommandCcIT.clusterLeader(cluster2).database());
        Assert.assertEquals((long)0L, (long)this.runBackupToolFromOtherJvmToGetExitCode("--from", secondBackupAddress, "--cc-report-dir=" + this.backupDir, "--backup-dir=" + this.backupDir, "--name=" + backupName));
        cluster2.shutdown();
        Assert.assertEquals((Object)secondDatabaseRepresentation, (Object)OnlineBackupCommandCcIT.getBackupDbRepresentation(backupName, this.backupDir));
        Assert.assertEquals((Object)firstDatabaseRepresentation, (Object)OnlineBackupCommandCcIT.getBackupDbRepresentation(backupName + ".err.0", this.backupDir));
        Assert.assertNotEquals((Object)firstDatabaseRepresentation, (Object)secondDatabaseRepresentation);
    }

    static PrintStream wrapWithNormalOutput(PrintStream normalOutput, PrintStream nullAbleOutput) {
        if (nullAbleOutput == null) {
            return normalOutput;
        }
        return OnlineBackupCommandCcIT.duplexPrintStream(normalOutput, nullAbleOutput);
    }

    private static PrintStream duplexPrintStream(PrintStream first, final PrintStream second) {
        return new PrintStream((OutputStream)first){

            @Override
            public void write(int i) {
                super.write(i);
                second.write(i);
            }

            @Override
            public void write(byte[] bytes, int i, int i1) {
                super.write(bytes, i, i1);
                second.write(bytes, i, i1);
            }

            @Override
            public void write(byte[] bytes) throws IOException {
                super.write(bytes);
                second.write(bytes);
            }

            @Override
            public void flush() {
                super.flush();
                second.flush();
            }

            @Override
            public void close() {
                super.close();
                second.close();
            }
        };
    }

    private void repeatedlyPopulateDatabase(Cluster cluster, AtomicBoolean continueFlagReference) {
        while (continueFlagReference.get()) {
            OnlineBackupCommandCcIT.createSomeData(cluster);
        }
    }

    public static CoreGraphDatabase clusterDatabase(Cluster cluster) {
        return OnlineBackupCommandCcIT.clusterLeader(cluster).database();
    }

    private Cluster startCluster(String recordFormat) throws Exception {
        ClusterRule clusterRule = this.clusterRule.withSharedCoreParam(GraphDatabaseSettings.record_format, recordFormat).withSharedReadReplicaParam(GraphDatabaseSettings.record_format, recordFormat);
        Cluster cluster = clusterRule.startCluster();
        OnlineBackupCommandCcIT.createSomeData(cluster);
        return cluster;
    }

    private Cluster startCluster2(String recordFormat) throws ExecutionException, InterruptedException {
        HashMap<String, String> sharedParams = new HashMap<String, String>();
        sharedParams.put(GraphDatabaseSettings.record_format.name(), recordFormat);
        Cluster cluster = new Cluster(this.testDirectory.directory("cluster-b_" + recordFormat), 3, 0, (DiscoveryServiceFactory)new SharedDiscoveryServiceFactory(), sharedParams, Collections.emptyMap(), sharedParams, Collections.emptyMap(), recordFormat, IpFamily.IPV4, false);
        cluster.start();
        OnlineBackupCommandCcIT.createSomeData(cluster);
        return cluster;
    }

    public static DbRepresentation createSomeData(Cluster cluster) {
        try {
            cluster.coreTx(ClusterHelper::createSomeData);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return DbRepresentation.of((GraphDatabaseService)OnlineBackupCommandCcIT.clusterLeader(cluster).database());
    }

    private static CoreClusterMember clusterLeader(Cluster cluster) {
        return cluster.getMemberWithRole(Role.LEADER);
    }

    public static DbRepresentation getBackupDbRepresentation(String name, File backupDir) {
        Config config = Config.defaults();
        config.augment(OnlineBackupSettings.online_backup_enabled, "false");
        return DbRepresentation.of((File)new File(backupDir, name), (Config)config);
    }

    private int runBackupToolFromOtherJvmToGetExitCode(PrintStream outputStream, PrintStream errorStream, String ... args) throws Exception {
        return TestHelpers.runBackupToolFromOtherJvmToGetExitCode((File)this.testDirectory.absolutePath(), (PrintStream)outputStream, (PrintStream)errorStream, (boolean)false, (String[])args);
    }

    private int runBackupToolFromOtherJvmToGetExitCode(String ... args) throws Exception {
        return TestHelpers.runBackupToolFromOtherJvmToGetExitCode((File)this.testDirectory.absolutePath(), (String[])args);
    }

    private int runBackupToolFromSameJvm(String ... args) throws Exception {
        return OnlineBackupCommandCcIT.runBackupToolFromSameJvmToGetExitCode(this.testDirectory.absolutePath(), this.testDirectory.absolutePath().getName(), args);
    }

    public static int runBackupToolFromSameJvmToGetExitCode(File backupDir, String backupName, String ... args) throws Exception {
        return new OnlineBackupCommandBuilder().withRawArgs(args).backup(backupDir, backupName) ? 0 : 1;
    }
}

