/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.backup.impl;

import java.io.IOException;
import java.nio.file.Path;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.InOrder;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.neo4j.backup.impl.BackupCopyService;
import org.neo4j.backup.impl.BackupRecoveryService;
import org.neo4j.backup.impl.BackupStageOutcome;
import org.neo4j.backup.impl.BackupStrategy;
import org.neo4j.backup.impl.BackupStrategyOutcome;
import org.neo4j.backup.impl.BackupStrategyWrapper;
import org.neo4j.backup.impl.Fallible;
import org.neo4j.backup.impl.OnlineBackupContext;
import org.neo4j.backup.impl.OnlineBackupRequiredArguments;
import org.neo4j.backup.impl.SelectedBackupProtocol;
import org.neo4j.commandline.admin.OutsideWorld;
import org.neo4j.consistency.checking.full.ConsistencyFlags;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.util.OptionalHostnamePort;
import org.neo4j.logging.Log;
import org.neo4j.logging.LogProvider;
import org.neo4j.test.rule.TestDirectory;

public class BackupStrategyWrapperTest {
    @Rule
    public TestDirectory testDirectory = TestDirectory.testDirectory();
    private BackupStrategy backupStrategyImplementation = (BackupStrategy)Mockito.mock(BackupStrategy.class);
    private OutsideWorld outsideWorld = (OutsideWorld)Mockito.mock(OutsideWorld.class);
    private BackupCopyService backupCopyService = (BackupCopyService)Mockito.mock(BackupCopyService.class);
    private BackupStrategyWrapper subject;
    private OnlineBackupContext onlineBackupContext;
    private FileSystemAbstraction fileSystemAbstraction = (FileSystemAbstraction)Mockito.mock(FileSystemAbstraction.class);
    private Path desiredBackupLocation;
    private Path reportDir;
    private Path availableFreshBackupLocation = (Path)Mockito.mock(Path.class, (String)"Path<availableFreshBackupLocation>");
    private Path availableOldBackupLocation = (Path)Mockito.mock(Path.class, (String)"Path<availableOldBackupLocation>");
    private OnlineBackupRequiredArguments requiredArguments;
    private Config config = (Config)Mockito.mock(Config.class);
    private OptionalHostnamePort userProvidedAddress = new OptionalHostnamePort((String)null, null, null);
    private Fallible<BackupStageOutcome> SUCCESS = new Fallible((Object)BackupStageOutcome.SUCCESS, null);
    private Fallible<BackupStageOutcome> FAILURE = new Fallible((Object)BackupStageOutcome.FAILURE, null);
    private PageCache pageCache = (PageCache)Mockito.mock(PageCache.class);
    private BackupRecoveryService backupRecoveryService = (BackupRecoveryService)Mockito.mock(BackupRecoveryService.class);
    private LogProvider logProvider = (LogProvider)Mockito.mock(LogProvider.class);
    private Log log = (Log)Mockito.mock(Log.class);

    @Before
    public void setup() {
        this.desiredBackupLocation = this.testDirectory.directory("desiredBackupLocation").toPath();
        this.reportDir = this.testDirectory.directory("reportDir").toPath();
        Mockito.when((Object)this.outsideWorld.fileSystem()).thenReturn((Object)this.fileSystemAbstraction);
        Mockito.when((Object)this.backupCopyService.findAnAvailableLocationForNewFullBackup((Path)ArgumentMatchers.any())).thenReturn((Object)this.availableFreshBackupLocation);
        Mockito.when((Object)this.backupCopyService.findNewBackupLocationForBrokenExisting((Path)ArgumentMatchers.any())).thenReturn((Object)this.availableOldBackupLocation);
        Mockito.when((Object)this.backupStrategyImplementation.performFullBackup((Path)ArgumentMatchers.any(), (Config)ArgumentMatchers.any(), (OptionalHostnamePort)ArgumentMatchers.any())).thenReturn(this.SUCCESS);
        Mockito.when((Object)this.logProvider.getLog((Class)ArgumentMatchers.any())).thenReturn((Object)this.log);
        this.subject = new BackupStrategyWrapper(this.backupStrategyImplementation, this.backupCopyService, this.pageCache, this.config, this.backupRecoveryService, this.logProvider);
    }

    @Test
    public void lifecycleIsRun() throws Throwable {
        this.onlineBackupContext = new OnlineBackupContext(this.requiredArguments(true), this.config, BackupStrategyWrapperTest.consistencyFlags());
        this.subject.doBackup(this.onlineBackupContext);
        ((BackupStrategy)Mockito.verify((Object)this.backupStrategyImplementation)).init();
        ((BackupStrategy)Mockito.verify((Object)this.backupStrategyImplementation)).start();
        ((BackupStrategy)Mockito.verify((Object)this.backupStrategyImplementation)).stop();
        ((BackupStrategy)Mockito.verify((Object)this.backupStrategyImplementation)).shutdown();
    }

    @Test
    public void fullBackupIsPerformedWhenNoOtherBackupExists() {
        this.requiredArguments = this.requiredArguments(true);
        this.onlineBackupContext = new OnlineBackupContext(this.requiredArguments, this.config, BackupStrategyWrapperTest.consistencyFlags());
        Mockito.when((Object)this.backupCopyService.backupExists((Path)ArgumentMatchers.any())).thenReturn((Object)false);
        this.subject.doBackup(this.onlineBackupContext);
        ((BackupStrategy)Mockito.verify((Object)this.backupStrategyImplementation)).performFullBackup((Path)ArgumentMatchers.any(), (Config)ArgumentMatchers.any(), (OptionalHostnamePort)ArgumentMatchers.any());
    }

    @Test
    public void fullBackupIsIgnoredIfNoOtherBackupAndNotFallback() {
        Mockito.when((Object)this.backupCopyService.backupExists((Path)ArgumentMatchers.any())).thenReturn((Object)false);
        this.requiredArguments = this.requiredArguments(false);
        this.onlineBackupContext = new OnlineBackupContext(this.requiredArguments, this.config, BackupStrategyWrapperTest.consistencyFlags());
        Mockito.when((Object)this.backupStrategyImplementation.performIncrementalBackup((Path)ArgumentMatchers.any(), (Config)ArgumentMatchers.any(), (OptionalHostnamePort)ArgumentMatchers.any())).thenReturn(this.FAILURE);
        this.subject.doBackup(this.onlineBackupContext);
        ((BackupStrategy)Mockito.verify((Object)this.backupStrategyImplementation, (VerificationMode)Mockito.never())).performFullBackup((Path)ArgumentMatchers.any(), (Config)ArgumentMatchers.any(), (OptionalHostnamePort)ArgumentMatchers.any());
    }

    @Test
    public void fullBackupIsNotPerformedWhenAnIncrementalBackupIsSuccessful() {
        Mockito.when((Object)this.backupCopyService.backupExists((Path)ArgumentMatchers.any())).thenReturn((Object)true);
        Mockito.when((Object)this.backupStrategyImplementation.performIncrementalBackup((Path)ArgumentMatchers.any(), (Config)ArgumentMatchers.any(), (OptionalHostnamePort)ArgumentMatchers.any())).thenReturn(this.SUCCESS);
        this.requiredArguments = this.requiredArguments(true);
        this.onlineBackupContext = new OnlineBackupContext(this.requiredArguments, this.config, BackupStrategyWrapperTest.consistencyFlags());
        this.subject.doBackup(this.onlineBackupContext);
        ((BackupStrategy)Mockito.verify((Object)this.backupStrategyImplementation, (VerificationMode)Mockito.never())).performFullBackup(this.desiredBackupLocation, this.config, this.userProvidedAddress);
    }

    @Test
    public void failedIncrementalFallsBackToFullWhenOptionSet() {
        Mockito.when((Object)this.backupCopyService.backupExists((Path)ArgumentMatchers.any())).thenReturn((Object)true);
        this.requiredArguments = this.requiredArguments(true);
        this.onlineBackupContext = new OnlineBackupContext(this.requiredArguments, this.config, BackupStrategyWrapperTest.consistencyFlags());
        Mockito.when((Object)this.backupStrategyImplementation.performIncrementalBackup((Path)ArgumentMatchers.any(), (Config)ArgumentMatchers.any(), (OptionalHostnamePort)ArgumentMatchers.any())).thenReturn((Object)new Fallible((Object)BackupStageOutcome.FAILURE, null));
        this.subject.doBackup(this.onlineBackupContext);
        ((BackupStrategy)Mockito.verify((Object)this.backupStrategyImplementation)).performFullBackup((Path)ArgumentMatchers.any(), (Config)ArgumentMatchers.any(), (OptionalHostnamePort)ArgumentMatchers.any());
    }

    @Test
    public void fallbackDoesNotHappenIfNotSpecified() {
        Mockito.when((Object)this.backupCopyService.backupExists((Path)ArgumentMatchers.any())).thenReturn((Object)true);
        Mockito.when((Object)this.backupStrategyImplementation.performIncrementalBackup((Path)ArgumentMatchers.any(), (Config)ArgumentMatchers.any(), (OptionalHostnamePort)ArgumentMatchers.any())).thenReturn((Object)new Fallible((Object)BackupStageOutcome.FAILURE, null));
        this.requiredArguments = this.requiredArguments(false);
        this.onlineBackupContext = new OnlineBackupContext(this.requiredArguments, this.config, BackupStrategyWrapperTest.consistencyFlags());
        this.subject.doBackup(this.onlineBackupContext);
        ((BackupStrategy)Mockito.verify((Object)this.backupStrategyImplementation, (VerificationMode)Mockito.never())).performFullBackup((Path)ArgumentMatchers.any(), (Config)ArgumentMatchers.any(), (OptionalHostnamePort)ArgumentMatchers.any());
    }

    @Test
    public void failedBackupsDontMoveExisting() throws IOException {
        Mockito.when((Object)this.backupCopyService.backupExists((Path)ArgumentMatchers.any())).thenReturn((Object)true);
        this.requiredArguments = this.requiredArguments(true);
        this.onlineBackupContext = new OnlineBackupContext(this.requiredArguments, this.config, BackupStrategyWrapperTest.consistencyFlags());
        Mockito.when((Object)this.backupStrategyImplementation.performIncrementalBackup((Path)ArgumentMatchers.any(), (Config)ArgumentMatchers.any(), (OptionalHostnamePort)ArgumentMatchers.any())).thenReturn((Object)new Fallible((Object)BackupStageOutcome.FAILURE, null));
        Mockito.when((Object)this.backupStrategyImplementation.performFullBackup((Path)ArgumentMatchers.any(), (Config)ArgumentMatchers.any(), (OptionalHostnamePort)ArgumentMatchers.any())).thenReturn((Object)new Fallible((Object)BackupStageOutcome.FAILURE, null));
        this.subject.doBackup(this.onlineBackupContext);
        ((BackupStrategy)Mockito.verify((Object)this.backupStrategyImplementation)).performFullBackup((Path)ArgumentMatchers.any(), (Config)ArgumentMatchers.any(), (OptionalHostnamePort)ArgumentMatchers.any());
        ((BackupCopyService)Mockito.verify((Object)this.backupCopyService, (VerificationMode)Mockito.never())).moveBackupLocation((Path)ArgumentMatchers.any(), (Path)ArgumentMatchers.any());
    }

    @Test
    public void successfulFullBackupsMoveExistingBackup() throws IOException {
        this.desiredBackupLocation = this.testDirectory.directory("some-preexisting-backup").toPath();
        Mockito.when((Object)this.backupCopyService.backupExists(this.desiredBackupLocation)).thenReturn((Object)true);
        this.requiredArguments = this.requiredArguments(true);
        this.onlineBackupContext = new OnlineBackupContext(this.requiredArguments, this.config, BackupStrategyWrapperTest.consistencyFlags());
        Path newLocationForExistingBackup = this.testDirectory.directory("new-backup-location").toPath();
        Mockito.when((Object)this.backupCopyService.findNewBackupLocationForBrokenExisting(this.desiredBackupLocation)).thenReturn((Object)newLocationForExistingBackup);
        Path temporaryFullBackupLocation = this.testDirectory.directory("temporary-full-backup").toPath();
        Mockito.when((Object)this.backupCopyService.findAnAvailableLocationForNewFullBackup(this.desiredBackupLocation)).thenReturn((Object)temporaryFullBackupLocation);
        Mockito.when((Object)this.backupStrategyImplementation.performIncrementalBackup((Path)ArgumentMatchers.any(), (Config)ArgumentMatchers.any(), (OptionalHostnamePort)ArgumentMatchers.any())).thenReturn((Object)new Fallible((Object)BackupStageOutcome.FAILURE, null));
        Mockito.when((Object)this.backupStrategyImplementation.performFullBackup((Path)ArgumentMatchers.any(), (Config)ArgumentMatchers.any(), (OptionalHostnamePort)ArgumentMatchers.any())).thenReturn((Object)new Fallible((Object)BackupStageOutcome.SUCCESS, null));
        Fallible state = this.subject.doBackup(this.onlineBackupContext);
        ((BackupCopyService)Mockito.verify((Object)this.backupCopyService)).moveBackupLocation((Path)ArgumentMatchers.eq((Object)this.desiredBackupLocation), (Path)ArgumentMatchers.eq((Object)newLocationForExistingBackup));
        ((BackupCopyService)Mockito.verify((Object)this.backupCopyService)).moveBackupLocation((Path)ArgumentMatchers.eq((Object)temporaryFullBackupLocation), (Path)ArgumentMatchers.eq((Object)this.desiredBackupLocation));
        Assert.assertEquals((Object)BackupStrategyOutcome.SUCCESS, (Object)state.getState());
    }

    @Test
    public void failureDuringMoveCausesAbsoluteFailure() throws IOException {
        ((BackupCopyService)Mockito.doThrow(IOException.class).when((Object)this.backupCopyService)).moveBackupLocation((Path)ArgumentMatchers.any(), (Path)ArgumentMatchers.any());
        this.requiredArguments = this.requiredArguments(true);
        this.onlineBackupContext = new OnlineBackupContext(this.requiredArguments, this.config, BackupStrategyWrapperTest.consistencyFlags());
        Mockito.when((Object)this.backupCopyService.backupExists((Path)ArgumentMatchers.any())).thenReturn((Object)true);
        Mockito.when((Object)this.backupStrategyImplementation.performIncrementalBackup((Path)ArgumentMatchers.any(), (Config)ArgumentMatchers.any(), (OptionalHostnamePort)ArgumentMatchers.any())).thenReturn((Object)new Fallible((Object)BackupStageOutcome.FAILURE, null));
        Mockito.when((Object)this.backupStrategyImplementation.performFullBackup((Path)ArgumentMatchers.any(), (Config)ArgumentMatchers.any(), (OptionalHostnamePort)ArgumentMatchers.any())).thenReturn((Object)new Fallible((Object)BackupStageOutcome.SUCCESS, null));
        Fallible state = this.subject.doBackup(this.onlineBackupContext);
        Assert.assertEquals((Object)BackupStrategyOutcome.ABSOLUTE_FAILURE, (Object)state.getState());
        Assert.assertEquals(IOException.class, ((Throwable)state.getCause().get()).getClass());
        ((BackupStrategy)Mockito.verify((Object)this.backupStrategyImplementation)).performFullBackup((Path)ArgumentMatchers.any(), (Config)ArgumentMatchers.any(), (OptionalHostnamePort)ArgumentMatchers.any());
    }

    @Test
    public void performingFullBackupInvokesRecovery() {
        this.requiredArguments = this.requiredArguments(true);
        this.onlineBackupContext = new OnlineBackupContext(this.requiredArguments, this.config, BackupStrategyWrapperTest.consistencyFlags());
        this.subject.doBackup(this.onlineBackupContext);
        ((BackupRecoveryService)Mockito.verify((Object)this.backupRecoveryService)).recoverWithDatabase((Path)ArgumentMatchers.any(), (PageCache)ArgumentMatchers.any(), (Config)ArgumentMatchers.any());
    }

    @Test
    public void performingIncrementalBackupDoesNotInvokeRecovery() {
        Mockito.when((Object)this.backupCopyService.backupExists((Path)ArgumentMatchers.any())).thenReturn((Object)true);
        this.requiredArguments = this.requiredArguments(true);
        this.onlineBackupContext = new OnlineBackupContext(this.requiredArguments, this.config, BackupStrategyWrapperTest.consistencyFlags());
        Mockito.when((Object)this.backupStrategyImplementation.performIncrementalBackup((Path)ArgumentMatchers.any(), (Config)ArgumentMatchers.any(), (OptionalHostnamePort)ArgumentMatchers.any())).thenReturn(this.SUCCESS);
        this.subject.doBackup(this.onlineBackupContext);
        ((BackupRecoveryService)Mockito.verify((Object)this.backupRecoveryService, (VerificationMode)Mockito.never())).recoverWithDatabase((Path)ArgumentMatchers.any(), (PageCache)ArgumentMatchers.any(), (Config)ArgumentMatchers.any());
    }

    @Test
    public void successfulBackupsAreRecovered() {
        this.fallbackToFullPasses();
        this.onlineBackupContext = new OnlineBackupContext(this.requiredArguments, this.config, BackupStrategyWrapperTest.consistencyFlags());
        this.subject.doBackup(this.onlineBackupContext);
        ((BackupRecoveryService)Mockito.verify((Object)this.backupRecoveryService)).recoverWithDatabase((Path)ArgumentMatchers.any(), (PageCache)ArgumentMatchers.any(), (Config)ArgumentMatchers.any());
    }

    @Test
    public void unsuccessfulBackupsAreNotRecovered() {
        this.bothBackupsFail();
        this.onlineBackupContext = new OnlineBackupContext(this.requiredArguments, this.config, BackupStrategyWrapperTest.consistencyFlags());
        this.subject.doBackup(this.onlineBackupContext);
        ((BackupRecoveryService)Mockito.verify((Object)this.backupRecoveryService, (VerificationMode)Mockito.never())).recoverWithDatabase((Path)ArgumentMatchers.any(), (PageCache)ArgumentMatchers.any(), (Config)ArgumentMatchers.any());
    }

    @Test
    public void successfulFullBackupsAreRecoveredEvenIfNoBackupExisted() {
        Mockito.when((Object)this.backupCopyService.backupExists(this.desiredBackupLocation)).thenReturn((Object)false);
        Mockito.when((Object)this.backupCopyService.findAnAvailableLocationForNewFullBackup(this.desiredBackupLocation)).thenReturn((Object)this.desiredBackupLocation);
        this.fallbackToFullPasses();
        this.onlineBackupContext = new OnlineBackupContext(this.requiredArguments, this.config, BackupStrategyWrapperTest.consistencyFlags());
        this.subject.doBackup(this.onlineBackupContext);
        ((BackupRecoveryService)Mockito.verify((Object)this.backupRecoveryService)).recoverWithDatabase((Path)ArgumentMatchers.any(), (PageCache)ArgumentMatchers.any(), (Config)ArgumentMatchers.any());
    }

    @Test
    public void recoveryIsPerformedBeforeRename() throws IOException {
        this.fallbackToFullPasses();
        this.onlineBackupContext = new OnlineBackupContext(this.requiredArguments, this.config, BackupStrategyWrapperTest.consistencyFlags());
        this.subject.doBackup(this.onlineBackupContext);
        InOrder recoveryBeforeRenameOrder = Mockito.inOrder((Object[])new Object[]{this.backupRecoveryService, this.backupCopyService});
        ((BackupRecoveryService)recoveryBeforeRenameOrder.verify((Object)this.backupRecoveryService)).recoverWithDatabase((Path)ArgumentMatchers.eq((Object)this.availableFreshBackupLocation), (PageCache)ArgumentMatchers.any(), (Config)ArgumentMatchers.any());
        ((BackupCopyService)recoveryBeforeRenameOrder.verify((Object)this.backupCopyService)).moveBackupLocation((Path)ArgumentMatchers.eq((Object)this.availableFreshBackupLocation), (Path)ArgumentMatchers.eq((Object)this.desiredBackupLocation));
    }

    @Test
    public void logsAreClearedAfterIncrementalBackup() throws IOException {
        Mockito.when((Object)this.backupCopyService.backupExists((Path)ArgumentMatchers.any())).thenReturn((Object)true);
        this.incrementalBackupIsSuccessful(true);
        this.requiredArguments = this.requiredArguments(false);
        this.onlineBackupContext = new OnlineBackupContext(this.requiredArguments, this.config, BackupStrategyWrapperTest.consistencyFlags());
        this.subject.doBackup(this.onlineBackupContext);
        ((BackupCopyService)Mockito.verify((Object)this.backupCopyService)).clearIdFiles((Path)ArgumentMatchers.any());
    }

    @Test
    public void logsAreNotClearedWhenIncrementalNotSuccessful() throws IOException {
        Mockito.when((Object)this.backupCopyService.backupExists((Path)ArgumentMatchers.any())).thenReturn((Object)true);
        this.incrementalBackupIsSuccessful(false);
        this.requiredArguments = this.requiredArguments(false);
        this.onlineBackupContext = new OnlineBackupContext(this.requiredArguments, this.config, BackupStrategyWrapperTest.consistencyFlags());
        this.subject.doBackup(this.onlineBackupContext);
        ((BackupCopyService)Mockito.verify((Object)this.backupCopyService, (VerificationMode)Mockito.never())).clearIdFiles((Path)ArgumentMatchers.any());
    }

    @Test
    public void logsAreClearedWhenFullBackupIsSuccessful() throws IOException {
        Mockito.when((Object)this.backupCopyService.backupExists((Path)ArgumentMatchers.any())).thenReturn((Object)false);
        this.fallbackToFullPasses();
        this.onlineBackupContext = new OnlineBackupContext(this.requiredArguments, this.config, BackupStrategyWrapperTest.consistencyFlags());
        this.subject.doBackup(this.onlineBackupContext);
        ((BackupCopyService)Mockito.verify((Object)this.backupCopyService)).clearIdFiles((Path)ArgumentMatchers.any());
    }

    @Test
    public void logsAreNotClearedWhenFullBackupIsNotSuccessful() throws IOException {
        Mockito.when((Object)this.backupCopyService.backupExists((Path)ArgumentMatchers.any())).thenReturn((Object)false);
        this.bothBackupsFail();
        this.onlineBackupContext = new OnlineBackupContext(this.requiredArguments, this.config, BackupStrategyWrapperTest.consistencyFlags());
        this.subject.doBackup(this.onlineBackupContext);
        ((BackupCopyService)Mockito.verify((Object)this.backupCopyService, (VerificationMode)Mockito.never())).clearIdFiles((Path)ArgumentMatchers.any());
    }

    @Test
    public void logsWhenIncrementalFailsAndFallbackToFull() {
        Mockito.when((Object)this.backupCopyService.backupExists((Path)ArgumentMatchers.any())).thenReturn((Object)false);
        this.fallbackToFullPasses();
        this.onlineBackupContext = new OnlineBackupContext(this.requiredArguments, this.config, BackupStrategyWrapperTest.consistencyFlags());
        this.subject.doBackup(this.onlineBackupContext);
        ((Log)Mockito.verify((Object)this.log)).info("Previous backup not found, a new full backup will be performed.");
    }

    private void incrementalBackupIsSuccessful(boolean isSuccessful) {
        if (isSuccessful) {
            Mockito.when((Object)this.backupStrategyImplementation.performIncrementalBackup((Path)ArgumentMatchers.any(), (Config)ArgumentMatchers.any(), (OptionalHostnamePort)ArgumentMatchers.any())).thenReturn((Object)new Fallible((Object)BackupStageOutcome.SUCCESS, null));
            return;
        }
        Mockito.when((Object)this.backupStrategyImplementation.performIncrementalBackup((Path)ArgumentMatchers.any(), (Config)ArgumentMatchers.any(), (OptionalHostnamePort)ArgumentMatchers.any())).thenReturn((Object)new Fallible((Object)BackupStageOutcome.FAILURE, null));
    }

    private void bothBackupsFail() {
        this.requiredArguments = this.requiredArguments(true);
        Mockito.when((Object)this.backupStrategyImplementation.performIncrementalBackup((Path)ArgumentMatchers.any(), (Config)ArgumentMatchers.any(), (OptionalHostnamePort)ArgumentMatchers.any())).thenReturn(this.FAILURE);
        Mockito.when((Object)this.backupStrategyImplementation.performFullBackup((Path)ArgumentMatchers.any(), (Config)ArgumentMatchers.any(), (OptionalHostnamePort)ArgumentMatchers.any())).thenReturn(this.FAILURE);
    }

    private void fallbackToFullPasses() {
        this.requiredArguments = this.requiredArguments(true);
        Mockito.when((Object)this.backupStrategyImplementation.performIncrementalBackup((Path)ArgumentMatchers.any(), (Config)ArgumentMatchers.any(), (OptionalHostnamePort)ArgumentMatchers.any())).thenReturn(this.FAILURE);
        Mockito.when((Object)this.backupStrategyImplementation.performFullBackup((Path)ArgumentMatchers.any(), (Config)ArgumentMatchers.any(), (OptionalHostnamePort)ArgumentMatchers.any())).thenReturn(this.SUCCESS);
    }

    private OnlineBackupRequiredArguments requiredArguments(boolean fallbackToFull) {
        return new OnlineBackupRequiredArguments(this.userProvidedAddress, this.desiredBackupLocation.getParent(), this.desiredBackupLocation.getFileName().toString(), SelectedBackupProtocol.ANY, fallbackToFull, true, 1000L, this.reportDir);
    }

    private static ConsistencyFlags consistencyFlags() {
        return new ConsistencyFlags(true, true, true, true);
    }
}

