/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.backup.impl;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.neo4j.backup.impl.BackupOutputMonitor;
import org.neo4j.backup.impl.OnlineBackupCommandCcIT;
import org.neo4j.com.storecopy.StoreCopyClientMonitor;
import org.neo4j.commandline.admin.OutsideWorld;
import org.neo4j.commandline.admin.ParameterisedOutsideWorld;
import org.neo4j.io.fs.DefaultFileSystemAbstraction;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.kernel.monitoring.Monitors;

public class BackupOutputMonitorTest {
    Monitors monitors = new Monitors();
    OutsideWorld outsideWorld;
    ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
    PrintStream outputStream = OnlineBackupCommandCcIT.wrapWithNormalOutput(System.out, new PrintStream(this.byteArrayOutputStream));
    ByteArrayOutputStream byteArrayErrorStream = new ByteArrayOutputStream();
    PrintStream errorStream = OnlineBackupCommandCcIT.wrapWithNormalOutput(System.err, new PrintStream(this.byteArrayErrorStream));

    @Before
    public void setup() {
        this.outsideWorld = new ParameterisedOutsideWorld(System.console(), (OutputStream)this.outputStream, (OutputStream)this.errorStream, System.in, (FileSystemAbstraction)new DefaultFileSystemAbstraction());
    }

    @Test
    public void receivingStoreFilesMessageCorrect() {
        this.monitors.addMonitorListener((Object)new BackupOutputMonitor(this.outsideWorld), new String[0]);
        StoreCopyClientMonitor storeCopyClientMonitor = (StoreCopyClientMonitor)this.monitors.newMonitor(StoreCopyClientMonitor.class, new String[0]);
        storeCopyClientMonitor.startReceivingStoreFiles();
        Assert.assertTrue((boolean)this.byteArrayOutputStream.toString().contains("Start receiving store files"));
    }
}

