/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.backup.impl;

import java.util.function.Supplier;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.neo4j.backup.impl.BackupImpl;
import org.neo4j.com.RequestContext;
import org.neo4j.com.storecopy.StoreCopyServer;
import org.neo4j.com.storecopy.StoreWriter;
import org.neo4j.kernel.impl.store.StoreId;
import org.neo4j.kernel.impl.transaction.log.LogFileInformation;
import org.neo4j.kernel.impl.transaction.log.LogicalTransactionStore;
import org.neo4j.kernel.impl.transaction.log.TransactionIdStore;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.NullLogProvider;

public class BackupImplTest {
    @Test
    public void flushStoreFilesWithCorrectCheckpointTriggerName() {
        StoreCopyServer storeCopyServer = (StoreCopyServer)Mockito.mock(StoreCopyServer.class);
        Mockito.when((Object)storeCopyServer.flushStoresAndStreamStoreFiles(ArgumentMatchers.anyString(), (StoreWriter)ArgumentMatchers.any(StoreWriter.class), ArgumentMatchers.anyBoolean())).thenReturn((Object)RequestContext.EMPTY);
        BackupImpl backup = new BackupImpl(storeCopyServer, (LogicalTransactionStore)Mockito.mock(LogicalTransactionStore.class), (TransactionIdStore)Mockito.mock(TransactionIdStore.class), (LogFileInformation)Mockito.mock(LogFileInformation.class), BackupImplTest.defaultStoreIdSupplier(), (LogProvider)NullLogProvider.getInstance());
        backup.fullBackup((StoreWriter)Mockito.mock(StoreWriter.class), false).close();
        ((StoreCopyServer)Mockito.verify((Object)storeCopyServer)).flushStoresAndStreamStoreFiles((String)ArgumentMatchers.eq((Object)"full backup"), (StoreWriter)ArgumentMatchers.any(StoreWriter.class), ArgumentMatchers.eq((boolean)false));
    }

    private static Supplier<StoreId> defaultStoreIdSupplier() {
        return () -> StoreId.DEFAULT;
    }
}

