/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.backup.impl;

import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.neo4j.backup.impl.BackupDelegator;
import org.neo4j.causalclustering.catchup.CatchUpClient;
import org.neo4j.causalclustering.catchup.CatchupAddressProvider;
import org.neo4j.causalclustering.catchup.CatchupAddressResolutionException;
import org.neo4j.causalclustering.catchup.storecopy.RemoteStore;
import org.neo4j.causalclustering.catchup.storecopy.StoreCopyClient;
import org.neo4j.causalclustering.catchup.storecopy.StoreCopyFailedException;
import org.neo4j.causalclustering.catchup.storecopy.StoreIdDownloadFailedException;
import org.neo4j.causalclustering.identity.StoreId;
import org.neo4j.helpers.AdvertisedSocketAddress;

public class BackupDelegatorTest {
    private RemoteStore remoteStore;
    private CatchUpClient catchUpClient;
    private StoreCopyClient storeCopyClient;
    BackupDelegator subject;
    private final AdvertisedSocketAddress anyAddress = new AdvertisedSocketAddress("any.address", 1234);

    @Before
    public void setup() {
        this.remoteStore = (RemoteStore)Mockito.mock(RemoteStore.class);
        this.catchUpClient = (CatchUpClient)Mockito.mock(CatchUpClient.class);
        this.storeCopyClient = (StoreCopyClient)Mockito.mock(StoreCopyClient.class);
        this.subject = new BackupDelegator(this.remoteStore, this.catchUpClient, this.storeCopyClient);
    }

    @Test
    public void tryCatchingUpDelegatesToRemoteStore() throws StoreCopyFailedException, IOException {
        AdvertisedSocketAddress fromAddress = new AdvertisedSocketAddress("neo4j.com", 5432);
        StoreId expectedStoreId = new StoreId(7L, 2L, 5L, 98L);
        Path storeDir = Paths.get("A directory to store transactions to", new String[0]);
        this.subject.tryCatchingUp(fromAddress, expectedStoreId, storeDir);
        ((RemoteStore)Mockito.verify((Object)this.remoteStore)).tryCatchingUp(fromAddress, expectedStoreId, storeDir.toFile(), true, true);
    }

    @Test
    public void startDelegatesToCatchUpClient() {
        this.subject.start();
        ((CatchUpClient)Mockito.verify((Object)this.catchUpClient)).start();
    }

    @Test
    public void stopDelegatesToCatchUpClient() {
        this.subject.stop();
        ((CatchUpClient)Mockito.verify((Object)this.catchUpClient)).stop();
    }

    @Test
    public void fetchStoreIdDelegatesToStoreCopyClient() throws StoreIdDownloadFailedException {
        AdvertisedSocketAddress fromAddress = new AdvertisedSocketAddress("neo4.com", 935);
        StoreId expectedStoreId = new StoreId(6L, 2L, 9L, 3L);
        Mockito.when((Object)this.storeCopyClient.fetchStoreId(fromAddress)).thenReturn((Object)expectedStoreId);
        StoreId storeId = this.subject.fetchStoreId(fromAddress);
        Assert.assertEquals((Object)expectedStoreId, (Object)storeId);
    }

    @Test
    public void retrieveStoreDelegatesToStoreCopyService() throws StoreCopyFailedException, CatchupAddressResolutionException {
        StoreId storeId = new StoreId(92L, 5L, 7L, 32L);
        Path anyFile = Paths.get("anywhere", new String[0]);
        this.subject.copy(this.anyAddress, storeId, anyFile);
        ArgumentCaptor argumentCaptor = ArgumentCaptor.forClass(CatchupAddressProvider.class);
        ((RemoteStore)Mockito.verify((Object)this.remoteStore)).copy((CatchupAddressProvider)argumentCaptor.capture(), (StoreId)ArgumentMatchers.eq((Object)storeId), (File)ArgumentMatchers.eq((Object)anyFile.toFile()), ArgumentMatchers.eq((boolean)true));
        Assert.assertEquals((Object)this.anyAddress, (Object)((CatchupAddressProvider)argumentCaptor.getValue()).primary());
    }
}

