/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.backup.impl;

import java.io.File;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.stream.Stream;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.neo4j.backup.impl.BackupCopyService;
import org.neo4j.com.storecopy.FileMoveAction;
import org.neo4j.com.storecopy.FileMoveProvider;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.test.rule.TestDirectory;

public class BackupCopyServiceTest {
    private FileMoveProvider fileMoveProvider;
    @Rule
    public TestDirectory testDirectory = TestDirectory.testDirectory();
    BackupCopyService subject;

    @Before
    public void setup() {
        PageCache pageCache = (PageCache)Mockito.mock(PageCache.class);
        this.fileMoveProvider = (FileMoveProvider)Mockito.mock(FileMoveProvider.class);
        FileSystemAbstraction fs = (FileSystemAbstraction)Mockito.mock(FileSystemAbstraction.class);
        this.subject = new BackupCopyService(fs, pageCache, this.fileMoveProvider);
    }

    @Test
    public void logicForMovingBackupsIsDelegatedToFileMovePropagator() throws IOException {
        Path parentDirectory = this.testDirectory.directory("parent").toPath();
        Path oldLocation = parentDirectory.resolve("oldLocation");
        Files.createDirectories(oldLocation, new FileAttribute[0]);
        Path newLocation = parentDirectory.resolve("newLocation");
        FileMoveAction fileOneMoveAction = (FileMoveAction)Mockito.mock(FileMoveAction.class);
        FileMoveAction fileTwoMoveAction = (FileMoveAction)Mockito.mock(FileMoveAction.class);
        Mockito.when((Object)this.fileMoveProvider.traverseForMoving((File)ArgumentMatchers.any())).thenReturn(Stream.of(fileOneMoveAction, fileTwoMoveAction));
        this.subject.moveBackupLocation(oldLocation, newLocation);
        ((FileMoveProvider)Mockito.verify((Object)this.fileMoveProvider)).traverseForMoving(oldLocation.toFile());
        ((FileMoveAction)Mockito.verify((Object)fileOneMoveAction)).move(newLocation.toFile(), new CopyOption[0]);
        ((FileMoveAction)Mockito.verify((Object)fileTwoMoveAction)).move(newLocation.toFile(), new CopyOption[0]);
    }
}

