/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.backup.impl;

import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.neo4j.backup.impl.AddressResolver;
import org.neo4j.helpers.HostnamePort;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.util.OptionalHostnamePort;

public class AddressResolverTest {
    AddressResolver subject;
    Config defaultConfig = Config.defaults();

    @Before
    public void setup() {
        this.subject = new AddressResolver();
    }

    @Test
    public void noPortResolvesToDefault_ha() {
        Integer portIsNotSupplied = null;
        HostnamePort resolved = this.subject.resolveCorrectHAAddress(this.defaultConfig, new OptionalHostnamePort("localhost", portIsNotSupplied, null));
        Assert.assertEquals((long)resolved.getPort(), (long)6362L);
    }

    @Test
    public void suppliedPortResolvesToGiven_ha() {
        Integer portIsSupplied = 1234;
        HostnamePort resolved = this.subject.resolveCorrectHAAddress(this.defaultConfig, new OptionalHostnamePort("localhost", portIsSupplied, null));
        Assert.assertEquals((long)resolved.getPort(), (long)portIsSupplied.intValue());
    }
}

