/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.backup;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.hamcrest.Description;
import org.hamcrest.TypeSafeMatcher;

public class ExceptionMatchers {
    public static TypeSafeMatcher<Throwable> exceptionContainsSuppressedThrowable(final Throwable expectedSuppressed) {
        return new TypeSafeMatcher<Throwable>(){

            protected boolean matchesSafely(Throwable item) {
                List<Throwable> suppress = Arrays.asList(item.getSuppressed());
                return suppress.contains(expectedSuppressed);
            }

            public void describeTo(Description description) {
                description.appendText("contains suppressed exception ").appendValue((Object)expectedSuppressed);
            }

            protected void describeMismatchSafely(Throwable item, Description mismatchDescription) {
                List suppressedExceptionStrings = Stream.of(item.getSuppressed()).map(x$0 -> ExceptionMatchers.exceptionWithMessageToString(x$0)).collect(Collectors.toList());
                mismatchDescription.appendText("exception ").appendValue((Object)item).appendText(" with suppressed ").appendValueList("[", ", ", "]", suppressedExceptionStrings).appendText(" does not contain ").appendValue((Object)ExceptionMatchers.exceptionWithMessageToString(expectedSuppressed));
            }
        };
    }

    private static String exceptionWithMessageToString(Throwable throwable) {
        return String.format("<%s:%s>", throwable.getClass(), throwable.getMessage());
    }
}

