/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.backup;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintStream;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Properties;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.neo4j.backup.BackupTool;
import org.neo4j.backup.impl.BackupClient;
import org.neo4j.backup.impl.BackupProtocolService;
import org.neo4j.backup.impl.ConsistencyCheck;
import org.neo4j.consistency.ConsistencyCheckSettings;
import org.neo4j.helpers.HostnamePort;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.test.rule.SuppressOutput;
import org.neo4j.test.rule.TestDirectory;
import org.neo4j.test.rule.system.SystemExitRule;

public class BackupToolTest {
    private SystemExitRule systemExitRule = SystemExitRule.none();
    private TestDirectory testDirectory = TestDirectory.testDirectory();
    private SuppressOutput suppressOutput = SuppressOutput.suppressAll();
    @Rule
    public RuleChain chain = RuleChain.outerRule((TestRule)this.suppressOutput).around((TestRule)this.testDirectory).around((TestRule)this.systemExitRule);

    @Test
    public void shouldToolFailureExceptionCauseExitCode() {
        this.systemExitRule.expectExit(1);
        BackupTool.exitFailure((String)"tool failed");
    }

    @Test
    public void shouldBackupToolMainCauseExitCode() {
        this.systemExitRule.expectExit(1);
        BackupTool.main((String[])new String[0]);
    }

    @Test
    public void shouldUseIncrementalOrFallbackToFull() throws Exception {
        String[] args = new String[]{"-host", "localhost", "-to", "my_backup"};
        BackupProtocolService service = (BackupProtocolService)Mockito.mock(BackupProtocolService.class);
        PrintStream systemOut = (PrintStream)Mockito.mock(PrintStream.class);
        new BackupTool(service, systemOut).run(args);
        ((BackupProtocolService)Mockito.verify((Object)service)).doIncrementalBackupOrFallbackToFull((String)ArgumentMatchers.eq((Object)"localhost"), ArgumentMatchers.eq((int)6362), (Path)ArgumentMatchers.eq((Object)Paths.get("my_backup", new String[0])), (ConsistencyCheck)ArgumentMatchers.eq((Object)ConsistencyCheck.FULL), (Config)ArgumentMatchers.any(Config.class), ArgumentMatchers.eq((long)BackupClient.BIG_READ_TIMEOUT), ArgumentMatchers.eq((boolean)false));
        ((PrintStream)Mockito.verify((Object)systemOut)).println("Performing backup from '" + new HostnamePort("localhost", 6362) + "'");
        ((PrintStream)Mockito.verify((Object)systemOut)).println("Done");
    }

    @Test
    public void shouldResetTimeout() throws Exception {
        String newTimeout = "3";
        long expectedTimeout = 3000L;
        String[] args = new String[]{"-host", "localhost", "-to", "my_backup", "-timeout", newTimeout};
        BackupProtocolService service = (BackupProtocolService)Mockito.mock(BackupProtocolService.class);
        PrintStream systemOut = (PrintStream)Mockito.mock(PrintStream.class);
        new BackupTool(service, systemOut).run(args);
        ((BackupProtocolService)Mockito.verify((Object)service)).doIncrementalBackupOrFallbackToFull((String)ArgumentMatchers.eq((Object)"localhost"), ArgumentMatchers.eq((int)6362), (Path)ArgumentMatchers.eq((Object)Paths.get("my_backup", new String[0])), (ConsistencyCheck)ArgumentMatchers.eq((Object)ConsistencyCheck.FULL), (Config)ArgumentMatchers.any(Config.class), ArgumentMatchers.eq((long)expectedTimeout), ArgumentMatchers.eq((boolean)false));
        ((PrintStream)Mockito.verify((Object)systemOut)).println("Performing backup from '" + new HostnamePort("localhost", 6362) + "'");
        ((PrintStream)Mockito.verify((Object)systemOut)).println("Done");
    }

    @Test
    public void shouldIgnoreIncrementalFlag() throws Exception {
        String[] args = new String[]{"-incremental", "-host", "localhost", "-to", "my_backup"};
        BackupProtocolService service = (BackupProtocolService)Mockito.mock(BackupProtocolService.class);
        PrintStream systemOut = (PrintStream)Mockito.mock(PrintStream.class);
        new BackupTool(service, systemOut).run(args);
        ((BackupProtocolService)Mockito.verify((Object)service)).doIncrementalBackupOrFallbackToFull((String)ArgumentMatchers.eq((Object)"localhost"), ArgumentMatchers.eq((int)6362), (Path)ArgumentMatchers.eq((Object)Paths.get("my_backup", new String[0])), (ConsistencyCheck)ArgumentMatchers.eq((Object)ConsistencyCheck.FULL), (Config)ArgumentMatchers.any(Config.class), ArgumentMatchers.eq((long)BackupClient.BIG_READ_TIMEOUT), ArgumentMatchers.eq((boolean)false));
        ((PrintStream)Mockito.verify((Object)systemOut)).println("Performing backup from '" + new HostnamePort("localhost", 6362) + "'");
        ((PrintStream)Mockito.verify((Object)systemOut)).println("Done");
    }

    @Test
    public void shouldIgnoreFullFlag() throws Exception {
        String[] args = new String[]{"-full", "-host", "localhost", "-to", "my_backup"};
        BackupProtocolService service = (BackupProtocolService)Mockito.mock(BackupProtocolService.class);
        PrintStream systemOut = (PrintStream)Mockito.mock(PrintStream.class);
        new BackupTool(service, systemOut).run(args);
        ((BackupProtocolService)Mockito.verify((Object)service)).doIncrementalBackupOrFallbackToFull((String)ArgumentMatchers.eq((Object)"localhost"), ArgumentMatchers.eq((int)6362), (Path)ArgumentMatchers.eq((Object)Paths.get("my_backup", new String[0])), (ConsistencyCheck)ArgumentMatchers.eq((Object)ConsistencyCheck.FULL), (Config)ArgumentMatchers.any(Config.class), ArgumentMatchers.eq((long)BackupClient.BIG_READ_TIMEOUT), ArgumentMatchers.eq((boolean)false));
        ((PrintStream)Mockito.verify((Object)systemOut)).println("Performing backup from '" + new HostnamePort("localhost", 6362) + "'");
        ((PrintStream)Mockito.verify((Object)systemOut)).println("Done");
    }

    @Test
    public void appliesDefaultTuningConfigurationForConsistencyChecker() throws Exception {
        String[] args = new String[]{"-host", "localhost", "-to", "my_backup"};
        BackupProtocolService service = (BackupProtocolService)Mockito.mock(BackupProtocolService.class);
        PrintStream systemOut = (PrintStream)Mockito.mock(PrintStream.class);
        new BackupTool(service, systemOut).run(args);
        ArgumentCaptor config = ArgumentCaptor.forClass(Config.class);
        ((BackupProtocolService)Mockito.verify((Object)service)).doIncrementalBackupOrFallbackToFull(ArgumentMatchers.anyString(), ArgumentMatchers.anyInt(), (Path)ArgumentMatchers.eq((Object)Paths.get("my_backup", new String[0])), (ConsistencyCheck)ArgumentMatchers.any(ConsistencyCheck.class), (Config)config.capture(), ArgumentMatchers.eq((long)BackupClient.BIG_READ_TIMEOUT), ArgumentMatchers.eq((boolean)false));
        Assert.assertFalse((boolean)((Boolean)((Config)config.getValue()).get(ConsistencyCheckSettings.consistency_check_property_owners)));
    }

    @Test
    public void passesOnConfigurationIfProvided() throws Exception {
        File configFile = this.testDirectory.file("neo4j.conf");
        Properties properties = new Properties();
        properties.setProperty(ConsistencyCheckSettings.consistency_check_property_owners.name(), "true");
        properties.store(new FileWriter(configFile), null);
        String[] args = new String[]{"-host", "localhost", "-to", "my_backup", "-config", configFile.getPath()};
        BackupProtocolService service = (BackupProtocolService)Mockito.mock(BackupProtocolService.class);
        PrintStream systemOut = (PrintStream)Mockito.mock(PrintStream.class);
        new BackupTool(service, systemOut).run(args);
        ArgumentCaptor config = ArgumentCaptor.forClass(Config.class);
        ((BackupProtocolService)Mockito.verify((Object)service)).doIncrementalBackupOrFallbackToFull(ArgumentMatchers.anyString(), ArgumentMatchers.anyInt(), (Path)ArgumentMatchers.eq((Object)Paths.get("my_backup", new String[0])), (ConsistencyCheck)ArgumentMatchers.any(ConsistencyCheck.class), (Config)config.capture(), ArgumentMatchers.anyLong(), ArgumentMatchers.eq((boolean)false));
        Assert.assertTrue((boolean)((Boolean)((Config)config.getValue()).get(ConsistencyCheckSettings.consistency_check_property_owners)));
    }

    @Test
    public void exitWithFailureIfConfigSpecifiedButConfigFileDoesNotExist() {
        File configFile = this.testDirectory.file("nonexistent_file");
        String[] args = new String[]{"-host", "localhost", "-to", "my_backup", "-config", configFile.getPath()};
        BackupProtocolService service = (BackupProtocolService)Mockito.mock(BackupProtocolService.class);
        PrintStream systemOut = (PrintStream)Mockito.mock(PrintStream.class);
        BackupTool backupTool = new BackupTool(service, systemOut);
        try {
            backupTool.run(args);
            Assert.fail((String)"should exit abnormally");
        }
        catch (BackupTool.ToolFailureException e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.containsString((String)"Could not read configuration file"));
            Assert.assertThat((Object)e.getCause(), (Matcher)CoreMatchers.instanceOf(IOException.class));
        }
        Mockito.verifyZeroInteractions((Object[])new Object[]{service});
    }

    @Test
    public void exitWithFailureIfNoSourceSpecified() {
        String[] args = new String[]{"-to", "my_backup"};
        BackupProtocolService service = (BackupProtocolService)Mockito.mock(BackupProtocolService.class);
        PrintStream systemOut = (PrintStream)Mockito.mock(PrintStream.class);
        BackupTool backupTool = new BackupTool(service, systemOut);
        try {
            backupTool.run(args);
            Assert.fail((String)"should exit abnormally");
        }
        catch (BackupTool.ToolFailureException e) {
            Assert.assertEquals((Object)BackupTool.NO_SOURCE_SPECIFIED, (Object)e.getMessage());
        }
        Mockito.verifyZeroInteractions((Object[])new Object[]{service});
    }

    @Test
    public void exitWithFailureIfInvalidSourceSpecified() {
        String[] args = new String[]{"-host", "foo:localhost", "-port", "123", "-to", "my_backup"};
        BackupProtocolService service = (BackupProtocolService)Mockito.mock(BackupProtocolService.class);
        PrintStream systemOut = (PrintStream)Mockito.mock(PrintStream.class);
        BackupTool backupTool = new BackupTool(service, systemOut);
        try {
            backupTool.run(args);
            Assert.fail((String)"should exit abnormally");
        }
        catch (BackupTool.ToolFailureException e) {
            Assert.assertEquals((Object)BackupTool.WRONG_FROM_ADDRESS_SYNTAX, (Object)e.getMessage());
        }
        Mockito.verifyZeroInteractions((Object[])new Object[]{service});
    }

    @Test
    public void exitWithFailureIfNoDestinationSpecified() {
        String[] args = new String[]{"-host", "localhost"};
        BackupProtocolService service = (BackupProtocolService)Mockito.mock(BackupProtocolService.class);
        PrintStream systemOut = (PrintStream)Mockito.mock(PrintStream.class);
        BackupTool backupTool = new BackupTool(service, systemOut);
        try {
            backupTool.run(args);
            Assert.fail((String)"should exit abnormally");
        }
        catch (BackupTool.ToolFailureException e) {
            Assert.assertEquals((Object)"Specify target location with -to <target-directory>", (Object)e.getMessage());
        }
        Mockito.verifyZeroInteractions((Object[])new Object[]{service});
    }

    @Test
    public void helpMessageForWrongUriShouldNotContainSchema() {
        String[] args = new String[]{"-host", ":VeryWrongURI:", "-to", "/var/backup/graph"};
        BackupProtocolService service = (BackupProtocolService)Mockito.mock(BackupProtocolService.class);
        PrintStream systemOut = (PrintStream)Mockito.mock(PrintStream.class);
        try {
            new BackupTool(service, systemOut).run(args);
            Assert.fail((String)"should exit abnormally");
        }
        catch (BackupTool.ToolFailureException e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.equalTo((Object)BackupTool.WRONG_FROM_ADDRESS_SYNTAX));
            Assert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.not((Matcher)CoreMatchers.containsString((String)"<schema>")));
        }
        Mockito.verifyZeroInteractions((Object[])new Object[]{service, systemOut});
    }

    @Test
    public void shouldRespectVerifyFlagWithLegacyArguments() throws BackupTool.ToolFailureException {
        String host = "localhost";
        Path targetDir = Paths.get("/var/backup/neo4j/", new String[0]);
        String[] args = new String[]{"-from", host, "-to", targetDir.toString(), "-verify", "false"};
        BackupProtocolService service = (BackupProtocolService)Mockito.mock(BackupProtocolService.class);
        PrintStream systemOut = (PrintStream)Mockito.mock(PrintStream.class);
        new BackupTool(service, systemOut).run(args);
        ((BackupProtocolService)Mockito.verify((Object)service)).doIncrementalBackupOrFallbackToFull((String)ArgumentMatchers.eq((Object)host), ArgumentMatchers.eq((int)6362), (Path)ArgumentMatchers.eq((Object)targetDir), (ConsistencyCheck)ArgumentMatchers.eq((Object)ConsistencyCheck.NONE), (Config)ArgumentMatchers.any(Config.class), ArgumentMatchers.eq((long)BackupClient.BIG_READ_TIMEOUT), ArgumentMatchers.eq((boolean)false));
        ((PrintStream)Mockito.verify((Object)systemOut)).println("Performing backup from '" + new HostnamePort(host, 6362) + "'");
        ((PrintStream)Mockito.verify((Object)systemOut)).println("Done");
    }

    @Test
    public void shouldMakeUseOfDebugArgument() throws Exception {
        String[] args = new String[]{"-from", "localhost", "-to", "my_backup", "-gather-forensics"};
        BackupProtocolService service = (BackupProtocolService)Mockito.mock(BackupProtocolService.class);
        PrintStream systemOut = (PrintStream)Mockito.mock(PrintStream.class);
        new BackupTool(service, systemOut).run(args);
        ((BackupProtocolService)Mockito.verify((Object)service)).doIncrementalBackupOrFallbackToFull(ArgumentMatchers.anyString(), ArgumentMatchers.anyInt(), (Path)ArgumentMatchers.eq((Object)Paths.get("my_backup", new String[0])), (ConsistencyCheck)ArgumentMatchers.any(ConsistencyCheck.class), (Config)ArgumentMatchers.any(Config.class), ArgumentMatchers.anyLong(), ArgumentMatchers.eq((boolean)true));
    }

    @Test
    public void shouldHaveNoConsistencyCheckIfVerifyFalse() throws Exception {
        String[] args = new String[]{"-host", "localhost", "-to", "my_backup", "-verify", "false"};
        BackupProtocolService service = (BackupProtocolService)Mockito.mock(BackupProtocolService.class);
        PrintStream systemOut = (PrintStream)Mockito.mock(PrintStream.class);
        new BackupTool(service, systemOut).run(args);
        ((BackupProtocolService)Mockito.verify((Object)service)).doIncrementalBackupOrFallbackToFull(ArgumentMatchers.anyString(), ArgumentMatchers.anyInt(), (Path)ArgumentMatchers.any(Path.class), (ConsistencyCheck)ArgumentMatchers.eq((Object)ConsistencyCheck.NONE), (Config)ArgumentMatchers.any(Config.class), ArgumentMatchers.anyLong(), ArgumentMatchers.anyBoolean());
    }

    @Test
    public void shouldIgnoreConsistencyCheckIfVerifyFalse() throws Exception {
        String[] args = new String[]{"-host", "localhost", "-to", "my_backup", "-verify", "false", "-consistency-checker", "legacy"};
        BackupProtocolService service = (BackupProtocolService)Mockito.mock(BackupProtocolService.class);
        PrintStream systemOut = (PrintStream)Mockito.mock(PrintStream.class);
        new BackupTool(service, systemOut).run(args);
        ((BackupProtocolService)Mockito.verify((Object)service)).doIncrementalBackupOrFallbackToFull(ArgumentMatchers.anyString(), ArgumentMatchers.anyInt(), (Path)ArgumentMatchers.any(Path.class), (ConsistencyCheck)ArgumentMatchers.eq((Object)ConsistencyCheck.NONE), (Config)ArgumentMatchers.any(Config.class), ArgumentMatchers.anyLong(), ArgumentMatchers.anyBoolean());
    }

    @Test
    public void shouldHaveDefaultConsistencyCheckIfVerifyTrue() throws Exception {
        String[] args = new String[]{"-host", "localhost", "-to", "my_backup", "-verify", "true"};
        BackupProtocolService service = (BackupProtocolService)Mockito.mock(BackupProtocolService.class);
        PrintStream systemOut = (PrintStream)Mockito.mock(PrintStream.class);
        new BackupTool(service, systemOut).run(args);
        ((BackupProtocolService)Mockito.verify((Object)service)).doIncrementalBackupOrFallbackToFull(ArgumentMatchers.anyString(), ArgumentMatchers.anyInt(), (Path)ArgumentMatchers.any(Path.class), (ConsistencyCheck)ArgumentMatchers.eq((Object)ConsistencyCheck.FULL), (Config)ArgumentMatchers.any(Config.class), ArgumentMatchers.anyLong(), ArgumentMatchers.anyBoolean());
    }

    @Test
    public void shouldRespectConsistencyCheckerWithDefaultVerify() throws Exception {
        String[] args = new String[]{"-host", "localhost", "-to", "my_backup", "-consistency-checker", "full"};
        BackupProtocolService service = (BackupProtocolService)Mockito.mock(BackupProtocolService.class);
        PrintStream systemOut = (PrintStream)Mockito.mock(PrintStream.class);
        new BackupTool(service, systemOut).run(args);
        ((BackupProtocolService)Mockito.verify((Object)service)).doIncrementalBackupOrFallbackToFull(ArgumentMatchers.anyString(), ArgumentMatchers.anyInt(), (Path)ArgumentMatchers.any(Path.class), (ConsistencyCheck)ArgumentMatchers.eq((Object)ConsistencyCheck.FULL), (Config)ArgumentMatchers.any(Config.class), ArgumentMatchers.anyLong(), ArgumentMatchers.anyBoolean());
    }

    @Test
    public void shouldCrashIfInvalidConsistencyCheckerSpecified() throws Exception {
        String[] args = new String[]{"-host", "localhost", "-to", "my_backup", "-verify", "true", "-consistency-checker", "notarealname"};
        BackupProtocolService service = (BackupProtocolService)Mockito.mock(BackupProtocolService.class);
        PrintStream systemOut = (PrintStream)Mockito.mock(PrintStream.class);
        try {
            new BackupTool(service, systemOut).run(args);
            Assert.fail((String)"Should throw exception if invalid consistency checker is specified.");
        }
        catch (IllegalArgumentException t) {
            Assert.assertThat((Object)t.getMessage(), (Matcher)CoreMatchers.containsString((String)"Unknown consistency check name"));
        }
    }
}

