/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.neo4j.causalclustering.BackupUtil;
import org.neo4j.causalclustering.FileCopyDetector;
import org.neo4j.causalclustering.backup_stores.BackupStore;
import org.neo4j.causalclustering.backup_stores.BackupStoreWithSomeData;
import org.neo4j.causalclustering.backup_stores.BackupStoreWithSomeDataButNoTransactionLogs;
import org.neo4j.causalclustering.backup_stores.EmptyBackupStore;
import org.neo4j.causalclustering.cluster_load.ClusterLoad;
import org.neo4j.causalclustering.cluster_load.NoLoad;
import org.neo4j.causalclustering.cluster_load.SmallBurst;
import org.neo4j.causalclustering.discovery.Cluster;
import org.neo4j.causalclustering.discovery.ClusterMember;
import org.neo4j.causalclustering.discovery.CoreClusterMember;
import org.neo4j.causalclustering.discovery.DiscoveryServiceFactory;
import org.neo4j.causalclustering.discovery.IpFamily;
import org.neo4j.causalclustering.discovery.SharedDiscoveryServiceFactory;
import org.neo4j.test.rule.SuppressOutput;
import org.neo4j.test.rule.TestDirectory;
import org.neo4j.test.rule.fs.DefaultFileSystemRule;

@RunWith(value=Parameterized.class)
public class NewMemberSeedingIT {
    @Parameterized.Parameter
    public BackupStore seedStore;
    @Parameterized.Parameter(value=1)
    public ClusterLoad intermediateLoad;
    private SuppressOutput suppressOutput = SuppressOutput.suppressAll();
    private TestDirectory testDir = TestDirectory.testDirectory();
    private DefaultFileSystemRule fileSystemRule = new DefaultFileSystemRule();
    @Rule
    public RuleChain rules = RuleChain.outerRule((TestRule)this.fileSystemRule).around((TestRule)this.testDir).around((TestRule)this.suppressOutput);
    private Cluster cluster;
    private FileCopyDetector fileCopyDetector;
    private File baseBackupDir;

    @Parameterized.Parameters(name="{0} with {1}")
    public static Iterable<Object[]> data() {
        return NewMemberSeedingIT.combine(NewMemberSeedingIT.stores(), NewMemberSeedingIT.loads());
    }

    private static Iterable<Object[]> combine(Iterable<BackupStore> stores, Iterable<ClusterLoad> loads) {
        ArrayList<Object[]> params = new ArrayList<Object[]>();
        for (BackupStore store : stores) {
            for (ClusterLoad load : loads) {
                params.add(new Object[]{store, load});
            }
        }
        return params;
    }

    private static Iterable<ClusterLoad> loads() {
        return Arrays.asList(new NoLoad(), new SmallBurst());
    }

    private static Iterable<BackupStore> stores() {
        return Arrays.asList(new EmptyBackupStore(), new BackupStoreWithSomeData(), new BackupStoreWithSomeDataButNoTransactionLogs());
    }

    @Before
    public void setup() {
        this.fileCopyDetector = new FileCopyDetector();
        this.cluster = new Cluster(this.testDir.directory("cluster-b"), 3, 0, (DiscoveryServiceFactory)new SharedDiscoveryServiceFactory(), Collections.emptyMap(), Collections.emptyMap(), Collections.emptyMap(), Collections.emptyMap(), "standard", IpFamily.IPV4, false);
        this.baseBackupDir = this.testDir.directory("backups");
    }

    @After
    public void after() {
        if (this.cluster != null) {
            this.cluster.shutdown();
        }
    }

    @Test
    public void shouldSeedNewMemberToCluster() throws Exception {
        this.cluster.start();
        Optional<File> backup = this.seedStore.generate(this.baseBackupDir, this.cluster);
        this.intermediateLoad.start(this.cluster);
        CoreClusterMember newCoreClusterMember = this.cluster.addCoreMemberWithId(3);
        if (backup.isPresent()) {
            BackupUtil.restoreFromBackup(backup.get(), this.fileSystemRule.get(), (ClusterMember)newCoreClusterMember);
        }
        newCoreClusterMember.monitors().addMonitorListener((Object)this.fileCopyDetector, new String[0]);
        newCoreClusterMember.start();
        this.intermediateLoad.stop();
        Cluster.dataMatchesEventually((ClusterMember)newCoreClusterMember, (Collection)this.cluster.coreMembers());
        Assert.assertFalse((boolean)this.fileCopyDetector.hasDetectedAnyFileCopied());
    }
}

