/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering;

import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.neo4j.causalclustering.BackupUtil;
import org.neo4j.causalclustering.FileCopyDetector;
import org.neo4j.causalclustering.backup_stores.BackupStore;
import org.neo4j.causalclustering.backup_stores.BackupStoreWithSomeData;
import org.neo4j.causalclustering.backup_stores.BackupStoreWithSomeDataButNoTransactionLogs;
import org.neo4j.causalclustering.backup_stores.EmptyBackupStore;
import org.neo4j.causalclustering.backup_stores.NoStore;
import org.neo4j.causalclustering.discovery.Cluster;
import org.neo4j.causalclustering.discovery.ClusterMember;
import org.neo4j.causalclustering.discovery.CoreClusterMember;
import org.neo4j.causalclustering.discovery.DiscoveryServiceFactory;
import org.neo4j.causalclustering.discovery.IpFamily;
import org.neo4j.causalclustering.discovery.SharedDiscoveryServiceFactory;
import org.neo4j.test.DbRepresentation;
import org.neo4j.test.rule.SuppressOutput;
import org.neo4j.test.rule.TestDirectory;
import org.neo4j.test.rule.fs.DefaultFileSystemRule;

@RunWith(value=Parameterized.class)
public class ClusterSeedingIT {
    @Parameterized.Parameter
    public BackupStore initialStore;
    @Parameterized.Parameter(value=1)
    public boolean shouldStoreCopy;
    private SuppressOutput suppressOutput = SuppressOutput.suppressAll();
    private TestDirectory testDir = TestDirectory.testDirectory();
    private DefaultFileSystemRule fileSystemRule = new DefaultFileSystemRule();
    @Rule
    public RuleChain rules = RuleChain.outerRule((TestRule)this.fileSystemRule).around((TestRule)this.testDir).around((TestRule)this.suppressOutput);
    private Cluster backupCluster;
    private Cluster cluster;
    private FileCopyDetector fileCopyDetector;
    private File baseBackupDir;

    @Parameterized.Parameters(name="{0}")
    public static Object[][] data() {
        return new Object[][]{{new NoStore(), true}, {new EmptyBackupStore(), false}, {new BackupStoreWithSomeData(), false}, {new BackupStoreWithSomeDataButNoTransactionLogs(), false}};
    }

    @Before
    public void setup() {
        this.fileCopyDetector = new FileCopyDetector();
        this.backupCluster = new Cluster(this.testDir.directory("cluster-for-backup"), 3, 0, (DiscoveryServiceFactory)new SharedDiscoveryServiceFactory(), Collections.emptyMap(), Collections.emptyMap(), Collections.emptyMap(), Collections.emptyMap(), "standard", IpFamily.IPV4, false);
        this.cluster = new Cluster(this.testDir.directory("cluster-b"), 3, 0, (DiscoveryServiceFactory)new SharedDiscoveryServiceFactory(), Collections.emptyMap(), Collections.emptyMap(), Collections.emptyMap(), Collections.emptyMap(), "standard", IpFamily.IPV4, false);
        this.baseBackupDir = this.testDir.directory("backups");
    }

    @After
    public void after() {
        if (this.backupCluster != null) {
            this.backupCluster.shutdown();
        }
        if (this.cluster != null) {
            this.cluster.shutdown();
        }
    }

    @Test
    public void shouldSeedNewCluster() throws Exception {
        this.backupCluster.start();
        Optional<File> backup = this.initialStore.generate(this.baseBackupDir, this.backupCluster);
        this.backupCluster.shutdown();
        if (backup.isPresent()) {
            for (CoreClusterMember coreClusterMember : this.cluster.coreMembers()) {
                BackupUtil.restoreFromBackup(backup.get(), this.fileSystemRule.get(), (ClusterMember)coreClusterMember);
            }
        }
        this.cluster.coreMembers().forEach(ccm -> ccm.monitors().addMonitorListener((Object)this.fileCopyDetector, new String[0]));
        this.cluster.start();
        if (backup.isPresent()) {
            Cluster.dataMatchesEventually((DbRepresentation)DbRepresentation.of((File)backup.get()), (Collection)this.cluster.coreMembers());
        }
        Assert.assertEquals((Object)this.shouldStoreCopy, (Object)this.fileCopyDetector.hasDetectedAnyFileCopied());
    }
}

