/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering;

import java.io.File;
import java.util.concurrent.TimeUnit;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.causalclustering.BackupCoreIT;
import org.neo4j.causalclustering.core.CoreGraphDatabase;
import org.neo4j.causalclustering.discovery.Cluster;
import org.neo4j.causalclustering.helpers.CausalClusteringTestHelpers;
import org.neo4j.causalclustering.readreplica.ReadReplicaGraphDatabase;
import org.neo4j.function.Predicates;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.enterprise.configuration.OnlineBackupSettings;
import org.neo4j.kernel.impl.factory.GraphDatabaseFacade;
import org.neo4j.kernel.impl.transaction.log.TransactionIdStore;
import org.neo4j.test.DbRepresentation;
import org.neo4j.test.causalclustering.ClusterRule;
import org.neo4j.test.rule.SuppressOutput;
import org.neo4j.util.TestHelpers;

public class BackupReadReplicaIT {
    @Rule
    public SuppressOutput suppress = SuppressOutput.suppressAll();
    @Rule
    public ClusterRule clusterRule = new ClusterRule().withNumberOfCoreMembers(3).withSharedCoreParam(OnlineBackupSettings.online_backup_enabled, "false").withNumberOfReadReplicas(1).withSharedReadReplicaParam(OnlineBackupSettings.online_backup_enabled, "true");
    private Cluster cluster;
    private File backupPath;

    @Before
    public void setup() throws Exception {
        this.backupPath = this.clusterRule.testDirectory().cleanDirectory("backup-db");
        this.cluster = this.clusterRule.startCluster();
    }

    private boolean readReplicasUpToDateAsTheLeader(CoreGraphDatabase leader, ReadReplicaGraphDatabase readReplica) {
        long leaderTxId = ((TransactionIdStore)leader.getDependencyResolver().resolveDependency(TransactionIdStore.class)).getLastClosedTransactionId();
        long lastClosedTxId = ((TransactionIdStore)readReplica.getDependencyResolver().resolveDependency(TransactionIdStore.class)).getLastClosedTransactionId();
        return lastClosedTxId == leaderTxId;
    }

    @Test
    public void makeSureBackupCanBePerformed() throws Throwable {
        CoreGraphDatabase leader = BackupCoreIT.createSomeData(this.cluster);
        ReadReplicaGraphDatabase readReplica = this.cluster.findAnyReadReplica().database();
        Predicates.awaitEx(() -> this.readReplicasUpToDateAsTheLeader(leader, readReplica), (long)1L, (TimeUnit)TimeUnit.MINUTES);
        DbRepresentation beforeChange = DbRepresentation.of((GraphDatabaseService)readReplica);
        String backupAddress = CausalClusteringTestHelpers.transactionAddress((GraphDatabaseFacade)readReplica);
        String[] args = BackupCoreIT.backupArguments(backupAddress, this.backupPath, "readreplica");
        Assert.assertEquals((long)0L, (long)TestHelpers.runBackupToolFromOtherJvmToGetExitCode((File)this.clusterRule.clusterDirectory(), (String[])args));
        DbRepresentation afterChange = DbRepresentation.of((GraphDatabaseService)BackupCoreIT.createSomeData(this.cluster));
        DbRepresentation backupRepresentation = DbRepresentation.of((File)new File(this.backupPath, "readreplica"), (Config)BackupCoreIT.getConfig());
        Assert.assertEquals((Object)beforeChange, (Object)backupRepresentation);
        Assert.assertNotEquals((Object)backupRepresentation, (Object)afterChange);
    }
}

