/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.backup.impl;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.neo4j.backup.impl.BackupStrategyWrapper;
import org.neo4j.backup.impl.SelectedBackupProtocol;
import org.neo4j.backup.impl.StrategyResolverService;

public class StrategyResolverServiceTest {
    StrategyResolverService subject;
    BackupStrategyWrapper haBackupStrategy;
    BackupStrategyWrapper ccBackupStrategy;

    @Before
    public void setup() {
        this.haBackupStrategy = (BackupStrategyWrapper)Mockito.mock(BackupStrategyWrapper.class);
        this.ccBackupStrategy = (BackupStrategyWrapper)Mockito.mock(BackupStrategyWrapper.class);
        this.subject = new StrategyResolverService(this.haBackupStrategy, this.ccBackupStrategy);
    }

    @Test
    public void anyProvidesBothStrategiesCorrectOrder() {
        List result = this.subject.getStrategies(SelectedBackupProtocol.ANY);
        Assert.assertEquals(Arrays.asList(this.ccBackupStrategy, this.haBackupStrategy), (Object)result);
    }

    @Test
    public void legacyProvidesBackupProtocol() {
        List result = this.subject.getStrategies(SelectedBackupProtocol.COMMON);
        Assert.assertEquals(Collections.singletonList(this.haBackupStrategy), (Object)result);
    }

    @Test
    public void catchupProvidesTransactionProtocol() {
        List result = this.subject.getStrategies(SelectedBackupProtocol.CATCHUP);
        Assert.assertEquals(Collections.singletonList(this.ccBackupStrategy), (Object)result);
    }
}

