/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.backup.impl;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.neo4j.backup.impl.BackupDelegator;
import org.neo4j.backup.impl.BackupProtocolService;
import org.neo4j.backup.impl.BackupStrategyCoordinator;
import org.neo4j.backup.impl.BackupStrategyCoordinatorFactory;
import org.neo4j.backup.impl.BackupSupportingClassesFactory;
import org.neo4j.backup.impl.OnlineBackupCommand;
import org.neo4j.backup.impl.OnlineBackupCommandProvider;
import org.neo4j.backup.impl.OnlineBackupContext;
import org.neo4j.backup.impl.OnlineBackupContextFactory;
import org.neo4j.backup.impl.OnlineBackupRequiredArguments;
import org.neo4j.commandline.admin.AdminCommand;
import org.neo4j.commandline.admin.CommandFailed;
import org.neo4j.commandline.admin.CommandLocator;
import org.neo4j.commandline.admin.IncorrectUsage;
import org.neo4j.commandline.admin.OutsideWorld;
import org.neo4j.commandline.admin.Usage;
import org.neo4j.consistency.checking.full.ConsistencyFlags;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.kernel.configuration.Config;

public class OnlineBackupCommandTest {
    @Rule
    public ExpectedException expected = ExpectedException.none();
    private OutsideWorld outsideWorld = (OutsideWorld)Mockito.mock(OutsideWorld.class);
    private BackupStrategyCoordinatorFactory backupStrategyCoordinatorFactory = (BackupStrategyCoordinatorFactory)Mockito.mock(BackupStrategyCoordinatorFactory.class);
    private FileSystemAbstraction fileSystemAbstraction = (FileSystemAbstraction)Mockito.mock(FileSystemAbstraction.class);
    private BackupStrategyCoordinator backupStrategyCoordinator = (BackupStrategyCoordinator)Mockito.mock(BackupStrategyCoordinator.class);
    private final Config config = (Config)Mockito.mock(Config.class);
    private final OnlineBackupRequiredArguments requiredArguments = (OnlineBackupRequiredArguments)Mockito.mock(OnlineBackupRequiredArguments.class);
    private final ConsistencyFlags consistencyFlags = (ConsistencyFlags)Mockito.mock(ConsistencyFlags.class);
    private final OnlineBackupContext onlineBackupContext = new OnlineBackupContext(this.requiredArguments, this.config, this.consistencyFlags);
    private Path backupDirectory = Paths.get("backupDirectory/", new String[0]);
    private Path reportDirectory = Paths.get("reportDirectory/", new String[0]);
    private BackupSupportingClassesFactory backupSupportingClassesFactory = (BackupSupportingClassesFactory)Mockito.mock(BackupSupportingClassesFactory.class);
    private OnlineBackupCommand subject;

    @Before
    public void setup() throws Exception {
        OnlineBackupContextFactory contextBuilder = (OnlineBackupContextFactory)Mockito.mock(OnlineBackupContextFactory.class);
        Mockito.when((Object)contextBuilder.createContext((String[])ArgumentMatchers.any())).thenReturn((Object)this.onlineBackupContext);
        Mockito.when((Object)this.outsideWorld.fileSystem()).thenReturn((Object)this.fileSystemAbstraction);
        Mockito.when((Object)this.fileSystemAbstraction.isDirectory(this.backupDirectory.toFile())).thenReturn((Object)true);
        Mockito.when((Object)this.fileSystemAbstraction.isDirectory(this.reportDirectory.toFile())).thenReturn((Object)true);
        Mockito.when((Object)this.requiredArguments.getDirectory()).thenReturn((Object)this.backupDirectory);
        Mockito.when((Object)this.requiredArguments.getReportDir()).thenReturn((Object)this.reportDirectory);
        Mockito.when((Object)this.requiredArguments.getName()).thenReturn((Object)"backup name");
        Mockito.when((Object)this.backupStrategyCoordinatorFactory.backupStrategyCoordinator((OnlineBackupContext)ArgumentMatchers.any(), (BackupProtocolService)ArgumentMatchers.any(), (BackupDelegator)ArgumentMatchers.any(), (PageCache)ArgumentMatchers.any())).thenReturn((Object)this.backupStrategyCoordinator);
        this.subject = new OnlineBackupCommand(this.outsideWorld, contextBuilder, this.backupSupportingClassesFactory, this.backupStrategyCoordinatorFactory);
    }

    @Test
    public void nonExistingBackupDirectoryRaisesException() throws CommandFailed, IncorrectUsage {
        Mockito.when((Object)this.fileSystemAbstraction.isDirectory(this.backupDirectory.toFile())).thenReturn((Object)false);
        this.expected.expect(CommandFailed.class);
        this.expected.expectMessage("Directory 'backupDirectory' does not exist.");
        this.execute();
    }

    @Test
    public void nonExistingReportDirectoryRaisesException() throws CommandFailed, IncorrectUsage {
        Mockito.when((Object)this.fileSystemAbstraction.isDirectory(this.reportDirectory.toFile())).thenReturn((Object)false);
        this.expected.expect(CommandFailed.class);
        this.expected.expectMessage("Directory 'reportDirectory' does not exist.");
        this.execute();
    }

    @Test
    public void shouldPrintNiceHelp() throws Throwable {
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
            PrintStream ps = new PrintStream(baos);
            Usage usage = new Usage("neo4j-admin", (CommandLocator)Mockito.mock(CommandLocator.class));
            usage.printUsageForCommand((AdminCommand.Provider)new OnlineBackupCommandProvider(), ps::println);
            Assert.assertEquals((Object)String.format("usage: neo4j-admin backup --backup-dir=<backup-path> --name=<graph.db-backup>%n                          [--from=<address>] [--protocol=<any|catchup|common>]%n                          [--fallback-to-full[=<true|false>]]%n                          [--timeout=<timeout>] [--pagecache=<8m>]%n                          [--check-consistency[=<true|false>]]%n                          [--cc-report-dir=<directory>]%n                          [--additional-config=<config-file-path>]%n                          [--cc-graph[=<true|false>]]%n                          [--cc-indexes[=<true|false>]]%n                          [--cc-label-scan-store[=<true|false>]]%n                          [--cc-property-owners[=<true|false>]]%n%nenvironment variables:%n    NEO4J_CONF    Path to directory which contains neo4j.conf.%n    NEO4J_DEBUG   Set to anything to enable debug output.%n    NEO4J_HOME    Neo4j home directory.%n    HEAP_SIZE     Set JVM maximum heap size during command execution.%n                  Takes a number and a unit, for example 512m.%n%nPerform an online backup from a running Neo4j enterprise server. Neo4j's backup%nservice must have been configured on the server beforehand.%n%nAll consistency checks except 'cc-graph' can be quite expensive so it may be%nuseful to turn them off for very large databases. Increasing the heap size can%nalso be a good idea. See 'neo4j-admin help' for details.%n%nFor more information see:%nhttps://neo4j.com/docs/operations-manual/current/backup/%n%noptions:%n  --backup-dir=<backup-path>               Directory to place backup in.%n  --name=<graph.db-backup>                 Name of backup. If a backup with this%n                                           name already exists an incremental%n                                           backup will be attempted.%n  --from=<address>                         Host and port of Neo4j.%n                                           [default:localhost:6362]%n  --protocol=<any|catchup|common>          Preferred backup protocol%n                                           [default:any]%n  --fallback-to-full=<true|false>          If an incremental backup fails backup%n                                           will move the old backup to%n                                           <name>.err.<N> and fallback to a full%n                                           backup instead. [default:true]%n  --timeout=<timeout>                      Timeout in the form <time>[ms|s|m|h],%n                                           where the default unit is seconds.%n                                           [default:20m]%n  --pagecache=<8m>                         The size of the page cache to use for%n                                           the backup process. [default:8m]%n  --check-consistency=<true|false>         If a consistency check should be%n                                           made. [default:true]%n  --cc-report-dir=<directory>              Directory where consistency report%n                                           will be written. [default:.]%n  --additional-config=<config-file-path>   Configuration file to supply%n                                           additional configuration in. This%n                                           argument is DEPRECATED. [default:]%n  --cc-graph=<true|false>                  Perform consistency checks between%n                                           nodes, relationships, properties,%n                                           types and tokens. [default:true]%n  --cc-indexes=<true|false>                Perform consistency checks on%n                                           indexes. [default:true]%n  --cc-label-scan-store=<true|false>       Perform consistency checks on the%n                                           label scan store. [default:true]%n  --cc-property-owners=<true|false>        Perform additional consistency checks%n                                           on property ownership. This check is%n                                           *very* expensive in time and memory.%n                                           [default:false]%n", new Object[0]), (Object)baos.toString());
        }
    }

    private void execute() throws IncorrectUsage, CommandFailed {
        String[] implementationDoesNotUseArguments = new String[]{};
        this.subject.execute(implementationDoesNotUseArguments);
    }
}

