/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.backup.impl;

import java.util.Collection;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.backup.impl.BackupSupportingClassesFactoryProvider;

public class BackupSupportingClassesFactoryProviderTest {
    @Test
    public void canLoadDefaultSupportingClassesFactory() {
        Assert.assertEquals((long)1L, (long)BackupSupportingClassesFactoryProviderTest.findInstancesOf(BackupSupportingClassesFactoryProvider.class, BackupSupportingClassesFactoryProviderTest.allAvailableSupportingClassesFactories()).size());
        Assert.assertEquals((long)2L, (long)BackupSupportingClassesFactoryProviderTest.allAvailableSupportingClassesFactories().size());
    }

    @Test
    public void testDefaultModuleIsPrioritisedOverDummyModule() {
        Assert.assertEquals(BackupSupportingClassesFactoryProvider.class, ((BackupSupportingClassesFactoryProvider)BackupSupportingClassesFactoryProvider.getProvidersByPriority().findFirst().get()).getClass());
    }

    public static Collection<BackupSupportingClassesFactoryProvider> allAvailableSupportingClassesFactories() {
        return BackupSupportingClassesFactoryProvider.getProvidersByPriority().collect(Collectors.toList());
    }

    public static <DESIRED extends BackupSupportingClassesFactoryProvider> Collection<DESIRED> findInstancesOf(Class<DESIRED> desiredClass, Collection<? extends BackupSupportingClassesFactoryProvider> collection) {
        return collection.stream().filter(BackupSupportingClassesFactoryProviderTest.isOfClass(desiredClass)).map(i -> i).collect(Collectors.toList());
    }

    private static Predicate<BackupSupportingClassesFactoryProvider> isOfClass(Class<? extends BackupSupportingClassesFactoryProvider> desiredClass) {
        return factory -> desiredClass.equals(factory.getClass());
    }
}

