/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.backup.impl;

import java.io.File;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collections;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matchers;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.neo4j.backup.ExceptionMatchers;
import org.neo4j.backup.impl.BackupStrategyCoordinator;
import org.neo4j.backup.impl.BackupStrategyOutcome;
import org.neo4j.backup.impl.BackupStrategyWrapper;
import org.neo4j.backup.impl.Fallible;
import org.neo4j.backup.impl.OnlineBackupContext;
import org.neo4j.backup.impl.OnlineBackupRequiredArguments;
import org.neo4j.commandline.admin.CommandFailed;
import org.neo4j.commandline.admin.OutsideWorld;
import org.neo4j.consistency.ConsistencyCheckService;
import org.neo4j.consistency.checking.full.ConsistencyCheckIncompleteException;
import org.neo4j.consistency.checking.full.ConsistencyFlags;
import org.neo4j.helpers.progress.ProgressMonitorFactory;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.logging.LogProvider;

public class BackupStrategyCoordinatorTest {
    @Rule
    public ExpectedException expectedException = ExpectedException.none();
    private final ConsistencyCheckService consistencyCheckService = (ConsistencyCheckService)Mockito.mock(ConsistencyCheckService.class);
    private final OutsideWorld outsideWorld = (OutsideWorld)Mockito.mock(OutsideWorld.class);
    private final FileSystemAbstraction fileSystem = (FileSystemAbstraction)Mockito.mock(FileSystemAbstraction.class);
    private final LogProvider logProvider = (LogProvider)Mockito.mock(LogProvider.class);
    private final BackupStrategyWrapper firstStrategy = (BackupStrategyWrapper)Mockito.mock(BackupStrategyWrapper.class);
    private final BackupStrategyWrapper secondStrategy = (BackupStrategyWrapper)Mockito.mock(BackupStrategyWrapper.class);
    private BackupStrategyCoordinator subject;
    private final OnlineBackupContext onlineBackupContext = (OnlineBackupContext)Mockito.mock(OnlineBackupContext.class);
    private final OnlineBackupRequiredArguments requiredArguments = (OnlineBackupRequiredArguments)Mockito.mock(OnlineBackupRequiredArguments.class);
    private final ProgressMonitorFactory progressMonitorFactory = (ProgressMonitorFactory)Mockito.mock(ProgressMonitorFactory.class);
    private final Path reportDir = (Path)Mockito.mock(Path.class);
    private final ConsistencyCheckService.Result consistencyCheckResult = (ConsistencyCheckService.Result)Mockito.mock(ConsistencyCheckService.Result.class);

    @Before
    public void setup() {
        Mockito.when((Object)this.outsideWorld.fileSystem()).thenReturn((Object)this.fileSystem);
        Mockito.when((Object)this.onlineBackupContext.getRequiredArguments()).thenReturn((Object)this.requiredArguments);
        Mockito.when((Object)this.onlineBackupContext.getResolvedLocationFromName()).thenReturn((Object)this.reportDir);
        Mockito.when((Object)this.requiredArguments.getReportDir()).thenReturn((Object)this.reportDir);
        this.subject = new BackupStrategyCoordinator(this.consistencyCheckService, this.outsideWorld, this.logProvider, this.progressMonitorFactory, Arrays.asList(this.firstStrategy, this.secondStrategy));
    }

    @Test
    public void backupIsValidIfAnySingleStrategyPasses_secondFails() throws CommandFailed {
        Mockito.when((Object)this.firstStrategy.doBackup((OnlineBackupContext)ArgumentMatchers.any())).thenReturn((Object)new Fallible((Object)BackupStrategyOutcome.SUCCESS, null));
        Mockito.when((Object)this.secondStrategy.doBackup((OnlineBackupContext)ArgumentMatchers.any())).thenReturn((Object)new Fallible((Object)BackupStrategyOutcome.INCORRECT_STRATEGY, null));
        this.subject.performBackup(this.onlineBackupContext);
    }

    @Test
    public void backupIsValidIfAnySingleStrategyPasses_firstFails() throws CommandFailed {
        Mockito.when((Object)this.firstStrategy.doBackup((OnlineBackupContext)ArgumentMatchers.any())).thenReturn((Object)new Fallible((Object)BackupStrategyOutcome.INCORRECT_STRATEGY, null));
        Mockito.when((Object)this.secondStrategy.doBackup((OnlineBackupContext)ArgumentMatchers.any())).thenReturn((Object)new Fallible((Object)BackupStrategyOutcome.SUCCESS, null));
        this.subject.performBackup(this.onlineBackupContext);
    }

    @Test
    public void backupIsInvalidIfTheCorrectMethodFailed_firstFails() throws CommandFailed {
        Mockito.when((Object)this.firstStrategy.doBackup((OnlineBackupContext)ArgumentMatchers.any())).thenReturn((Object)new Fallible((Object)BackupStrategyOutcome.CORRECT_STRATEGY_FAILED, null));
        Mockito.when((Object)this.secondStrategy.doBackup((OnlineBackupContext)ArgumentMatchers.any())).thenReturn((Object)new Fallible((Object)BackupStrategyOutcome.INCORRECT_STRATEGY, null));
        this.expectedException.expect(CommandFailed.class);
        this.expectedException.expectMessage(Matchers.containsString((String)"Execution of backup failed"));
        this.subject.performBackup(this.onlineBackupContext);
    }

    @Test
    public void backupIsInvalidIfTheCorrectMethodFailed_secondFails() throws CommandFailed {
        Mockito.when((Object)this.firstStrategy.doBackup((OnlineBackupContext)ArgumentMatchers.any())).thenReturn((Object)new Fallible((Object)BackupStrategyOutcome.INCORRECT_STRATEGY, null));
        Mockito.when((Object)this.secondStrategy.doBackup((OnlineBackupContext)ArgumentMatchers.any())).thenReturn((Object)new Fallible((Object)BackupStrategyOutcome.CORRECT_STRATEGY_FAILED, null));
        this.expectedException.expect(CommandFailed.class);
        this.expectedException.expectMessage(Matchers.containsString((String)"Execution of backup failed"));
        this.subject.performBackup(this.onlineBackupContext);
    }

    @Test
    public void backupFailsIfAllStrategiesAreIncorrect() throws CommandFailed {
        Mockito.when((Object)this.firstStrategy.doBackup((OnlineBackupContext)ArgumentMatchers.any())).thenReturn((Object)new Fallible((Object)BackupStrategyOutcome.INCORRECT_STRATEGY, null));
        Mockito.when((Object)this.secondStrategy.doBackup((OnlineBackupContext)ArgumentMatchers.any())).thenReturn((Object)new Fallible((Object)BackupStrategyOutcome.INCORRECT_STRATEGY, null));
        this.expectedException.expect(CommandFailed.class);
        this.expectedException.expectMessage(CoreMatchers.equalTo((Object)"Failed to run a backup using the available strategies."));
        this.subject.performBackup(this.onlineBackupContext);
    }

    @Test
    public void consistencyCheckIsRunIfSpecified() throws CommandFailed, ConsistencyCheckIncompleteException {
        this.anyStrategyPasses();
        Mockito.when((Object)this.requiredArguments.isDoConsistencyCheck()).thenReturn((Object)true);
        Mockito.when((Object)this.consistencyCheckService.runFullConsistencyCheck((File)ArgumentMatchers.any(), (Config)ArgumentMatchers.any(), (ProgressMonitorFactory)ArgumentMatchers.eq((Object)this.progressMonitorFactory), (LogProvider)ArgumentMatchers.any(LogProvider.class), (FileSystemAbstraction)ArgumentMatchers.any(), ArgumentMatchers.eq((boolean)false), (File)ArgumentMatchers.any(), (ConsistencyFlags)ArgumentMatchers.any())).thenReturn((Object)this.consistencyCheckResult);
        Mockito.when((Object)this.consistencyCheckResult.isSuccessful()).thenReturn((Object)true);
        this.subject.performBackup(this.onlineBackupContext);
        ((ConsistencyCheckService)Mockito.verify((Object)this.consistencyCheckService)).runFullConsistencyCheck((File)ArgumentMatchers.any(), (Config)ArgumentMatchers.any(), (ProgressMonitorFactory)ArgumentMatchers.any(), (LogProvider)ArgumentMatchers.any(), (FileSystemAbstraction)ArgumentMatchers.any(), ArgumentMatchers.eq((boolean)false), (File)ArgumentMatchers.any(), (ConsistencyFlags)ArgumentMatchers.any());
    }

    @Test
    public void consistencyCheckIsNotRunIfNotSpecified() throws CommandFailed, ConsistencyCheckIncompleteException {
        this.anyStrategyPasses();
        Mockito.when((Object)this.requiredArguments.isDoConsistencyCheck()).thenReturn((Object)false);
        this.subject.performBackup(this.onlineBackupContext);
        ((ConsistencyCheckService)Mockito.verify((Object)this.consistencyCheckService, (VerificationMode)Mockito.never())).runFullConsistencyCheck((File)ArgumentMatchers.any(), (Config)ArgumentMatchers.any(), (ProgressMonitorFactory)ArgumentMatchers.any(), (LogProvider)ArgumentMatchers.any(), (FileSystemAbstraction)ArgumentMatchers.any(), ArgumentMatchers.eq((boolean)false), (File)ArgumentMatchers.any(), (ConsistencyFlags)ArgumentMatchers.any(ConsistencyFlags.class));
    }

    @Test
    public void allFailureCausesAreCollectedAndAttachedToCommandFailedException() throws CommandFailed {
        RuntimeException firstCause = new RuntimeException("First cause");
        RuntimeException secondCause = new RuntimeException("Second cause");
        Mockito.when((Object)this.firstStrategy.doBackup((OnlineBackupContext)ArgumentMatchers.any())).thenReturn((Object)new Fallible((Object)BackupStrategyOutcome.INCORRECT_STRATEGY, (Throwable)firstCause));
        Mockito.when((Object)this.secondStrategy.doBackup((OnlineBackupContext)ArgumentMatchers.any())).thenReturn((Object)new Fallible((Object)BackupStrategyOutcome.INCORRECT_STRATEGY, (Throwable)secondCause));
        this.expectedException.expect(ExceptionMatchers.exceptionContainsSuppressedThrowable(firstCause));
        this.expectedException.expect(ExceptionMatchers.exceptionContainsSuppressedThrowable(secondCause));
        this.expectedException.expect(CommandFailed.class);
        this.expectedException.expectMessage("Failed to run a backup using the available strategies.");
        this.subject.performBackup(this.onlineBackupContext);
    }

    @Test
    public void commandFailedWhenConsistencyCheckFails() throws ConsistencyCheckIncompleteException, CommandFailed {
        this.anyStrategyPasses();
        Mockito.when((Object)this.requiredArguments.isDoConsistencyCheck()).thenReturn((Object)true);
        Mockito.when((Object)this.consistencyCheckResult.isSuccessful()).thenReturn((Object)false);
        Mockito.when((Object)this.consistencyCheckService.runFullConsistencyCheck((File)ArgumentMatchers.any(), (Config)ArgumentMatchers.any(), (ProgressMonitorFactory)ArgumentMatchers.eq((Object)this.progressMonitorFactory), (LogProvider)ArgumentMatchers.any(LogProvider.class), (FileSystemAbstraction)ArgumentMatchers.any(), ArgumentMatchers.eq((boolean)false), (File)ArgumentMatchers.any(), (ConsistencyFlags)ArgumentMatchers.any())).thenReturn((Object)this.consistencyCheckResult);
        this.expectedException.expect(CommandFailed.class);
        this.expectedException.expectMessage("Inconsistencies found");
        this.subject.performBackup(this.onlineBackupContext);
    }

    @Test
    public void havingNoStrategiesCausesAllSolutionsFailedException() throws CommandFailed {
        this.subject = new BackupStrategyCoordinator(this.consistencyCheckService, this.outsideWorld, this.logProvider, this.progressMonitorFactory, Collections.emptyList());
        this.expectedException.expect(CommandFailed.class);
        this.expectedException.expectMessage("Failed to run a backup using the available strategies.");
        this.subject.performBackup(this.onlineBackupContext);
    }

    private void anyStrategyPasses() {
        Mockito.when((Object)this.firstStrategy.doBackup((OnlineBackupContext)ArgumentMatchers.any())).thenReturn((Object)new Fallible((Object)BackupStrategyOutcome.SUCCESS, null));
        Mockito.when((Object)this.secondStrategy.doBackup((OnlineBackupContext)ArgumentMatchers.any())).thenReturn((Object)new Fallible((Object)BackupStrategyOutcome.SUCCESS, null));
    }
}

