/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.backup.impl;

import java.nio.file.Path;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.neo4j.backup.IncrementalBackupNotPossibleException;
import org.neo4j.backup.impl.AddressResolver;
import org.neo4j.backup.impl.BackupProtocolService;
import org.neo4j.backup.impl.BackupStageOutcome;
import org.neo4j.backup.impl.ConsistencyCheck;
import org.neo4j.backup.impl.Fallible;
import org.neo4j.backup.impl.HaBackupStrategy;
import org.neo4j.backup.impl.OnlineBackupContext;
import org.neo4j.backup.impl.OnlineBackupRequiredArguments;
import org.neo4j.com.ComException;
import org.neo4j.helpers.HostnamePort;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.util.OptionalHostnamePort;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.NullLogProvider;

public class BackupProtocolServiceStrategyTest {
    private BackupProtocolService backupProtocolService = (BackupProtocolService)Mockito.mock(BackupProtocolService.class);
    HaBackupStrategy subject;
    Config config = (Config)Mockito.mock(Config.class);
    OnlineBackupRequiredArguments requiredArgs = (OnlineBackupRequiredArguments)Mockito.mock(OnlineBackupRequiredArguments.class);
    OnlineBackupContext onlineBackupContext = (OnlineBackupContext)Mockito.mock(OnlineBackupContext.class);
    AddressResolver addressResolver = (AddressResolver)Mockito.mock(AddressResolver.class);
    HostnamePort hostnamePort = new HostnamePort("hostname:1234");
    Path backupDirectory = (Path)Mockito.mock(Path.class);
    OptionalHostnamePort userSpecifiedHostname = new OptionalHostnamePort((String)null, null, null);

    @Before
    public void setup() {
        Mockito.when((Object)this.onlineBackupContext.getRequiredArguments()).thenReturn((Object)this.requiredArgs);
        Mockito.when((Object)this.addressResolver.resolveCorrectHAAddress((Config)ArgumentMatchers.any(), (OptionalHostnamePort)ArgumentMatchers.any())).thenReturn((Object)this.hostnamePort);
        this.subject = new HaBackupStrategy(this.backupProtocolService, this.addressResolver, (LogProvider)NullLogProvider.getInstance(), 0L);
    }

    @Test
    public void incrementalBackupsAreDoneAgainstResolvedAddress() {
        Fallible state = this.subject.performIncrementalBackup(this.backupDirectory, this.config, this.userSpecifiedHostname);
        ((BackupProtocolService)Mockito.verify((Object)this.backupProtocolService)).doIncrementalBackup((String)ArgumentMatchers.eq((Object)this.hostnamePort.getHost()), ArgumentMatchers.eq((int)this.hostnamePort.getPort()), (Path)ArgumentMatchers.any(), (ConsistencyCheck)ArgumentMatchers.eq((Object)ConsistencyCheck.NONE), ArgumentMatchers.anyLong(), (Config)ArgumentMatchers.any());
        Assert.assertEquals((Object)BackupStageOutcome.SUCCESS, (Object)state.getState());
    }

    @Test
    public void exceptionsDuringIncrementalBackupAreMarkedAsFailedBackups() {
        IncrementalBackupNotPossibleException expectedException = new IncrementalBackupNotPossibleException("Expected test message", (Throwable)new RuntimeException("Expected cause"));
        Mockito.when((Object)this.backupProtocolService.doIncrementalBackup((String)ArgumentMatchers.any(), ArgumentMatchers.anyInt(), (Path)ArgumentMatchers.any(), (ConsistencyCheck)ArgumentMatchers.eq((Object)ConsistencyCheck.NONE), ArgumentMatchers.anyLong(), (Config)ArgumentMatchers.any())).thenThrow(new Throwable[]{expectedException});
        Fallible state = this.subject.performIncrementalBackup(this.backupDirectory, this.config, this.userSpecifiedHostname);
        Assert.assertEquals((Object)BackupStageOutcome.FAILURE, (Object)state.getState());
        Assert.assertEquals((Object)((Object)expectedException), state.getCause().get());
    }

    @Test
    public void fullBackupUsesResolvedAddress() {
        Fallible state = this.subject.performFullBackup(this.backupDirectory, this.config, this.userSpecifiedHostname);
        ((BackupProtocolService)Mockito.verify((Object)this.backupProtocolService)).doFullBackup((String)ArgumentMatchers.any(), ArgumentMatchers.anyInt(), (Path)ArgumentMatchers.any(), (ConsistencyCheck)ArgumentMatchers.eq((Object)ConsistencyCheck.NONE), (Config)ArgumentMatchers.any(), ArgumentMatchers.anyLong(), ArgumentMatchers.anyBoolean());
        Assert.assertEquals((Object)BackupStageOutcome.SUCCESS, (Object)state.getState());
    }

    @Test
    public void fullBackupFailsWithCauseOnException() {
        Mockito.when((Object)this.backupProtocolService.doFullBackup((String)ArgumentMatchers.any(), ArgumentMatchers.anyInt(), (Path)ArgumentMatchers.any(), (ConsistencyCheck)ArgumentMatchers.any(), (Config)ArgumentMatchers.any(), ArgumentMatchers.anyLong(), ArgumentMatchers.anyBoolean())).thenThrow(ComException.class);
        Fallible state = this.subject.performFullBackup(this.backupDirectory, this.config, this.userSpecifiedHostname);
        Assert.assertEquals((Object)BackupStageOutcome.WRONG_PROTOCOL, (Object)state.getState());
        Assert.assertEquals(ComException.class, state.getCause().get().getClass());
    }
}

